/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeProvider;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AbstractPropertyGeneral;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.lib.java.Equals;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractPropertyGeneralWithCategorySelection
extends AbstractPropertyGeneral
implements IObjectTypeCategoryChangeProvider {
    private List<ObjectTypeCategory> allCategories;
    private final Set<IObjectTypeCategoryChangeListener> objectTypeCategoryChangeListeners = new HashSet<IObjectTypeCategoryChangeListener>();

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.objectTypeCategoryChangeListeners.clear();
        Composite base = this.getPropertyPage_internal(parent);
        Combo categoryCombo = this.getCategoryCombo();
        assert (categoryCombo != null) : "Combo for category selection is null";
        this.allCategories = this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.getDataType().getCockpitDataTypeID());
        categoryCombo.add(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY);
        for (ObjectTypeCategory category : this.allCategories) {
            categoryCombo.add(category.getDisplayName());
        }
        ObjectTypeCategoryID startingCategory = this.getCategoryIDFromAttributeOwner();
        if (startingCategory != null) {
            int i = 0;
            while (i < this.allCategories.size()) {
                if (startingCategory.equals((Object)this.allCategories.get(i).getObjectTypeCategoryID())) {
                    categoryCombo.select(i + 1);
                }
                ++i;
            }
        } else {
            categoryCombo.select(0);
        }
        if (this.hasCategoryChangePermission()) {
            categoryCombo.setEnabled(true);
            categoryCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPropertyGeneralWithCategorySelection.this.notifyObjectTypeCategoryChangeListener();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        } else {
            categoryCombo.setEnabled(false);
        }
        return base;
    }

    protected abstract Combo getCategoryCombo();

    protected abstract ObjectTypeCategoryID getCategoryIDFromAttributeOwner();

    protected abstract boolean hasCategoryChangePermission();

    public boolean isCategoryChanged() {
        return !Equals.equals((Object)this.getCategoryIDFromAttributeOwner(), (Object)this.getSelectedCategoryID());
    }

    private ObjectTypeCategory getSelectedCategory() {
        int selectionIndex = this.getCategoryCombo().getSelectionIndex();
        if (selectionIndex == 0) {
            return null;
        }
        return this.allCategories.get(selectionIndex - 1);
    }

    public ObjectTypeCategoryID getSelectedCategoryID() {
        ObjectTypeCategory category = this.getSelectedCategory();
        if (category != null) {
            return category.getObjectTypeCategoryID();
        }
        return null;
    }

    @Override
    public void addCategoryChangeListener(IObjectTypeCategoryChangeListener listener, boolean fireNotifyEventOnAdd) {
        this.objectTypeCategoryChangeListeners.add(listener);
        if (fireNotifyEventOnAdd) {
            listener.categoryChanged(this.getSelectedCategory());
        }
    }

    @Override
    public void removeCategoryChangeListener(IObjectTypeCategoryChangeListener listener) {
        this.objectTypeCategoryChangeListeners.remove(listener);
    }

    private void notifyObjectTypeCategoryChangeListener() {
        ObjectTypeCategory category = this.getSelectedCategory();
        for (IObjectTypeCategoryChangeListener listener : this.objectTypeCategoryChangeListeners) {
            listener.categoryChanged(category);
        }
    }
}

