/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.PropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.itemeditors.IPropertiesSupport;
import com.arcway.cockpit.frame.client.global.gui.views.project.RootEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFolder;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.lib.ui.editor.repository.RepositoryEditorFactory;
import com.arcway.frontend.eclipse.interFace.repositoryproviders.EclipseFrontendRepositoryReference;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

public class CEProperties {
    private static final Set<String> cockpitTypesToBeEditedInPropertiesDialogue = new HashSet<String>(Arrays.asList("frame.project", "com.arcway.cockpit.section", "com.arcway.cockpit.plan", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, "com.arcway.cockpit.stakeholderrole", "com.arcway.cockpit.stakeholder", "dcm.category", "dcm.documentcontainer", "dcm.filesystemlink", "dcm.weblink", "ucm.category", "ucm.useCase", "ucm.Scenario", "ucm.ActionStep", "ppm2.projectplan", "ppm2.task", "ppm2.workitem"));
    private static boolean earlyInitializationTriggered = false;
    private static Map<String, IPropertiesSupport> map_cockpitTypeID_propertiesSupport;

    public static void initialise() {
        CEProperties.initialisePropertiesSupports();
    }

    public static Input checkSuitabilityForPropertiesCommand(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return CEProperties.checkSuitabilityForPropertiesCommand(structuredSelection.toList());
        }
        return null;
    }

    public static Input checkSuitabilityForPropertiesCommand(Collection<?> selectedItems) {
        ArrayList<ICockpitProjectData> itemsToEdit = new ArrayList<ICockpitProjectData>();
        String projectUID = null;
        PropertiesMethod method = null;
        if (selectedItems != null) {
            boolean suitable = true;
            for (Object selectedItem : selectedItems) {
                Object translatedItem = CockpitSelectionService.translateSelectedItem(selectedItem);
                if (translatedItem instanceof ICockpitProjectData) {
                    ICockpitProjectData selectedCockpitItem = (ICockpitProjectData)translatedItem;
                    if (CEProperties.isSpecialItemWithoutProperties(selectedCockpitItem)) {
                        suitable = false;
                        break;
                    }
                    if (projectUID == null) {
                        projectUID = selectedCockpitItem.getProjectUID();
                        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                        if (projectAgent == null || !projectAgent.isOpened()) {
                            suitable = false;
                            break;
                        }
                    } else if (!projectUID.equals(selectedCockpitItem.getProjectUID())) {
                        suitable = false;
                        break;
                    }
                    if (method == null) {
                        method = cockpitTypesToBeEditedInPropertiesDialogue.contains(selectedCockpitItem.getTypeID()) ? PropertiesMethod.PropertiesDialogue : PropertiesMethod.FormsEditor;
                    } else if (method == PropertiesMethod.PropertiesDialogue && !cockpitTypesToBeEditedInPropertiesDialogue.contains(selectedCockpitItem.getTypeID()) || method == PropertiesMethod.FormsEditor && cockpitTypesToBeEditedInPropertiesDialogue.contains(selectedCockpitItem.getTypeID())) {
                        suitable = false;
                        break;
                    }
                    itemsToEdit.add(selectedCockpitItem);
                    continue;
                }
                suitable = false;
                break;
            }
            if (suitable) {
                InputForFormsEditor inputForFormsEditor;
                if (method == PropertiesMethod.PropertiesDialogue) {
                    InputForPropertiesDialogue inputForPropertiesDialogue = CEProperties.getInputForPropertiesDialogue(itemsToEdit);
                    if (inputForPropertiesDialogue != null) {
                        return new Input(projectUID, PropertiesMethod.PropertiesDialogue, inputForPropertiesDialogue);
                    }
                } else if (method == PropertiesMethod.FormsEditor && (inputForFormsEditor = CEProperties.getInputForFormsEditor(itemsToEdit)) != null) {
                    return new Input(projectUID, PropertiesMethod.FormsEditor, inputForFormsEditor);
                }
            }
        }
        return null;
    }

    private static InputForPropertiesDialogue getInputForPropertiesDialogue(ArrayList<ICockpitProjectData> itemsToEdit) {
        if (itemsToEdit.size() > 1) {
            return null;
        }
        ArrayList<IPropertiesListEntry> matchingProviders = new ArrayList<IPropertiesListEntry>();
        ArrayList<IPropertiesListEntry> matchingProvidersWithoutLicense = new ArrayList<IPropertiesListEntry>();
        ICockpitProjectData[] itemsToEditAsArray = itemsToEdit.toArray(new ICockpitProjectData[itemsToEdit.size()]);
        List<IPropertiesListEntry> providers = ExtensionMgr.getDefault().getAllPropertiesProvider();
        for (IPropertiesListEntry entry : providers) {
            if (!entry.providesPropertiesFor(itemsToEditAsArray)) continue;
            matchingProviders.add(entry);
            if (CEProperties.checkModificationLicense(entry, itemsToEdit)) continue;
            matchingProvidersWithoutLicense.add(entry);
        }
        if (matchingProviders.size() > matchingProvidersWithoutLicense.size()) {
            return new InputForPropertiesDialogue(itemsToEdit, matchingProviders, matchingProvidersWithoutLicense);
        }
        return null;
    }

    private static InputForFormsEditor getInputForFormsEditor(ArrayList<ICockpitProjectData> itemsToEdit) {
        for (ICockpitProjectData itemToEdit : itemsToEdit) {
            IPropertiesSupport propertiesSupport;
            if (CEProperties.checkLicense(itemToEdit, (propertiesSupport = CEProperties.getPropertiesSupport(itemToEdit.getTypeID())).getRequiredLicenseTypeForModification())) continue;
            return null;
        }
        return new InputForFormsEditor(itemsToEdit);
    }

    public static void openProperties(ISelection selection, IWorkbenchPage triggeringWorkbenchPage) {
        CEProperties.openProperties(CEProperties.checkSuitabilityForPropertiesCommand(selection), triggeringWorkbenchPage);
    }

    public static void openProperties(Collection<?> selectedItems, IWorkbenchPage triggeringWorkbenchPage) {
        CEProperties.openProperties(CEProperties.checkSuitabilityForPropertiesCommand(selectedItems), triggeringWorkbenchPage);
    }

    public static void openProperties(Input input, IWorkbenchPage triggeringWorkbenchPage) {
        CEProperties.openProperties(input, triggeringWorkbenchPage, false);
    }

    public static void openProperties(Input input, IWorkbenchPage triggeringWorkbenchPage, boolean startInEditModeRequested) {
        if (input != null) {
            if (input.getMethod() == PropertiesMethod.PropertiesDialogue) {
                CEProperties.openPropertiesInPropertiesDialogue(input, triggeringWorkbenchPage);
            } else if (input.getMethod() == PropertiesMethod.FormsEditor) {
                CEProperties.openPropertiesInFormsEditor(input, triggeringWorkbenchPage, startInEditModeRequested);
            }
        }
    }

    private static void openPropertiesInPropertiesDialogue(Input input, IWorkbenchPage triggeringWorkbenchPage) {
        InputForPropertiesDialogue inputForPropertiesDialogue = (InputForPropertiesDialogue)input.getMethodSpecificInput();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(input.getProjectUID());
        ModificationProblem modProblem = null;
        Throwable serverException = null;
        try {
            EOLock conflictingLock = projectAgent.getLockManager().anotherClientHasProjectLock();
            if (conflictingLock != null) {
                modProblem = new ModificationProblem(conflictingLock, Messages.getString("PropertiesDialogue.EditImpossible"));
            }
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            modProblem = new ModificationProblem((Exception)serverException, Messages.getString("PropertiesDialogue.EditImpossible"));
        }
        if (modProblem != null) {
            ArrayList<ModificationProblem> mpProblems = new ArrayList<ModificationProblem>();
            mpProblems.add(modProblem);
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mpProblems, triggeringWorkbenchPage.getWorkbenchWindow().getShell());
            mpDialog.open();
        } else {
            ICockpitProjectData[] itemsAsArray = inputForPropertiesDialogue.getItems().toArray(new ICockpitProjectData[inputForPropertiesDialogue.getItems().size()]);
            PropertiesDialog dialog = new PropertiesDialog(triggeringWorkbenchPage, projectAgent, itemsAsArray);
            for (IPropertiesListEntry entry : inputForPropertiesDialogue.getMatchingProviders()) {
                IPropertiesListEntry[] childEntries;
                if (!CEProperties.checkShowLicense(entry, inputForPropertiesDialogue.getItems())) continue;
                IModificationProblem problem = entry.init(itemsAsArray, dialog, false);
                if (problem == null && (childEntries = entry.getPropertyChildren1()) != null && (problem = CEProperties.initChildProperties(childEntries, itemsAsArray, dialog)) != null) {
                    CEProperties.cancelInitialisedEntry(entry);
                }
                if (problem != null) {
                    switch (problem.getSeverity()) {
                        case 2: {
                            ArrayList<IModificationProblem> mpProblems = new ArrayList<IModificationProblem>();
                            mpProblems.add(problem);
                            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mpProblems, triggeringWorkbenchPage.getWorkbenchWindow().getShell());
                            mpDialog.open();
                            CEProperties.cancelInitialisedEntriesIncludingChildEntries(dialog.getRootProperties());
                            return;
                        }
                    }
                    continue;
                }
                dialog.addRootProperty(entry);
            }
            dialog.open();
        }
    }

    private static IModificationProblem initChildProperties(IPropertiesListEntry[] entries, ICockpitProjectData[] itemsAsArray, IPropertiesDialog dialog) {
        int index = 0;
        while (index < entries.length) {
            if (entries[index].providesPropertiesFor(itemsAsArray)) {
                IModificationProblem problem = entries[index].init(itemsAsArray, dialog, false);
                if (problem == null) {
                    IPropertiesListEntry[] childEntries = entries[index].getPropertyChildren1();
                    if (childEntries != null) {
                        problem = CEProperties.initChildProperties(childEntries, itemsAsArray, dialog);
                    }
                    if (problem != null) {
                        CEProperties.cancelInitialisedEntry(entries[index]);
                    }
                }
                if (problem != null) {
                    int indexOfAlreadyInitialisedEntry = 0;
                    while (indexOfAlreadyInitialisedEntry < index) {
                        CEProperties.cancelInitialisedEntriesIncludingChildEntries(Collections.singleton(entries[indexOfAlreadyInitialisedEntry]));
                        ++indexOfAlreadyInitialisedEntry;
                    }
                    return problem;
                }
            }
            ++index;
        }
        return null;
    }

    private static void cancelInitialisedEntry(IPropertiesListEntry entry) {
        entry.cancelPropertyChanges1();
    }

    private static void cancelInitialisedEntriesIncludingChildEntries(Collection<IPropertiesListEntry> entries) {
        for (IPropertiesListEntry entry : entries) {
            entry.cancelPropertyChanges1();
            IPropertiesListEntry[] childEntries = entry.getPropertyChildren1();
            if (childEntries == null) continue;
            CEProperties.cancelInitialisedEntriesIncludingChildEntries(Arrays.asList(childEntries));
        }
    }

    private static boolean isSpecialItemWithoutProperties(ICockpitProjectData item) {
        if (item instanceof ReportTemplateFolder) {
            ReportTemplateFolder folder = (ReportTemplateFolder)item;
            String projectUID = folder.getProjectUID();
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            IAttributeOwner parent = projectAgent.getChildRelationsManager().getParent(folder);
            if (parent.equals(projectAgent.getProject())) {
                return true;
            }
        } else if (item instanceof RootEntry) {
            return true;
        }
        return false;
    }

    private static void openPropertiesInFormsEditor(Input input, IWorkbenchPage triggeringWorkbenchPage, boolean startInEditModeRequested) {
        InputForFormsEditor inputForFormsEditor = (InputForFormsEditor)input.getMethodSpecificInput();
        for (ICockpitProjectData itemToEdit : inputForFormsEditor.getItems()) {
            IPropertiesSupport propertiesSupport;
            if (CEProperties.checkLicense(itemToEdit, (propertiesSupport = CEProperties.getPropertiesSupport(itemToEdit.getTypeID())).getRequiredLicenseTypeForModification())) continue;
            return;
        }
        EclipseWindow window = new EclipseWindow(triggeringWorkbenchPage);
        for (ICockpitProjectData itemToBeEdited : inputForFormsEditor.getItems()) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(itemToBeEdited.getProjectUID());
            IRepositoryInterfaceRO repository = projectAgent.getRepositoryInterface();
            try {
                IRepositorySnapshotRO snapshot = repository.openSnapshot(RepositorySamples.getSnapshotID((IRepositoryObjectSample)repository.sampleCurrentSnapshotInformation(), (IRepositoryTypeManagerRO)repository.getTypeManager()));
                try {
                    IRepositoryObject repositoryObject = projectAgent.findRepositoryObject(snapshot, new CockpitDataID(itemToBeEdited.getTypeID(), itemToBeEdited.getUID()));
                    if (repositoryObject == null) continue;
                    RepositoryObjectReference repositoryObjectReference = new RepositoryObjectReference(repositoryObject);
                    RepositoryEditorFactory.Input editorInput = RepositoryEditorFactory.createEditorInputForObjectModification((IRepositoryInterfaceRO)repository, (IRepositoryObjectReference)repositoryObjectReference);
                    window.openEditor((Object)editorInput, startInEditModeRequested);
                }
                finally {
                    snapshot.closeSnapshot();
                }
            }
            catch (EclipseFrontendRepositoryReference.EXRepositoryHasNoRepositoryProvider e) {
                throw new RuntimeException(e);
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean checkModificationLicense(IPropertiesListEntry entry, Collection<ICockpitProjectData> items) {
        for (ICockpitProjectData item : items) {
            if (CEProperties.checkLicense(item, entry.getRequiredLicenseTypeForModifying(item))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkShowLicense(IPropertiesListEntry entry, Collection<ICockpitProjectData> items) {
        for (ICockpitProjectData item : items) {
            if (CEProperties.checkLicense(item, entry.getRequiredLicenseTypeForShowing(item))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkLicense(ICockpitProjectData item, IClientFunctionLicenseType licenseType) {
        if (licenseType != null) {
            IClientFunctionLicenseManager licenseManager = ProjectMgr.getProjectMgr().getProjectAgent(item.getProjectUID()).getServerLicenseManager();
            return licenseManager.isLicenseOperationAllowed(licenseType);
        }
        return true;
    }

    private static void initialisePropertiesSupports() {
        if (!earlyInitializationTriggered) {
            map_cockpitTypeID_propertiesSupport = new HashMap<String, IPropertiesSupport>();
            for (IPropertiesSupport propertiesSupport : ExtensionMgr.getDefault().getAllPropertiesSupports()) {
                map_cockpitTypeID_propertiesSupport.put(propertiesSupport.getTypeID(), propertiesSupport);
            }
            earlyInitializationTriggered = true;
        }
    }

    public static IPropertiesSupport getPropertiesSupport(String cockpitTypeID) {
        CEProperties.initialisePropertiesSupports();
        return map_cockpitTypeID_propertiesSupport.get(cockpitTypeID);
    }

    public static class Input {
        private final String projectUID;
        private final PropertiesMethod method;
        private final Object methodSpecificInput;

        public Input(String projectUID, PropertiesMethod method, Object methodSpecificInput) {
            this.projectUID = projectUID;
            this.method = method;
            this.methodSpecificInput = methodSpecificInput;
        }

        protected String getProjectUID() {
            return this.projectUID;
        }

        protected PropertiesMethod getMethod() {
            return this.method;
        }

        protected Object getMethodSpecificInput() {
            return this.methodSpecificInput;
        }
    }

    public static class InputForFormsEditor {
        private final Collection<ICockpitProjectData> items;

        public InputForFormsEditor(Collection<ICockpitProjectData> items) {
            this.items = items;
        }

        protected Collection<ICockpitProjectData> getItems() {
            return this.items;
        }
    }

    public static class InputForPropertiesDialogue {
        private final Collection<ICockpitProjectData> items;
        private final List<IPropertiesListEntry> matchingProviders;
        private final List<IPropertiesListEntry> matchingProvidersWithoutLicense;

        public InputForPropertiesDialogue(Collection<ICockpitProjectData> items, List<IPropertiesListEntry> matchingProviders, List<IPropertiesListEntry> matchingProvidersWithoutLicense) {
            this.items = items;
            this.matchingProviders = matchingProviders;
            this.matchingProvidersWithoutLicense = matchingProvidersWithoutLicense;
        }

        protected Collection<ICockpitProjectData> getItems() {
            return this.items;
        }

        protected List<IPropertiesListEntry> getMatchingProviders() {
            return this.matchingProviders;
        }

        protected List<IPropertiesListEntry> getMatchingProvidersWithoutLicense() {
            return this.matchingProvidersWithoutLicense;
        }
    }

    public static enum PropertiesMethod {
        PropertiesDialogue,
        FormsEditor;

    }
}

