/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.preferencePages;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import de.plans.psc.client.communication.ServerConnection;
import java.util.Collection;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class OfflineModePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ENTER_OFF_MODE_WITHOUT_ADVICE = "enterOfflineMode.WithoutConfirmation";

    public OfflineModePreferencePage() {
        super(1);
        IPreferenceStore store = FramePlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        FramePlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected void createFieldEditors() {
        RadioGroupFieldEditor askForConfirmation = new RadioGroupFieldEditor(ENTER_OFF_MODE_WITHOUT_ADVICE, Messages.getString("OfflineModePrefPage.LabelText"), 1, (String[][])new String[][]{{Messages.getString("OfflineModePrefPage.RadioLabel.EnterWithAdvice"), "never"}, {Messages.getString("OfflineModePrefPage.RadioLabel.EnterWithoutAdvice"), "always"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)askForConfirmation);
        boolean noneProxySupportsOfflineMode = true;
        Collection<ServerConnection> serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
        for (ServerConnection sc : serverConnections) {
            String serverID = sc.getServerID();
            IProjectManagerServerProxy pMServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            if (pMServerProxy.isServerAlwaysConnected()) continue;
            noneProxySupportsOfflineMode = false;
            break;
        }
        if (noneProxySupportsOfflineMode) {
            askForConfirmation.setEnabled(false, this.getFieldEditorParent());
        }
    }
}

