/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.preferencePages;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.ClientModuleLicense;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.IClientModuleLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientProductOrModuleLicense;
import com.arcway.cockpit.frame.client.global.license.ILocalClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.network.HostNameRetriever;
import com.arcway.lib.network.UserNameRetriever;
import de.plans.fmca.client.PSCServices;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.communication.ServerConnection;
import java.io.File;
import java.net.URLEncoder;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractLicensesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final ILogger LOGGER = Logger.getLogger(AbstractLicensesPreferencePage.class);
    private static final int LICENSE_NAME_COL = 0;
    private static final int LICENSE_PROVIDER_COL = 1;
    private static final int LICENSE_START_COL = 2;
    private static final int LICENSE_END_COL = 3;
    private static final int LICENSE_DESCR_COL = 4;
    public static final String LICENSE_EMAIL_ADRESS = "license@arcway.com";
    protected static final IClientProductOrModuleLicense EMPTY_LINE = new ClientModuleLicense("DummyLicense_ForEmptyLine", null, null, null, null, "");
    private IBrowser hintBrowser;
    private TableViewer licensesTable;
    private final String[] tableColNames = new String[]{Messages.getString("LicensesPropertyPage.type"), Messages.getString("AbstractLicensesPreferencePage.source"), Messages.getString("LicensesPropertyPage.valid_from"), Messages.getString("LicensesPropertyPage.expires"), Messages.getString("LicensesPropertyPage.description")};

    public AbstractLicensesPreferencePage() {
        IPreferenceStore store = FramePlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.noDefaultAndApplyButton();
    }

    private static String getUsernameOrUnknown() {
        String username;
        try {
            username = UserNameRetriever.getUsername();
        }
        catch (UserNameRetriever.UnableToRetrieveUsernameException e) {
            username = "unkown";
        }
        return username;
    }

    private static String getHostNameOrUnknownHostName() {
        String hostid;
        try {
            hostid = "@" + HostNameRetriever.getHostname();
        }
        catch (HostNameRetriever.UnableToRetrieveHostnameException e) {
            hostid = "@unkown";
        }
        return hostid;
    }

    private static String getProductName() {
        String productName = "##ProductName=" + Platform.getProduct().getName();
        return productName;
    }

    private static String getVersionInfo() {
        PSCApplicationIdentifier applicationIdentifier = PSCServices.getServiceFacade().getApplicationIdentifier();
        String clientVersion = applicationIdentifier.getClientVersion();
        String clientBuild = applicationIdentifier.getClientBuild();
        String versionInfo = ";Version=" + clientVersion;
        versionInfo = String.valueOf(versionInfo) + ";Build=" + clientBuild;
        return versionInfo;
    }

    public static String getSubject() {
        return AbstractLicensesPreferencePage.mailEncode(String.valueOf(Messages.getString("AbstractLicensesPreferencePage.license_order")) + " (" + AbstractLicensesPreferencePage.getUsernameOrUnknown() + AbstractLicensesPreferencePage.getHostNameOrUnknownHostName() + AbstractLicensesPreferencePage.getProductName() + AbstractLicensesPreferencePage.getVersionInfo() + ") ");
    }

    protected Control createContents(final Composite parent) {
        GridData btnLoadGridData;
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        this.hintBrowser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)base, (int)2048);
        Control browserControl = this.hintBrowser.getSWTControl();
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        browserControl.setLayoutData((Object)gd);
        Label dummy = new Label(base, 0);
        dummy.setVisible(false);
        Label tableLabel = new Label(base, 0);
        tableLabel.setLayoutData((Object)new GridData(768));
        tableLabel.setText(Messages.getString("LicensesPropertyPage.loaded_licenses"));
        this.licensesTable = new TableViewer(base, 34816);
        gd = new GridData(1808);
        gd.heightHint = 100;
        this.licensesTable.getTable().setLayoutData((Object)gd);
        this.licensesTable.getTable().setLinesVisible(true);
        this.licensesTable.getTable().setHeaderVisible(true);
        this.licensesTable.setColumnProperties(this.tableColNames);
        String[] stringArray = this.tableColNames;
        int n = this.tableColNames.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            TableColumn col = new TableColumn(this.licensesTable.getTable(), 16384);
            col.setText(element);
            col.pack();
            ++n2;
        }
        LabelAndContentProvider cp = new LabelAndContentProvider();
        this.licensesTable.setContentProvider((IContentProvider)cp);
        this.licensesTable.setLabelProvider((IBaseLabelProvider)cp);
        this.licensesTable.setInput((Object)this);
        TableColumn[] columns = this.licensesTable.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            if (i != 4) {
                columns[i].pack();
            }
            ++i;
        }
        Composite buttonComposite = new Composite(base, 0);
        GridData buttonCompositeGridData = new GridData(4, 4, true, false);
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        GridLayout buttonCompositeLayout = new GridLayout(2, false);
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        String SYSPROP_ECLIPSE_PRODUCT = "eclipse.product";
        boolean isReader = false;
        try {
            String eclipseProduct = System.getProperty("eclipse.product");
            if ("com.arcway.cockpit.enterprisereader.cockpitide".equals(eclipseProduct) || "com.arcway.cockpit.enterprisereader.cockpitrcp".equals(eclipseProduct) || "com.arcway.cockpit.freereader.cockpitide".equals(eclipseProduct) || "com.arcway.cockpit.freereader.cockpitrcp".equals(eclipseProduct)) {
                isReader = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to read System Property eclipse.product", (Throwable)e);
        }
        if (isReader) {
            Label btnDummy = new Label(buttonComposite, 0);
            btnLoadGridData = new GridData(3, 2, true, true);
            btnDummy.setLayoutData((Object)btnLoadGridData);
            btnDummy.setText("");
        } else {
            Button btnLoadLicense = new Button(buttonComposite, 8);
            btnLoadGridData = new GridData(3, 2, true, true);
            btnLoadLicense.setLayoutData((Object)btnLoadGridData);
            btnLoadLicense.setText(Messages.getString("LicensesPropertyPage.load_license"));
            btnLoadLicense.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractLicensesPreferencePage.this.loadLicenseFile();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Button btnLicenseStatus = new Button(buttonComposite, 8);
        GridData btnStatusGridData = new GridData(2, 2, false, true);
        btnLicenseStatus.setLayoutData((Object)btnStatusGridData);
        btnLicenseStatus.setText(Messages.getString("LicensesPropertyPage.license_status"));
        btnLicenseStatus.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLicensesPreferencePage.this.showLicenseStatusDetails(parent.getShell());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        IntegerFieldEditor durationFieldEditor = new IntegerFieldEditor("License.WarningBeforeExpiration", Messages.getString("AbstractLicensePreferencePage.LicenseWarningDurationPreference.Label"), this.getFieldEditorParent());
        durationFieldEditor.setValidRange(0, 365);
        this.addField((FieldEditor)durationFieldEditor);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        FramePlugin.getDefault().savePluginPreferences();
        return ok;
    }

    private void loadLicenseFile() {
        FileChooserDialog fileChooserDialog = new FileChooserDialog(new String[]{"license"}, this.getShell());
        File licenseFile = fileChooserDialog.openForLoad();
        if (licenseFile != null) {
            ThreeTuple<Integer, Boolean, List<String>> result = this.getLocalProductLicenseManager().importAdditionalLicenseFile(licenseFile);
            if ((Integer)result.getComponent1() != -1) {
                TableColumn[] cols;
                if ((Integer)result.getComponent1() == 2) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("LicensesPropertyPage.warning"), (String)Messages.getString("LicensesPropertyPage.use_ws"));
                }
                if (!((List)result.getComponent3()).isEmpty()) {
                    String message = com.arcway.cockpit.frame.client.global.license.Messages.getString("LicensePreferencePage.ProblemsWhenImportingLicenseFile.Message");
                    message = String.valueOf(message) + "\n\n";
                    for (String problem : (List)result.getComponent3()) {
                        message = String.valueOf(message) + "* " + problem + "\n";
                    }
                    MessageDialog.openWarning((Shell)this.getShell(), (String)com.arcway.cockpit.frame.client.global.license.Messages.getString("LicensesPreferencePage.ProblemsWhenImportingLicenseFile.Title"), (String)message);
                } else if (!((Boolean)result.getComponent2()).booleanValue()) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)com.arcway.cockpit.frame.client.global.license.Messages.getString("LicensesPreferencePage.ProblemsWhenImportingLicenseFile.Title"), (String)com.arcway.cockpit.frame.client.global.license.Messages.getString("ProductLicenseManager.LicenseFileDoesNotContainAnyApplicableLicense"));
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)com.arcway.cockpit.frame.client.global.license.Messages.getString("LicensesPreferencePage.LicenseImportingSuccessful.Title"), (String)com.arcway.cockpit.frame.client.global.license.Messages.getString("LicensesPreferencePage.LicenseImportingSuccessful.Message"));
                }
                this.refresh();
                TableColumn[] tableColumnArray = cols = this.licensesTable.getTable().getColumns();
                int n = cols.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn element = tableColumnArray[n2];
                    element.pack();
                    ++n2;
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("LicensesPropertyPage.error"), (String)Messages.getString("LicensesPropertyPage.could_not_load"));
            }
        }
    }

    private void showLicenseStatusDetails(Shell parentShell) {
        final String licenseStatusAsHTML = this.getLocalProductLicenseManager().getLicenseFilesDetails();
        Dialog dialogue = new Dialog(parentShell){

            public void create() {
                this.setShellStyle(this.getShellStyle() | 0x10);
                super.create();
            }

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(Messages.getString("LicensesPropertyPage.license_status"));
                Composite baseComposite = new Composite(parent, 2048);
                GridData baseGridData = new GridData(4, 4, true, true);
                baseComposite.setLayoutData((Object)baseGridData);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                baseComposite.setLayout((Layout)layout);
                IBrowser browser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)baseComposite, (int)0);
                browser.setHtml(licenseStatusAsHTML);
                Control browserControl = browser.getSWTControl();
                GridData gridData = new GridData(4, 4, true, true);
                gridData.widthHint = 1000;
                gridData.heightHint = 450;
                browserControl.setLayoutData((Object)gridData);
                return browserControl;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dialogue.open();
    }

    private void refresh() {
        Color bground = Display.getDefault().getSystemColor(1);
        int licenseConfiguration = ProjectMgr.getProjectMgr().getLicenseConfiguration();
        if (licenseConfiguration == 1) {
            this.hintBrowser.setHtml(this.getHTMLTextForFullLicense(bground, 2));
        } else if (licenseConfiguration == 2) {
            this.hintBrowser.setHtml(AbstractLicensesPreferencePage.getHTMLTextForReaderVersion(bground, 2));
        } else if (licenseConfiguration == 3) {
            this.hintBrowser.setHtml(this.getHTMLTextForExpiredLicense(bground, 2));
        } else if (licenseConfiguration == 4) {
            this.hintBrowser.setHtml(this.getHTMLTextForNoLicense(bground, 2));
        }
        this.licensesTable.refresh();
    }

    public void init(IWorkbench workbench) {
    }

    private String getHTMLTextForNoLicense(Color background, int fontSize) {
        String red = Integer.toHexString(background.getRed());
        String green = Integer.toHexString(background.getGreen());
        String blue = Integer.toHexString(background.getBlue());
        String msg = Messages.getString("LicensesPropertyPage.no_license_available");
        String doExtend = Messages.getString("LicensePreferencePage.buy_license");
        String email = LICENSE_EMAIL_ADRESS;
        return "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body style=\"background-color:#" + red + green + blue + "; font-family:Arial,Helvetica;\">" + "<font size=\"" + String.valueOf(fontSize) + "\">" + "<p align=\"center\">" + "<p align=\"left\">" + msg + "</p>" + "<p align=\"left\">" + doExtend + " <a href=\"mailto:" + email + "?subject=" + AbstractLicensesPreferencePage.getSubject() + "\">" + email + "</a>." + "</p>" + AbstractLicensesPreferencePage.getHTMLRefereToParagraph() + "</p>" + "</font>" + "</body>" + "</html>";
    }

    private String getHTMLTextForExpiredLicense(Color background, int fontSize) {
        String red = Integer.toHexString(background.getRed());
        String green = Integer.toHexString(background.getGreen());
        String blue = Integer.toHexString(background.getBlue());
        String expired = Messages.getString("LicensesPropertyPage.license_expired");
        String howToOrder1 = Messages.getString("EvaluationHintDialog.use_unlimited1");
        String email = LICENSE_EMAIL_ADRESS;
        String howToOrder2 = Messages.getString("EvaluationHintDialog.use_unlimited2");
        return "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body style=\"background-color:#" + red + green + blue + "\">" + "<font family=\"HELVETICA\" size=\"" + String.valueOf(fontSize) + "\">" + "<p align=\"center\">" + "<p align=\"left\">" + expired + "</p>" + "<p align=\"left\">" + howToOrder1 + " <a href=\"mailto:" + email + "?subject=" + AbstractLicensesPreferencePage.getSubject() + "\">" + email + "</a>." + howToOrder2 + "</p>" + AbstractLicensesPreferencePage.getHTMLRefereToParagraph() + Messages.getString("LicensesPropertyPage.1") + "</font>" + "</body>" + "</html>";
    }

    private String getHTMLTextForFullLicense(Color background, int fontSize) {
        String red = Integer.toHexString(background.getRed());
        String green = Integer.toHexString(background.getGreen());
        String blue = Integer.toHexString(background.getBlue());
        String msg = Messages.getString("LicensesPropertyPage.valid_license_available");
        String doExtend = Messages.getString("LicensePreferencePage.buy_further_license");
        String email = LICENSE_EMAIL_ADRESS;
        return "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body style=\"background-color:#" + red + green + blue + "; font-family:Arial,Helvetica;\">" + "<font size=\"" + String.valueOf(fontSize) + "\">" + "<p align=\"left\">" + msg + "</p>" + "<p align=\"left\">" + doExtend + " <a href=\"mailto:" + email + "?subject=" + AbstractLicensesPreferencePage.getSubject() + "\">" + email + "</a>." + "</p>" + AbstractLicensesPreferencePage.getHTMLRefereToParagraph() + "</font>" + "</body>" + "</html>";
    }

    public static String getHTMLTextForLimitedVersion(Color background, int fontSize) {
        String red = Integer.toHexString(background.getRed());
        String green = Integer.toHexString(background.getGreen());
        String blue = Integer.toHexString(background.getBlue());
        String limitedVersion = Messages.getString("EvaluationHintDialog.using_a_limited_version");
        String howToOrder1 = Messages.getString("EvaluationHintDialog.use_unlimited1");
        String email = LICENSE_EMAIL_ADRESS;
        String howToOrder2 = Messages.getString("EvaluationHintDialog.use_unlimited2");
        return "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body style=\"background-color:#" + red + green + blue + "; font-family:Arial,Helvetica;\">" + "<font size=\"" + String.valueOf(fontSize) + "\">" + "<p align=\"center\">" + "<p align=\"left\">" + limitedVersion + "</p>" + "<p align=\"left\">" + howToOrder1 + "<a href=\"mailto:" + email + "?subject=" + AbstractLicensesPreferencePage.getSubject() + "\">" + email + "</a>" + howToOrder2 + "</p>" + AbstractLicensesPreferencePage.getHTMLRefereToParagraph() + Messages.getString("LicensesPropertyPage.2") + "</font>" + "</body>" + "</html>";
    }

    public static String getHTMLTextForReaderVersion(Color background, int fontSize) {
        String red = Integer.toHexString(background.getRed());
        String green = Integer.toHexString(background.getGreen());
        String blue = Integer.toHexString(background.getBlue());
        String limitedVersion = Messages.getString("EvaluationHintDialog.using_a_reader_version");
        String howToOrder1 = Messages.getString("EvaluationHintDialog.use_unlimited1");
        String email = LICENSE_EMAIL_ADRESS;
        String howToOrder2 = Messages.getString("EvaluationHintDialog.use_unlimited2");
        return "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body style=\"background-color:#" + red + green + blue + "; font-family:Arial,Helvetica;\">" + "<font size=\"" + String.valueOf(fontSize) + "\">" + "<p align=\"left\">" + limitedVersion + "</p>" + "<p align=\"left\">" + howToOrder1 + "<a href=\"mailto:" + email + "?subject=" + AbstractLicensesPreferencePage.getSubject() + "\">" + email + "</a>" + howToOrder2 + "</p>" + AbstractLicensesPreferencePage.getHTMLRefereToParagraph() + "</font>" + "</body>" + "</html>";
    }

    public static String getHTMLRefereToParagraph() {
        String refID = String.valueOf(Messages.getString("EvaluationHintDialog.please_refer_to_id")) + " ";
        String refEnd = Messages.getString("EvaluationHintDialog.please_refer_to_end");
        String text = "<p align=\"left\">" + refID + "<b>" + AbstractLicensesPreferencePage.getUsernameOrUnknown() + AbstractLicensesPreferencePage.getHostNameOrUnknownHostName() + AbstractLicensesPreferencePage.getProductName() + AbstractLicensesPreferencePage.getVersionInfo() + "</b><br>" + refEnd + "</p>";
        return text;
    }

    public static String getHTMLTextForExpirationPeriod(Color background, int fontSize, long durationInDays) {
        String red = Integer.toHexString(background.getRed());
        String green = Integer.toHexString(background.getGreen());
        String blue = Integer.toHexString(background.getBlue());
        String duration = Long.toString(durationInDays);
        String licenseExpiresInDays = durationInDays > 1L ? NLS.bind((String)Messages.getString("LicenseExpirationWarningDialog.licenseExpiresInDays"), (Object)duration) : Messages.getString("LicenseExpirationWarningDialog.licenseExpiresTomorrow");
        String howToOrder1 = Messages.getString("LicenseExpirationWarningDialog.howToOrder1");
        String email = LICENSE_EMAIL_ADRESS;
        String howToOrder2 = Messages.getString("LicenseExpirationWarningDialog.howToOrder2");
        String prefferencePageHint = Messages.getString("LicenseExpirationWarningDialog.prefferencePageHint");
        return "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body style=\"background-color:#" + red + green + blue + "; font-family:Arial,Helvetica;\">" + "<font size=\"" + String.valueOf(fontSize) + "\">" + "<p align=\"center\">" + "<p align=\"left\"><b>" + licenseExpiresInDays + "</b></p>" + "<p align=\"left\">" + howToOrder1 + "<a href=\"mailto:" + email + "?subject=" + AbstractLicensesPreferencePage.getSubject() + "\">" + email + "</a>" + howToOrder2 + "</p>" + AbstractLicensesPreferencePage.getHTMLRefereToParagraph() + "<p align=\"left\">" + Messages.getString("LicensesPropertyPage.2") + "</p>" + "</font>" + "<font size=\"" + String.valueOf(fontSize - 1) + "\">" + "<p align=\"left\">" + prefferencePageHint + "</p>" + "</font>" + "</body>" + "</html>";
    }

    private static String mailEncode(String s) {
        StringBuffer buf = new StringBuffer(s);
        String SPACE = "--SPACE--";
        int idx = buf.toString().indexOf(" ");
        while (idx != -1) {
            buf.replace(idx, idx + 1, SPACE);
            idx = buf.toString().indexOf(" ");
        }
        buf = new StringBuffer(URLEncoder.encode(buf.toString()));
        idx = buf.toString().indexOf(SPACE);
        while (idx != -1) {
            buf.replace(idx, idx + SPACE.length(), "%20");
            idx = buf.toString().indexOf(SPACE);
        }
        return buf.toString();
    }

    private Collection<IClientProductOrModuleLicense> getLicensesWithProvider() {
        HashSet<IClientProductLicense> productLicenses = new HashSet<IClientProductLicense>();
        HashSet<IClientModuleLicense> moduleLicenses = new HashSet<IClientModuleLicense>();
        productLicenses.addAll(this.getLocalProductLicenseManager().getProductLicenses());
        moduleLicenses.addAll(this.getLocalProductLicenseManager().getModuleLicenses());
        for (ServerConnection sc : ProjectMgr.getProjectMgr().getConfiguredServerConnections()) {
            if (!sc.isConnected()) continue;
            IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(sc.getServerID());
            IClientProductLicenseManager productLicenseManager = serverProxy.getProductLicenseManager();
            productLicenses.addAll(productLicenseManager.getProductLicenses());
            moduleLicenses.addAll(productLicenseManager.getModuleLicenses());
        }
        ArrayList<IClientProductOrModuleLicense> allLicenses = new ArrayList<IClientProductOrModuleLicense>();
        allLicenses.addAll(productLicenses);
        if (!moduleLicenses.isEmpty()) {
            allLicenses.add(EMPTY_LINE);
            allLicenses.addAll(moduleLicenses);
        }
        return allLicenses;
    }

    protected abstract ILocalClientProductLicenseManager getLocalProductLicenseManager();

    private class LabelAndContentProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private final DateFormat dateFormat = DateFormat.getDateInstance(3);

        private LabelAndContentProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IClientProductOrModuleLicense license = (IClientProductOrModuleLicense)element;
            if (license == EMPTY_LINE) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    if (license instanceof IClientProductLicense) {
                        return ((IClientProductLicense)license).getType().getDisplayName();
                    }
                    if (license instanceof IClientModuleLicense) {
                        return ClientProductLicenseTypes.getModuleLicenseTypeForModuleID(((IClientModuleLicense)license).getModuleID()).getDisplayName();
                    }
                    return "";
                }
                case 1: {
                    return license.getProviderDescription();
                }
                case 4: {
                    if (license instanceof IClientProductLicense) {
                        return ((IClientProductLicense)license).getType().getDescription();
                    }
                    if (license instanceof IClientModuleLicense) {
                        return ClientProductLicenseTypes.getModuleLicenseTypeForModuleID(((IClientModuleLicense)license).getModuleID()).getDescription();
                    }
                    return "";
                }
                case 2: {
                    Timestamp startTimestamp;
                    if (license instanceof IClientProductLicense) {
                        startTimestamp = license.getStartDate();
                    } else if (license instanceof IClientModuleLicense) {
                        startTimestamp = ((IClientModuleLicense)license).getOwnStartDate();
                    } else {
                        return "";
                    }
                    Date startDate = new Date(startTimestamp.getTime());
                    return this.dateFormat.format(startDate);
                }
                case 3: {
                    Timestamp endTimestamp;
                    if (license instanceof IClientProductLicense) {
                        endTimestamp = license.getEndDate();
                    } else if (license instanceof IClientModuleLicense) {
                        endTimestamp = ((IClientModuleLicense)license).getOwnEndDate();
                    } else {
                        return "";
                    }
                    if (endTimestamp == null) {
                        return Messages.getString("LicensesPropertyPage.never");
                    }
                    Date endDate = new Date(endTimestamp.getTime());
                    return this.dateFormat.format(endDate);
                }
            }
            return "TODO";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Object[] getElements(Object inputElement) {
            return AbstractLicensesPreferencePage.this.getLicensesWithProvider().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

