/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.propertytesters;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public class PTPlanEditor
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IEditorPart) {
            if (property.equals("isInEditMode")) {
                return this.isInEditMode((IEditorPart)receiver);
            }
            if (property.equals("hasSelectedPlanElement")) {
                return this.hasSelectedPlanElement((IEditorPart)receiver);
            }
            if (property.equals("hasSelectedUniqueElement")) {
                return this.hasSelectedUniqueElement((IEditorPart)receiver);
            }
            if (property.equals("hasProjection")) {
                return PTPlanEditor.hasProjection((IEditorPart)receiver);
            }
        }
        return false;
    }

    private boolean hasSelectedUniqueElement(IEditorPart receiver) {
        ISelection selection;
        GraphicalViewer viewer;
        IExternalPlanEditorControllerExtension controllerExtension = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(receiver);
        if (controllerExtension != null && (viewer = this.getViewer(receiver)) != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement != viewer.getContents() && firstElement instanceof IPlanAgentPlanElement) {
                    IUniqueElement uniqueElement = controllerExtension.findUniqueElement((IPlanAgentPlanElement)firstElement);
                    return uniqueElement != null;
                }
            } else if (structuredSelection.size() > 1) {
                return true;
            }
        }
        return false;
    }

    private boolean hasSelectedPlanElement(IEditorPart receiver) {
        ISelection selection;
        GraphicalViewer viewer = this.getViewer(receiver);
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                return structuredSelection.getFirstElement() != viewer.getContents();
            }
            if (structuredSelection.size() > 1) {
                return true;
            }
        }
        return false;
    }

    private boolean isInEditMode(IEditorPart receiver) {
        int currentMode;
        IExternalPlanEditorControllerExtension controllerExtension = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(receiver);
        return controllerExtension != null && (currentMode = controllerExtension.getWorkingMode()) == 1;
    }

    public static boolean hasProjection(IEditorPart receiver) {
        IExternalPlanEditorControllerExtension controllerExtension = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(receiver);
        if (controllerExtension != null) {
            return controllerExtension.hasProjection();
        }
        return false;
    }

    private GraphicalViewer getViewer(IEditorPart receiver) {
        GraphicalViewer viewer = null;
        Object viewerObject = receiver.getAdapter(GraphicalViewer.class);
        if (viewerObject != null && viewerObject instanceof GraphicalViewer) {
            viewer = (GraphicalViewer)viewerObject;
        }
        return viewer;
    }
}

