/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.propertytesters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorControllerExtension;
import com.arcway.lib.java.tuples.Tuple;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.expressions.PropertyTester;

public class PTPlan
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IPlan) {
            IPlan plan = (IPlan)receiver;
            if (property.equals("isOpenInEditMode")) {
                ProjectAgent projectAgent;
                String projectUID = plan.getProjectUID();
                if (projectUID != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null && projectAgent.isOpened()) {
                    Collection<PlanEditorControllerExtension> openPlans = projectAgent.getPlanEditorManager().getPlanEditorControllerExtensions(plan);
                    for (PlanEditorControllerExtension extension : openPlans) {
                        if (extension.getWorkingMode() != 1) continue;
                        return true;
                    }
                }
            } else if (property.equals("hasAlternativeLabeling")) {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
                IAttributeTypesProvider uniqueElementAttributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
                Map<IAttributeType, Tuple<IAttributeType, IAttributeType>> nameAndDescriptionAttibuteTypes1 = PlanAgentManager.getValidNameAndDescriptionAndCommentTranslationAttributeTypes(uniqueElementAttributeTypesProvider);
                Collection<IAttributeType> attributeTypes2 = PlanAgentManager.getValidNameAttributeTypesWithoutTranslations(uniqueElementAttributeTypesProvider);
                Collection<IAttributeType> attributeTypes3 = PlanAgentManager.getValidDescriptionAttributeTypesWithoutTranslations(uniqueElementAttributeTypesProvider);
                if (nameAndDescriptionAttibuteTypes1.size() + attributeTypes2.size() + attributeTypes3.size() > 0) {
                    return true;
                }
            }
        }
        return false;
    }
}

