/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.propertytesters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.propertytesters.FramePropertyConstants;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.HierarchicalClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyUniqueElements;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeOfflineMode;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsCreate;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsNumber;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.ServerConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class FramePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Collection<ServerConnection> serverConnections;
        ServerConnection serverConnection;
        if ("onlyOneServerConfigured".equals(property)) {
            return ProjectMgr.getProjectMgr().getConfiguredServerConnections().size() == 1;
        }
        IFrameProjectAgent projectAgent = this.getProjectAgentForSelection((ISelection)receiver);
        if (projectAgent != null) {
            Arrays.sort(FramePropertyConstants.PROJECT_PERMISSION_PROPERTIES);
            if (Arrays.binarySearch(FramePropertyConstants.PROJECT_PERMISSION_PROPERTIES, property) > -1) {
                return this.testProjectPermissionProperty(projectAgent, receiver, property);
            }
            Arrays.sort(FramePropertyConstants.PROJECT_LICENSE_PROPERTIES);
            if (Arrays.binarySearch(FramePropertyConstants.PROJECT_LICENSE_PROPERTIES, property) > -1) {
                return this.testProjectLicenseProperty(projectAgent, receiver, property);
            }
            Arrays.sort(FramePropertyConstants.GENERAL_PROJECT_PROPERTIES);
            if (Arrays.binarySearch(FramePropertyConstants.GENERAL_PROJECT_PROPERTIES, property) > -1) {
                return this.testGeneralProjectProperty(projectAgent, property);
            }
        }
        if ((serverConnection = this.getServerConnectionForSelection((ISelection)receiver)) == null && (serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections()).size() == 1) {
            serverConnection = serverConnections.iterator().next();
        }
        if (serverConnection != null) {
            Arrays.sort(FramePropertyConstants.SERVER_PERMISSION_PROPERTIES);
            if (Arrays.binarySearch(FramePropertyConstants.SERVER_PERMISSION_PROPERTIES, property) > -1) {
                return this.testServerPermissionProperty(serverConnection, property);
            }
            Arrays.sort(FramePropertyConstants.SERVER_LICENSE_PROPERTIES);
            if (Arrays.binarySearch(FramePropertyConstants.SERVER_LICENSE_PROPERTIES, property) > -1) {
                return this.testServerLicenseProperty(serverConnection, property);
            }
            Arrays.sort(FramePropertyConstants.GENERAL_SERVER_PROPERTIES);
            if (Arrays.binarySearch(FramePropertyConstants.GENERAL_SERVER_PROPERTIES, property) > -1) {
                return this.testGeneralServerProperty(serverConnection, property);
            }
        }
        return false;
    }

    private boolean testProjectPermissionProperty(final IFrameProjectAgent projectAgent, Object receiver, String property) {
        if (projectAgent != null && projectAgent.isOpened()) {
            boolean mayCreateStakeholders;
            if ("mayCreateSections".equals(property) || "mayCreatePlans".equals(property)) {
                IFrameSectionManager frameSectionManager = projectAgent.getFrameSectionManager();
                ISection parent = null;
                Object section = receiver;
                if (receiver instanceof IStructuredSelection && ((IStructuredSelection)receiver).size() == 1) {
                    Object o;
                    section = o = ((IStructuredSelection)receiver).getFirstElement();
                }
                if (section instanceof IFrameProjectAgent) {
                    parent = frameSectionManager.getRootSection();
                } else if (section instanceof ISection) {
                    parent = (ISection)section;
                }
                if (parent != null) {
                    IModificationProblem modProblem = null;
                    if ("mayCreateSections".equals(property)) {
                        modProblem = frameSectionManager.checkSectionAdditionPermission(parent, false);
                    } else if ("mayCreatePlans".equals(property)) {
                        modProblem = frameSectionManager.checkPlanAdditionPermission(parent, false);
                    }
                    return modProblem == null;
                }
                return false;
            }
            if ("mayManagePermissions".equals(property)) {
                boolean arePermissionsNeeded = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(projectAgent.getServerID()).arePermissionsNeeded();
                boolean hasPermission = projectAgent.getFramePermissionChecker().hasPermission(FramePermissionDefinitions.ADMIN_PERMISSIONS_TEMPLATE, projectAgent);
                return arePermissionsNeeded && hasPermission;
            }
            if ("mayCreateStakeholders".equals(property)) {
                return projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, projectAgent);
            }
            if ("mayCreateStakeholdersFromServer".equals(property) && (mayCreateStakeholders = this.testProjectPermissionProperty(projectAgent, receiver, "mayCreateStakeholders"))) {
                IAttributeTypesProvider attributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholder");
                IAttributeType userType = attributeTypesProvider.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_USERNAME);
                IParentOperandTree operandTree = new IParentOperandTree(){

                    @Override
                    public IPermissionOperand getBaseOperand() {
                        return projectAgent;
                    }

                    @Override
                    public IPermissionOperand getParent(IPermissionOperand childOperand) {
                        return null;
                    }
                };
                return projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(userType, operandTree, true);
            }
        }
        return false;
    }

    private boolean testServerPermissionProperty(ServerConnection serverConnection, String property) {
        if (serverConnection != null && serverConnection.isConnected() && "mayCreateProjects".equals(property)) {
            return ServerPermissionChecker.mayCreateProjects(serverConnection.getServerID(), false);
        }
        return false;
    }

    private boolean testProjectLicenseProperty(IFrameProjectAgent projectAgent, Object receiver, String property) {
        if (projectAgent != null && projectAgent.isOpened()) {
            if ("hasLicenseForCreatingSections".equals(property) || "hasLicenseForCreatingPlans".equals(property) || "hasLicenseToEditPlan".equals(property)) {
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
                return !ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance().isDenial(license);
            }
            if ("hasLicenseToDeleteData".equals(property)) {
                StructuredSelection selection = null;
                if (receiver instanceof ICockpitProjectData) {
                    selection = new StructuredSelection(receiver);
                } else if (receiver instanceof IStructuredSelection) {
                    selection = new StructuredSelection(((IStructuredSelection)receiver).toArray());
                }
                return this.hasLicenseToDelete(projectAgent, (IStructuredSelection)selection);
            }
            if ("hasLicenseToEditData".equals(property)) {
                StructuredSelection selection = null;
                if (receiver instanceof ICockpitProjectData) {
                    selection = new StructuredSelection(receiver);
                } else if (receiver instanceof IStructuredSelection) {
                    selection = new StructuredSelection(((IStructuredSelection)receiver).toArray());
                }
                return this.hasLicenseToEdit(projectAgent, (IStructuredSelection)selection);
            }
            if ("hasOfflineModeLicense".equals(property)) {
                return projectAgent.getServerLicenseManager().isLicenseOperationAllowed(ClientFunctionLicenseTypeOfflineMode.getInstance());
            }
            if ("hasLicenseToEditReportTemplates".equals(property)) {
                return projectAgent.getServerLicenseManager().isLicenseOperationAllowed(ClientFunctionLicenseTypeModifyReportTemplates.getInstance());
            }
        }
        return false;
    }

    private boolean testServerLicenseProperty(ServerConnection serverConnection, String property) {
        if (serverConnection != null && serverConnection.isConnected()) {
            boolean hasLicense = true;
            IClientFunctionLicense createLicense = null;
            int nrOfLocalProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
            IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID());
            IClientFunctionLicenseManager serverLicensemanager = null;
            if (sp != null) {
                serverLicensemanager = sp.getFunctionLicenseManager();
                if (serverLicensemanager != null) {
                    if ("hasLicenseForCreatingProjects".equals(property) || "hasLicenseForLoadingProjects".equals(property)) {
                        Object licenseValue;
                        if (property.equals("hasLicenseForCreatingProjects")) {
                            createLicense = serverLicensemanager.findClientFunctionLicense(ClientFunctionLicenseTypeProjectsCreate.getInstance());
                        } else if (property.equals("hasLicenseForLoadingProjects")) {
                            createLicense = serverLicensemanager.findClientFunctionLicense(ClientFunctionLicenseTypeProjectsLoad.getInstance());
                        }
                        int maxNr = 0;
                        if (createLicense != null && (licenseValue = createLicense.getValue()) != null && ((Boolean)licenseValue).booleanValue()) {
                            maxNr = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects(serverLicensemanager);
                        }
                        if (maxNr >= 0 && maxNr <= nrOfLocalProjects) {
                            hasLicense = false;
                        }
                    } else {
                        hasLicense = property.equals("hasLicenseToEditStakeholders") ? serverLicensemanager.isLicenseOperationAllowed(ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance()) : false;
                    }
                } else {
                    hasLicense = false;
                }
                return hasLicense;
            }
        }
        return false;
    }

    private boolean testGeneralProjectProperty(IFrameProjectAgent projectAgent, String property) {
        if (projectAgent != null) {
            if ("isOpen".equals(property)) {
                return projectAgent.isOpened();
            }
            if ("isOnline".equals(property)) {
                return !projectAgent.getOfflineModeManager().isInOfflineMode();
            }
            if ("isProfessional".equals(property)) {
                String serverID = projectAgent.getServerID();
                IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
                return projectMgrServerProxy.mayCommitDiscardWithoutLocalChanges();
            }
            if ("hasModifications".equals(property)) {
                return projectAgent.getCommitMgr().areModificationsPresent();
            }
        }
        return false;
    }

    private boolean testGeneralServerProperty(ServerConnection serverConnection, String property) {
        if (serverConnection != null && serverConnection.isConnected() && "isProfessional".equals(property)) {
            String serverID = serverConnection.getServerID();
            IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            return projectMgrServerProxy.mayCommitDiscardWithoutLocalChanges();
        }
        return false;
    }

    private boolean hasLicenseToEdit(IFrameProjectAgent projectAgent, IStructuredSelection selection) {
        boolean hasLicense = true;
        int matchingProviders = 0;
        int matchingProvidersWithoutLicense = 0;
        List<IPropertiesListEntry> providers = ExtensionMgr.getDefault().getAllPropertiesProvider();
        for (IPropertiesListEntry entry : providers) {
            for (Object o : selection.toList()) {
                ICockpitProjectData[] se = new ICockpitProjectData[]{(ICockpitProjectData)o};
                if (!entry.providesPropertiesFor(se)) continue;
                ++matchingProviders;
                if (this.checkLicense(entry, se, projectAgent)) continue;
                ++matchingProvidersWithoutLicense;
            }
        }
        if (matchingProviders > matchingProvidersWithoutLicense) {
            hasLicense = true;
        } else if (matchingProvidersWithoutLicense > 0) {
            hasLicense = false;
        }
        return hasLicense;
    }

    private boolean checkLicense(IPropertiesListEntry entry, ICockpitProjectData[] p_selectedElements, IFrameProjectAgent projectAgent) {
        boolean hasLicense = true;
        ICockpitProjectData[] iCockpitProjectDataArray = p_selectedElements;
        int n = p_selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            ICockpitProjectData element = iCockpitProjectDataArray[n2];
            IClientFunctionLicenseType2 requiredLicenseType = entry.getRequiredLicenseTypeForModifying(element);
            if (requiredLicenseType != null) {
                hasLicense = hasLicense && projectAgent.getServerLicenseManager().isLicenseOperationAllowed(requiredLicenseType);
            }
            ++n2;
        }
        return hasLicense;
    }

    private boolean hasLicenseToDelete(IFrameProjectAgent projectAgent, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            for (Object o : selection.toList()) {
                HierarchicalClientFunctionLicenseType licenseType = null;
                if (o instanceof ISection || o instanceof IPlan) {
                    licenseType = ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance();
                } else if (o instanceof IUniqueElement) {
                    licenseType = ClientFunctionLicenseTypeModifyUniqueElements.getInstance();
                } else if (o instanceof IStakeholder || o instanceof IStakeholderRole) {
                    licenseType = ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
                }
                if (licenseType == null || projectAgent.getServerLicenseManager().isLicenseOperationAllowed(licenseType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private IFrameProjectAgent getProjectAgentForSelection(ISelection selection) {
        String projectUID = ProjectSelectionAnalyser.extractProjectUID(selection);
        ProjectAgent projectAgent = null;
        if (projectUID != null) {
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        }
        return projectAgent;
    }

    private ServerConnection getServerConnectionForSelection(ISelection selection) {
        String serverID = ProjectSelectionAnalyser.extractServerID(selection);
        ServerConnection serverConnection = null;
        if (serverID != null) {
            serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID);
        }
        return serverConnection;
    }
}

