/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ServerConnectionFailureUI;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHProjectOpen
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHProjectOpen.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        IStructuredSelection sel;
        IWorkbenchPart activePart;
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWorkbenchWindow != null && (activePart = HandlerUtil.getActivePart((ExecutionEvent)event)) != null && (sel = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)) != null && !sel.isEmpty() && (obj = sel.getFirstElement()) instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent = (IFrameProjectAgent)obj;
            Throwable exToLogAndShowInDialog = null;
            try {
                boolean triggerUserOnOpenActions = true;
                projectAgent.openWithProgressbar(false, triggerUserOnOpenActions, activePart.getSite().getPage());
                CockpitSelectionService ss = CockpitSelectionManager.getSelectionService(activeWorkbenchWindow.getSelectionService());
                ss.fireSelection((ICockpitProjectData)projectAgent, activePart);
            }
            catch (LoginCanceledException e) {
                logger.info("Project open aborted by user (cancelled login).");
            }
            catch (ServerNotAvailableException e) {
                exToLogAndShowInDialog = e;
            }
            catch (UnknownServerException e) {
                exToLogAndShowInDialog = e;
            }
            catch (EXServerException e) {
                exToLogAndShowInDialog = e;
            }
            catch (InterruptedException e) {
                exToLogAndShowInDialog = e;
            }
            catch (ExProjectOpenAbortWithMessage e) {
                exToLogAndShowInDialog = e;
            }
            if (exToLogAndShowInDialog != null) {
                logger.error("could not open project", exToLogAndShowInDialog);
                if (exToLogAndShowInDialog instanceof ExProjectOpenAbortWithMessage) {
                    projectAgent.showProjectOpenAbortWithMessageDialog(activeWorkbenchWindow.getShell(), (ExProjectOpenAbortWithMessage)exToLogAndShowInDialog);
                } else {
                    ServerConnectionFailureUI.troubleshootServerConnectionFailure((Shell)activeWorkbenchWindow.getShell(), (String)Messages.getString("CHProjectOpen.CannotOpenProject"), (Throwable)exToLogAndShowInDialog);
                }
            }
        }
        return null;
    }
}

