/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ChoosePermissionOwnerDialog;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.shared.message.EOUser;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileNewStakeholdersFromUsers
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHFileNewStakeholdersFromUsers.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProjectAgent projectAgent;
        String projectUID;
        IStructuredSelection selection;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null && (selection = CommandHandlerHelper.getRelevantSelection(event)) != null && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection)) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null && projectAgent.isOpened()) {
            IParentOperandTree operandTree = new IParentOperandTree(){

                @Override
                public IPermissionOperand getBaseOperand() {
                    return projectAgent;
                }

                @Override
                public IPermissionOperand getParent(IPermissionOperand childOperand) {
                    return null;
                }
            };
            ChoosePermissionOwnerDialog dialog = new ChoosePermissionOwnerDialog(shell, projectAgent, Messages.getString("StakeholdersAdminDialog.select_user"), Messages.getString("StakeholdersAdminDialog.select_user_for_stakeholder"), 0, true);
            int answer = dialog.open();
            if (answer == 0) {
                ArrayList<IStakeholderAddID> addIDs = new ArrayList<IStakeholderAddID>();
                Object[] selectedUsers = dialog.getResult();
                ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
                Object[] objectArray = selectedUsers;
                int n = selectedUsers.length;
                int n2 = 0;
                while (n2 < n) {
                    IStakeholderAddID addID;
                    Object element = objectArray[n2];
                    EOUser user = (EOUser)element;
                    String newName = user.getDisplayName();
                    Attribute description = new Attribute(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(user.getDescription(), null, null));
                    Attribute email = new Attribute(StakeholderAttributeTypesProvider.ATTRID_EMAIL, DataTypeString.getInstanceString().getAttributeValueFromString(user.getEmail(), null, null));
                    Attribute username = new Attribute(StakeholderAttributeTypesProvider.ATTRID_USERNAME, DataTypeString.getInstanceString().getAttributeValueFromString(user.getUserName(), null, null));
                    ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
                    IModificationProblem mp = this.addAttribute(projectAgent, description, attributes, operandTree);
                    if (mp != null) {
                        modificationProblems.add(mp);
                    }
                    if ((mp = this.addAttribute(projectAgent, email, attributes, operandTree)) != null) {
                        modificationProblems.add(mp);
                    }
                    if ((mp = this.addAttribute(projectAgent, username, attributes, operandTree)) != null) {
                        modificationProblems.add(mp);
                    }
                    if ((addID = projectAgent.getFrameStakeholderManager().requestStakeholderAddPermission(newName, null, attributes)).permissionGranted()) {
                        addIDs.add(addID);
                    } else {
                        modificationProblems.add(addID.getModificationProblem());
                    }
                    ++n2;
                }
                try {
                    projectAgent.getFrameStakeholderManager().addStakeholders(addIDs);
                }
                catch (EXNoPermission e) {
                    logger.error("could not add stakeholder", (Throwable)e);
                }
                if (!modificationProblems.isEmpty()) {
                    ModificationProblemsDialog probDialog = new ModificationProblemsDialog(modificationProblems, Messages.getString("StakeholdersAdminDialog.could_not_create_all_stakeholders"), dialog.getShell());
                    probDialog.open();
                }
            }
        }
        return null;
    }

    private IModificationProblem addAttribute(ProjectAgent projectAgent, IAttribute attribute, Collection<IAttribute> attributes, IParentOperandTree operandTree) {
        IAttributeTypesProvider attributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholder");
        IAttributeType attributeType = attributeTypesProvider.getAttributeType(attribute.getAttributeTypeID());
        if (projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, operandTree, true)) {
            attributes.add(attribute);
            return null;
        }
        return new ModificationProblem(attributeType, operandTree, (IFrameProjectAgent)projectAgent);
    }
}

