/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreatePlanWizard;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanAddID;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planfilefactory.IPlanFileFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileNewPlan
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHFileNewPlan.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection;
        Object o;
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        final IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection != null && currentSelection instanceof IStructuredSelection && (o = (selection = (IStructuredSelection)currentSelection).getFirstElement()) != null) {
            ProjectAgent projectAgent = null;
            ISection section = null;
            if (o instanceof ProjectAgent) {
                projectAgent = (ProjectAgent)o;
                section = projectAgent.getSectionManager().getRootSection();
            } else if (o instanceof ISection) {
                section = (ISection)o;
                projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            }
            if (projectAgent != null && section != null) {
                final ProjectAgent projectAgent_final = projectAgent;
                final ObjectWrapper modProblem = new ObjectWrapper((Object)projectAgent.getFrameSectionManager().checkPlanAdditionPermission(section, true));
                if (modProblem.getWrappedObject() == null) {
                    CreatePlanWizard createPlanWizard = new CreatePlanWizard(projectAgent, section);
                    ArcwayWizardDialog dialog = new ArcwayWizardDialog(shell, (IWizard)createPlanWizard);
                    int answer = dialog.open();
                    if (answer == 0) {
                        final IPlanFileFactory planFileFactory = createPlanWizard.getFactory();
                        final IPlanAddID addID = projectAgent.getFrameSectionManager().requestPlanAdditionPermission(createPlanWizard.getPlanName(), createPlanWizard.getPlanType(), section, createPlanWizard.getCategoryID(), createPlanWizard.getAttributes());
                        if (addID.permissionGranted()) {
                            projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        IPlan newPlan = projectAgent_final.getFrameSectionManager().addPlan(addID);
                                        try {
                                            projectAgent_final.getPlanAgentManager().createNewPlanFile(newPlan, planFileFactory);
                                        }
                                        catch (EXModificationProblem e) {
                                            modProblem.setWrappedObject((Object)e.getModificationProblems().iterator().next());
                                            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(projectAgent_final);
                                            projectAgent_final.getFrameSectionManager().requestDataDeletePermission((IAttributeOwner)newPlan, transactionController);
                                            Collection<IModificationProblem> problems = transactionController.execute();
                                            if (problems.isEmpty()) {
                                                projectAgent_final.getFrameSectionManager().deletePlan(transactionController);
                                            }
                                            logger.error("problems during roll back: " + problems, (Throwable)e);
                                        }
                                        projectAgent_final.getPlanEditorManager().openSinglePlanEditorInEditmode(activePage, newPlan, true);
                                    }
                                    catch (EXNoPermission e) {
                                        logger.error("could not execute", (Throwable)e);
                                    }
                                    catch (IPlanFileFactory.EXCreatePlanException e) {
                                        logger.error("could not execute", (Throwable)e);
                                    }
                                }
                            });
                        } else {
                            modProblem.setWrappedObject((Object)addID.getModificationProblem());
                        }
                    }
                    createPlanWizard.disposeResources();
                }
                if (modProblem.getWrappedObject() != null) {
                    ArrayList<IModificationProblem> mpProblems = new ArrayList<IModificationProblem>();
                    mpProblems.add((IModificationProblem)modProblem.getWrappedObject());
                    String title = Messages.getString("ProjectView.CannotCreatePlan.Title");
                    String message = NLS.bind((String)Messages.getString("ProjectView.CannotCreatePlan.Message"), (Object)section.getSectionName());
                    ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mpProblems, title, message, shell);
                    mpDialog.open();
                }
            }
        }
        return null;
    }
}

