/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHEditDeleteFrameData
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHEditDeleteFrameData.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProjectAgent projectAgent;
        String projectUID;
        IStructuredSelection selection;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null && (selection = CommandHandlerHelper.getRelevantSelection(event)) != null && !selection.isEmpty() && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection)) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null) {
            String message;
            String title;
            boolean execute;
            boolean containsAtLeastOneValidItem = false;
            boolean containsValidItemsOnly = true;
            for (Object o : selection.toList()) {
                IFrameDataManager dataManager;
                IFrameDataRW data;
                boolean itemIsValid = false;
                if (o instanceof IFrameDataRW && projectUID.equals((data = (IFrameDataRW)o).getProjectUID()) && (dataManager = projectAgent.getDataManager(data.getTypeID())) != null) {
                    itemIsValid = true;
                    containsAtLeastOneValidItem = true;
                }
                if (itemIsValid) continue;
                containsValidItemsOnly = false;
            }
            if (containsAtLeastOneValidItem && containsValidItemsOnly && (execute = MessageDialog.openQuestion((Shell)shell, (String)(title = Messages.getString("DeleteDataActionDelegate.delete")), (String)(message = Messages.getString("DeleteDataActionDelegate.do_you_want_to_delete"))))) {
                LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(projectAgent);
                for (Object o : selection.toList()) {
                    IFrameDataRW data = (IFrameDataRW)o;
                    IFrameDataManager dataManager = projectAgent.getDataManager(data.getTypeID());
                    dataManager.requestDataDeletePermission(data, transactionController);
                }
                Collection<IModificationProblem> modProblems = transactionController.execute();
                if (modProblems.isEmpty()) {
                    for (Object o : selection.toList()) {
                        IFrameDataRW data = (IFrameDataRW)o;
                        IFrameDataManager dataManager = projectAgent.getDataManager(data.getTypeID());
                        ICockpitProjectData itemFromClientCache = dataManager.getCockpitProjectData(data.getUID());
                        if (itemFromClientCache == null) continue;
                        try {
                            LocksAndPermissionsTransactionController transactionController2 = new LocksAndPermissionsTransactionController(projectAgent);
                            dataManager.requestDataDeletePermission(data, transactionController2);
                            Collection<IModificationProblem> modProblems2 = transactionController2.execute();
                            if (modProblems2.isEmpty()) {
                                dataManager.deleteData(transactionController2);
                                continue;
                            }
                            assert (false);
                            String errorText = "Could not delete frame data item - mod problems though permissions and locks have been checked before:";
                            for (IModificationProblem problem : modProblems2) {
                                errorText = String.valueOf(errorText) + "\nCause: " + problem.getHumanReadableDescriptionOfCause() + " / Consequence: " + problem.getHumanReadableDescriptionOfConsequence();
                            }
                            logger.warn(errorText);
                        }
                        catch (EXNoPermission e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                    }
                    transactionController.rollback();
                } else {
                    String errorMessage = Messages.getString("DeleteDataActionDelegate.problems_while_deleting");
                    ModificationProblemsDialog probDialog = new ModificationProblemsDialog(modProblems, Messages.getString("DeleteDataActionDelegate.could_not_delete"), errorMessage, shell);
                    probDialog.open();
                }
            }
        }
        return null;
    }
}

