/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.CreateNewProjectWizard;
import com.arcway.cockpit.frame.client.global.license.HierarchicalClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsNumber;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import de.plans.psc.client.communication.ServerConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewProjectFromWelcomePageAction
extends Action {
    private final Shell activeShell;
    private final IWorkbenchPage workbenchPage;
    private final ServerConnection serverConnection;

    public NewProjectFromWelcomePageAction() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.workbenchPage = window.getActivePage();
        this.activeShell = window.getShell();
        Collection<ServerConnection> serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
        this.serverConnection = serverConnections.size() == 1 ? serverConnections.iterator().next() : null;
    }

    public void run() {
        assert (this.serverConnection != null);
        boolean serverIsAvailable = this.serverConnection.isConnected();
        if (serverIsAvailable) {
            boolean mayCreateProjects = ServerPermissionChecker.mayCreateProjects(this.serverConnection.getServerID(), false);
            ModificationProblem modificationProblem = null;
            String consequence = Messages.getString("NewProjectFromWelcomePage.NoProject");
            if (mayCreateProjects) {
                Object licenseValue;
                IClientFunctionLicense createLicense = null;
                int nrOfLocalProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
                IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.serverConnection.getServerID());
                HierarchicalClientFunctionLicenseType licenseType = ClientFunctionLicenseTypeProjectsLoad.getInstance();
                createLicense = sp.getFunctionLicenseManager().findClientFunctionLicense(licenseType);
                int maxNr = 0;
                if (createLicense != null && (licenseValue = createLicense.getValue()) != null && ((Boolean)licenseValue).booleanValue()) {
                    maxNr = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects(sp.getFunctionLicenseManager());
                }
                if (maxNr >= 0 && maxNr <= nrOfLocalProjects) {
                    modificationProblem = new ModificationProblem(licenseType, consequence);
                } else {
                    IViewReference[] views;
                    IViewReference welcomePageRef = null;
                    IViewReference[] iViewReferenceArray = views = this.workbenchPage.getViewReferences();
                    int n = views.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewReference view = iViewReferenceArray[n2];
                        if ("org.eclipse.ui.internal.introview".equals(view.getId())) {
                            welcomePageRef = view;
                            break;
                        }
                        ++n2;
                    }
                    if (welcomePageRef != null) {
                        this.workbenchPage.hideView(welcomePageRef);
                    }
                    CreateNewProjectWizard newProjectWizard = new CreateNewProjectWizard(this.workbenchPage, this.serverConnection);
                    WizardDialog createNewDialog = new WizardDialog(this.activeShell, (IWizard)newProjectWizard);
                    createNewDialog.open();
                }
            } else {
                String permissionOperandType = "createProject";
                String cause = Messages.getString("NewProjectFromWelcomePage.NoPermission");
                modificationProblem = new ModificationProblem(cause, consequence);
            }
            if (modificationProblem != null) {
                ArrayList<ModificationProblem> modificationProblems = new ArrayList<ModificationProblem>();
                modificationProblems.add(modificationProblem);
                ModificationProblemsDialog dialog = new ModificationProblemsDialog(modificationProblems, modificationProblem.getHumanReadableDescriptionOfCause(), this.activeShell);
                dialog.open();
            }
        }
    }
}

