/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IFrameData;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractTreeListFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public class SectionsAndPlansTreeListFilterItem
extends AbstractTreeListFilterItem<IFrameData> {
    private static final ILogger LOGGER = Logger.getLogger(SectionsAndPlansTreeListFilterItem.class);
    private final IFrameSectionManager sectionManager;
    private AbstractTreeListFilterItem.ITreeListFilterDataProvider<IFrameData> dataProvider;

    public SectionsAndPlansTreeListFilterItem(String name, IFrameSectionManager sectionManager, AbstractTextValuesFilter filter, boolean selectAncestorsAutomatically) {
        super(name, filter, selectAncestorsAutomatically);
        this.sectionManager = sectionManager;
    }

    protected final AbstractTreeListFilterItem.ITreeListFilterDataProvider<IFrameData> getDataProvider() {
        if (this.dataProvider == null) {
            this.dataProvider = new AbstractTreeListFilterItem.ITreeListFilterDataProvider<IFrameData>(){

                public void flushCache() {
                }

                public List<IFrameData> getRootItems() {
                    ISection rootSection = SectionsAndPlansTreeListFilterItem.this.sectionManager.getRootSection();
                    return this.getChildren(rootSection);
                }

                public List<IFrameData> getChildren(IFrameData parent) {
                    if (parent instanceof ISection) {
                        return this.getChildren((ISection)parent);
                    }
                    return null;
                }

                private List<IFrameData> getChildren(ISection section) {
                    ArrayList<IFrameData> children = new ArrayList<IFrameData>();
                    children.addAll(SectionsAndPlansTreeListFilterItem.this.sectionManager.getChildSections(section));
                    children.addAll(SectionsAndPlansTreeListFilterItem.this.sectionManager.getChildPlans(section));
                    Collections.sort(children, ProjectViewSorter.getSingleton());
                    return children;
                }

                public Set<IFrameData> getAllUnselectableItems() {
                    return Collections.emptySet();
                }

                public boolean isItemSelectable(IFrameData item) {
                    return true;
                }

                public String getLabel(IFrameData item) {
                    if (item instanceof ISection) {
                        return ((ISection)item).getSectionName();
                    }
                    if (item instanceof IPlan) {
                        IPlan plan = (IPlan)item;
                        return "Plan: " + plan.getPlanName();
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return "";
                }

                public Image getImage(IFrameData item) {
                    return ProjectTreeContentProvider.getImage_static(item, null);
                }

                public String getUID(IFrameData item) {
                    return item.getUID();
                }

                public Collection<IFrameData> getItemsForUIDs(Collection<String> uids) {
                    HashSet<IFrameData> items = new HashSet<IFrameData>(uids.size());
                    for (String uid : uids) {
                        ISection section = SectionsAndPlansTreeListFilterItem.this.sectionManager.getSection(uid);
                        if (section != null) {
                            items.add(section);
                            continue;
                        }
                        IPlan plan = SectionsAndPlansTreeListFilterItem.this.sectionManager.getPlan(uid);
                        if (plan == null) continue;
                        items.add(plan);
                    }
                    return items;
                }
            };
        }
        return this.dataProvider;
    }
}

