/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dnd;

import com.arcway.cockpit.frame.client.global.gui.dnd.IDNDManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.editors.IDropListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DNDManager
implements IDNDManager {
    private final List dropListeners = new ArrayList();

    @Override
    public void addDropListener(IDropListener dropListener) {
        assert (dropListener != null);
        assert (!this.dropListeners.contains(dropListener));
        this.dropListeners.add(dropListener);
    }

    @Override
    public void removeDropListener(IDropListener dropListener) {
        assert (dropListener != null);
        assert (this.dropListeners.contains(dropListener));
        this.dropListeners.remove(dropListener);
    }

    @Override
    public int isDropOnUniqueElementAllowed(IUniqueElement uniqueElement, int modesAllowed, int modeWished, Object payLoad) {
        int dropResult = 0;
        Iterator i = this.dropListeners.iterator();
        while (dropResult == 0 && i.hasNext()) {
            IDropListener dropListener = (IDropListener)i.next();
            dropResult = dropListener.isDropOnUniqueElementAllowed(uniqueElement, modesAllowed, modeWished, payLoad);
        }
        return dropResult;
    }

    @Override
    public boolean dropOnUniqueElement(IUniqueElement uniqueElement, int modesAllowed, int mode, Object payLoad) {
        boolean select = false;
        int dropResult = 0;
        Iterator i = this.dropListeners.iterator();
        while (dropResult == 0 && i.hasNext()) {
            IDropListener dropListener = (IDropListener)i.next();
            dropResult = dropListener.isDropOnUniqueElementAllowed(uniqueElement, modesAllowed, mode, payLoad);
            if (dropResult == 0) continue;
            select = dropListener.dropOnUniqueElement(uniqueElement, modesAllowed, mode, payLoad);
        }
        return select;
    }
}

