/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups.PermissionsForAttributesModifyingLabelProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class SectionsPermissionsGroup
implements IProjectPermissionsGroup {
    private final Map categories = new HashMap();

    @Override
    public String getName() {
        return Messages.getString("SectionsPermissionsGroup.Folders_1");
    }

    @Override
    public String getDescription() {
        return Messages.getString("SectionsPermissionsGroup.Allow_operations_on_plans_in_the_selected_folder_2");
    }

    public Collection getTemplates(IFrameProjectAgent projectAgent) {
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>(FramePermissionDefinitions.getPermissionTemplates("section"));
        templates.addAll(this.getAttributeTemplatesForSections(projectAgent));
        templates.addAll(this.getAttributeTemplatesForPlans(projectAgent));
        return templates;
    }

    private Collection getAttributeTemplatesForSections(IFrameProjectAgent projectAgent) {
        ArrayList attributeTypes = new ArrayList();
        attributeTypes.addAll(FrameDataTypes.getDataType("com.arcway.cockpit.section").getAttributeTypes((IProjectAgent)projectAgent));
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>();
        for (IAttributeType attributeType : attributeTypes) {
            if (!attributeType.restrictedAccess()) continue;
            templates.add(SectionsPermissionsGroup.getAttributePermissionTemplate(projectAgent, attributeType));
        }
        return templates;
    }

    private Collection getAttributeTemplatesForPlans(IFrameProjectAgent projectAgent) {
        ArrayList attributeTypes = new ArrayList();
        attributeTypes.addAll(FrameDataTypes.getDataType("com.arcway.cockpit.plan").getAttributeTypes((IProjectAgent)projectAgent));
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>();
        for (IAttributeType attributeType : attributeTypes) {
            if (!attributeType.restrictedAccess()) continue;
            templates.add(SectionsPermissionsGroup.getAttributePermissionTemplate(projectAgent, attributeType));
        }
        return templates;
    }

    private static CockpitPermissionTemplate getAttributePermissionTemplate(IFrameProjectAgent projectAgent, IAttributeType attributeType) {
        AttributeModificationPermissionTemplate template = projectAgent.getFrameUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeType, "section");
        return template;
    }

    @Override
    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        final PermissionsForAttributesModifyingLabelProvider attrModPermissionsLabelProvider = new PermissionsForAttributesModifyingLabelProvider(projectAgent);
        return new ILabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof CockpitPermissionTemplate)) {
                    throw new AssertionError((Object)("invalid element type " + element.getClass()));
                }
                CockpitPermissionTemplate p = (CockpitPermissionTemplate)((Object)element);
                String name = p.getPermissionName();
                if (name == null) {
                    name = attrModPermissionsLabelProvider.getText((Object)p);
                }
                return name;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }
        };
    }

    @Override
    public Object getTreeViewerInput(IModuleProjectAgent projectAgent) {
        return projectAgent.getModuleSectionManager();
    }

    @Override
    public IPermissionOperandTreeContentProvider getTreeContentProvider(IModuleProjectAgent projectAgent) {
        return new SectionsContentProvider(projectAgent);
    }

    @Override
    public ILabelProvider getTreeLabelProvider(IModuleProjectAgent projectAgent) {
        return new SectionsContentProvider(projectAgent);
    }

    @Override
    public ViewerSorter getTreeSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ISection && e2 instanceof ISection) {
                    ISection s1 = (ISection)e1;
                    ISection s2 = (ISection)e2;
                    return s1.getSectionName().compareToIgnoreCase(s2.getSectionName());
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }

    @Override
    public int getPositionInDialog() {
        return 1;
    }

    @Override
    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        String operandForModAttributes = "";
        if (template instanceof AllAttributeModificationPermissionTemplate) {
            AllAttributeModificationPermissionTemplate attrModPermTemp = (AllAttributeModificationPermissionTemplate)template;
            operandForModAttributes = attrModPermTemp.getCockpitDataTypeID();
        } else if (template instanceof AttributeModificationPermissionTemplate) {
            AttributeModificationPermissionTemplate attrModPermTemp = (AttributeModificationPermissionTemplate)template;
            operandForModAttributes = attrModPermTemp.getCockpitDataTypeID();
        }
        if (template.getOperation().equals("editPlan") || template.getOperation().equals("deletePlan") || operandForModAttributes.equals("com.arcway.cockpit.plan")) {
            return this.getCategory("sections.plans", Messages.getString("SectionsPermissionsGroup.plans"));
        }
        return this.getCategory("sections.sections", Messages.getString("SectionsPermissionsGroup.folder"));
    }

    private IPermissionTemplateCategory getCategory(final String id, final String displayName) {
        IPermissionTemplateCategory category = (IPermissionTemplateCategory)this.categories.get(id);
        if (category == null) {
            category = new IPermissionTemplateCategory(){

                @Override
                public String getID() {
                    return id;
                }

                @Override
                public String getDisplayName() {
                    return displayName;
                }
            };
            this.categories.put(id, category);
        }
        return category;
    }

    @Override
    public boolean definesAttributePermissionsFor(ICockpitDataType dataType) {
        return dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.plan")) || dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.section"));
    }

    private static class SectionsContentProvider
    implements IPermissionOperandTreeContentProvider,
    ILabelProvider {
        private final IModuleProjectAgent project;
        private Image folderImage = null;

        public SectionsContentProvider(IModuleProjectAgent p_project) {
            this.project = p_project;
        }

        @Override
        public IPermissionOperand[] getElements(Object inputElement) {
            IPermissionOperand[] r = new IPermissionOperand[]{this.project.getModuleSectionManager().getRootSection()};
            return r;
        }

        @Override
        public boolean hasChildren(IPermissionOperand element) {
            ISection section = (ISection)element;
            return !this.project.getModuleSectionManager().getChildSections(section).isEmpty();
        }

        @Override
        public IPermissionOperand[] getChildren(IPermissionOperand parentElement) {
            ISection parentSection = (ISection)parentElement;
            Collection children = this.project.getModuleSectionManager().getChildSections(parentSection);
            IPermissionOperand[] childrenArray = new IPermissionOperand[children.size()];
            children.toArray(childrenArray);
            return childrenArray;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand element) {
            ISection childSection = (ISection)element;
            return this.project.getModuleSectionManager().getParentSection(childSection);
        }

        @Override
        public IPermissionOperand getTreeRootNode() {
            return null;
        }

        public Image getImage(Object element) {
            if (this.folderImage == null) {
                this.folderImage = FramePlugin.getImageDescriptor("Section.gif").createImage();
            }
            return this.folderImage;
        }

        public String getText(Object element) {
            ISection section = (ISection)element;
            if (section.isRootSection()) {
                return Messages.getString("SectionsPermissionsGroup.Root_section_1");
            }
            return section.getSectionName();
        }

        public void dispose() {
            if (this.folderImage != null) {
                this.folderImage.dispose();
                this.folderImage = null;
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

