/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups.AbstractPermissionsGroup;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups.PermissionsForAttributesModifyingLabelProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class ReportTemplatesPermissionGroup
extends AbstractPermissionsGroup {
    @Override
    public String getName() {
        return Messages.getString("ReportTemplatesPermissionGroup.report_templates");
    }

    @Override
    public String getDescription() {
        return Messages.getString("ReportTemplatesPermissionGroup.provides_for_repot_templates");
    }

    @Override
    public IPermissionOperandTreeContentProvider getTreeContentProvider(IModuleProjectAgent projectAgent) {
        return new ContentProvider(projectAgent);
    }

    @Override
    public ILabelProvider getTreeLabelProvider(IModuleProjectAgent projectAgent) {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER).getIcon();
            }

            public String getText(Object element) {
                if (element instanceof ICockpitProject) {
                    return Messages.getString("ReportTemplatesPermissionGroup.all_folders");
                }
                IReportTemplateFolderRW templateFolder = (IReportTemplateFolderRW)element;
                return templateFolder.getName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    @Override
    public ViewerSorter getTreeSorter() {
        return ProjectViewSorter.getSingleton();
    }

    @Override
    public boolean definesAttributePermissionsFor(ICockpitDataType dataType) {
        return dataType.equals(FrameDataTypes.getDataType("frame.project")) || dataType.equals(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER));
    }

    @Override
    public int getPositionInDialog() {
        return 2;
    }

    public Collection getTemplates(IFrameProjectAgent projectAgent) {
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>();
        List<CockpitPermissionTemplate> allTemplates = FramePermissionDefinitions.getPermissionTemplates();
        for (CockpitPermissionTemplate template : allTemplates) {
            if (!template.getOperation().equals("addChild") && !template.getOperation().equals("deleteChild") || !template.getOperation2().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER) && !template.getOperation2().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE) && !template.getOperation2().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE)) continue;
            templates.add(template);
        }
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER), "project"));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE), "project"));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE), "project"));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER));
        return templates;
    }

    @Override
    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        return new TemplatesLabelProvider(projectAgent);
    }

    @Override
    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        IPermissionTemplateCategory category = null;
        if (template instanceof AttributeModificationPermissionTemplate) {
            AttributeModificationPermissionTemplate attrPermissionTemplates = (AttributeModificationPermissionTemplate)template;
            ICockpitDataType dataType = FrameDataTypes.getDataType(attrPermissionTemplates.getCockpitDataTypeID());
            category = this.getCategory(dataType.getCockpitDataTypeID(), dataType.getDisplayName());
        } else if (template instanceof AllAttributeModificationPermissionTemplate) {
            AllAttributeModificationPermissionTemplate allTemplate = (AllAttributeModificationPermissionTemplate)template;
            ICockpitDataType dataType = FrameDataTypes.getDataType(allTemplate.getCockpitDataTypeID());
            category = this.getCategory(dataType.getCockpitDataTypeID(), dataType.getDisplayName());
        } else {
            ICockpitDataType dataType = FrameDataTypes.getDataType(template.getOperation2());
            if (dataType != null) {
                category = this.getCategory(dataType.getCockpitDataTypeID(), dataType.getDisplayName());
            }
        }
        return category;
    }

    private static class ContentProvider
    implements IPermissionOperandTreeContentProvider {
        private final IFrameProjectAgent projectAgent;

        public ContentProvider(IModuleProjectAgent moduleProjectAgent) {
            this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(moduleProjectAgent.getProjectUID());
        }

        @Override
        public IPermissionOperand[] getChildren(IPermissionOperand parentElement) {
            if (parentElement instanceof IFrameProjectAgent) {
                return new IPermissionOperand[]{this.projectAgent.getProjectMetaDataManager().getProject()};
            }
            IAttributeOwner attributeOwner = (IAttributeOwner)parentElement;
            IFrameDataManager dataManager = this.projectAgent.getDataManager(attributeOwner.getTypeID());
            ArrayList<? extends IAttributeOwner> children = new ArrayList<IAttributeOwner>(dataManager.getChildren(attributeOwner));
            Iterator i = children.iterator();
            while (i.hasNext()) {
                IAttributeOwner child = (IAttributeOwner)i.next();
                if (child.getTypeID().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER)) continue;
                i.remove();
            }
            IPermissionOperand[] childrenArray = new IPermissionOperand[children.size()];
            children.toArray(childrenArray);
            return childrenArray;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand element) {
            if (element instanceof IAttributeOwner) {
                IAttributeOwner attributeOwner = (IAttributeOwner)element;
                IFrameDataManager dataManager = this.projectAgent.getDataManager(attributeOwner.getTypeID());
                return (IPermissionOperand)dataManager.getParent(attributeOwner);
            }
            return null;
        }

        @Override
        public boolean hasChildren(IPermissionOperand element) {
            return this.getChildren(element).length > 0;
        }

        @Override
        public IPermissionOperand[] getElements(Object inputElement) {
            return this.getChildren((IPermissionOperand)inputElement);
        }

        @Override
        public IPermissionOperand getTreeRootNode() {
            return null;
        }
    }

    private static class TemplatesLabelProvider
    implements ILabelProvider {
        private final PermissionsForAttributesModifyingLabelProvider attrModLabelProvider;

        public TemplatesLabelProvider(IFrameProjectAgent projectAgent) {
            this.attrModLabelProvider = new PermissionsForAttributesModifyingLabelProvider(projectAgent);
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            CockpitPermissionTemplate p = (CockpitPermissionTemplate)((Object)element);
            String name = p.getPermissionName();
            if (name == null) {
                name = this.attrModLabelProvider.getText((Object)p);
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

