/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.groups.PermissionsForAttributesModifyingLabelProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class ProjectAdministrationPermissionsGroup
implements IProjectPermissionsGroup {
    private final Map categories = new HashMap();

    @Override
    public String getName() {
        return Messages.getString("ProjectAdministrationPermissionsGroup.Project_2");
    }

    @Override
    public String getDescription() {
        return Messages.getString("ProjectAdministrationPermissionsGroup.Allow_operations_for_users_or_user_groups_3");
    }

    public Collection getTemplates(IFrameProjectAgent projectAgent) {
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>(FramePermissionDefinitions.getPermissionTemplates("project"));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType("frame.project")));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder")));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType("com.arcway.cockpit.stakeholderrole")));
        templates.addAll(this.getAttributeTemplates(projectAgent, FrameDataTypes.getDataType("com.arcway.cockpit.uniqueelement")));
        return templates;
    }

    private Collection getAttributeTemplates(IFrameProjectAgent projectAgent, ICockpitDataType dataType) {
        ArrayList<AttributeModificationPermissionTemplate> templates = new ArrayList<AttributeModificationPermissionTemplate>();
        ArrayList attributeTypes = new ArrayList(dataType.getAttributeTypes((IProjectAgent)projectAgent));
        for (IAttributeType attributeType : attributeTypes) {
            if (!attributeType.restrictedAccess()) continue;
            templates.add(ProjectAdministrationPermissionsGroup.getAttributeTemplates(projectAgent, attributeType));
        }
        return templates;
    }

    private static AttributeModificationPermissionTemplate getAttributeTemplates(IFrameProjectAgent projectAgent, IAttributeType attributeType) {
        AttributeModificationPermissionTemplate template = projectAgent.getFrameUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeType, "project");
        return template;
    }

    @Override
    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        return new TemplatesLabelProvider(projectAgent);
    }

    @Override
    public Object getTreeViewerInput(IModuleProjectAgent moduleProjectAgent) {
        return ProjectMgr.getProjectMgr().getProjectAgent(moduleProjectAgent.getProjectUID());
    }

    @Override
    public IPermissionOperandTreeContentProvider getTreeContentProvider(final IModuleProjectAgent projectAgent) {
        return new IPermissionOperandTreeContentProvider(){

            @Override
            public IPermissionOperand[] getChildren(IPermissionOperand parentElement) {
                return null;
            }

            @Override
            public IPermissionOperand getParent(IPermissionOperand element) {
                return null;
            }

            @Override
            public boolean hasChildren(IPermissionOperand element) {
                return false;
            }

            @Override
            public IPermissionOperand[] getElements(Object inputElement) {
                return new IPermissionOperand[]{projectAgent};
            }

            @Override
            public IPermissionOperand getTreeRootNode() {
                return null;
            }
        };
    }

    @Override
    public ILabelProvider getTreeLabelProvider(final IModuleProjectAgent projectAgent) {
        ILabelProvider operandsLabelProvider = new ILabelProvider(){

            public Image getImage(Object element) {
                return FrameDataTypes.getDataType("frame.project").getIcon();
            }

            public String getText(Object element) {
                return projectAgent.getProjectName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        return operandsLabelProvider;
    }

    @Override
    public ViewerSorter getTreeSorter() {
        return new ViewerSorter(){};
    }

    @Override
    public int getPositionInDialog() {
        return 0;
    }

    @Override
    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        String permissionDataType = "";
        if (template instanceof AllAttributeModificationPermissionTemplate) {
            AllAttributeModificationPermissionTemplate attrTemplate = (AllAttributeModificationPermissionTemplate)template;
            permissionDataType = attrTemplate.getCockpitDataTypeID();
        } else if (template instanceof AttributeModificationPermissionTemplate) {
            AttributeModificationPermissionTemplate attrTemplate = (AttributeModificationPermissionTemplate)template;
            permissionDataType = attrTemplate.getCockpitDataTypeID();
        } else if (template.getOperation().equals("modify-category")) {
            permissionDataType = template.getOperation2();
        }
        if (template.getOperation().equals("editStakeholders") || permissionDataType.equals("com.arcway.cockpit.stakeholder") || permissionDataType.equals("com.arcway.cockpit.stakeholderrole")) {
            return this.getCategory("project.stakeholders", Messages.getString("ProjectAdministrationPermissionsGroup.stakeholders_and_roles"));
        }
        if (permissionDataType.equals("frame.project")) {
            return this.getCategory("project.attributes", Messages.getString("ProjectAdministrationPermissionsGroup.properties"));
        }
        if (permissionDataType.equals("com.arcway.cockpit.uniqueelement")) {
            return this.getCategory("project.uniqueElements", Messages.getString("ProjectAdministrationPermissionsGroup.unique_elements"));
        }
        if (permissionDataType.equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER) || permissionDataType.equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE)) {
            return this.getCategory("project.reporttemplates", Messages.getString("ProjectAdministrationPermissionsGroup.report_templates"));
        }
        return this.getCategory("project.general", Messages.getString("ProjectAdministrationPermissionsGroup.general"));
    }

    private IPermissionTemplateCategory getCategory(final String id, final String displayName) {
        IPermissionTemplateCategory category = (IPermissionTemplateCategory)this.categories.get(id);
        if (category == null) {
            category = new IPermissionTemplateCategory(){

                @Override
                public String getID() {
                    return id;
                }

                @Override
                public String getDisplayName() {
                    return displayName;
                }
            };
            this.categories.put(id, category);
        }
        return category;
    }

    @Override
    public boolean definesAttributePermissionsFor(ICockpitDataType dataType) {
        return dataType.equals(FrameDataTypes.getDataType("frame.project")) || dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder")) || dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholderrole")) || dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.uniqueelement"));
    }

    private static class TemplatesLabelProvider
    implements ILabelProvider {
        private final PermissionsForAttributesModifyingLabelProvider attrModLabelProvider;

        public TemplatesLabelProvider(IFrameProjectAgent projectAgent) {
            this.attrModLabelProvider = new PermissionsForAttributesModifyingLabelProvider(projectAgent);
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            CockpitPermissionTemplate p = (CockpitPermissionTemplate)((Object)element);
            String name = p.getPermissionName();
            if (name == null) {
                name = this.attrModLabelProvider.getText((Object)p);
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

