/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.ProjectPermissionModificationModel;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.psc.shared.PSCPermissionConstants;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.IPermissionOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PermissionsTable {
    private static final String USER_COLUMN_PROPERTY = "user";
    private boolean forEditing = false;
    private final Map<IPermissionTemplateCategory, TableViewer> map_datatype_tableViewer = new HashMap<IPermissionTemplateCategory, TableViewer>();
    private final ProjectPermissionModificationModel modModel;
    private final IProjectPermissionsGroup projectPermissionsGroup;
    private final Map<OperandAndCategory, IStructuredContentProvider> contentProviders = new HashMap<OperandAndCategory, IStructuredContentProvider>();
    private Collection<? extends CockpitPermissionTemplate> templates;

    public PermissionsTable(IProjectPermissionsGroup pg, ProjectPermissionModificationModel modModel, boolean forEditing) {
        this.forEditing = forEditing;
        this.projectPermissionsGroup = pg;
        this.modModel = modModel;
    }

    public Control getTable(final IPermissionOperand permissionOperand, final IPermissionTemplateCategory category, Composite parent) {
        TableViewer tmp = this.map_datatype_tableViewer.get(category);
        if (tmp == null || tmp.getControl().isDisposed()) {
            tmp = this.createTable(category, parent);
            this.map_datatype_tableViewer.put(category, tmp);
        }
        final TableViewer tv = tmp;
        Object[] props = tv.getColumnProperties();
        int i = 1;
        while (i < props.length) {
            String prop = (String)props[i];
            CockpitPermissionTemplate template = (CockpitPermissionTemplate)((Object)tv.getTable().getData(prop));
            TableColumn column = tv.getTable().getColumn(i);
            String operandType = permissionOperand.getPermissionOperandType();
            if (template.getOperandType().equals(operandType)) {
                column.setResizable(true);
                column.pack();
            } else {
                if (i == props.length - 1) {
                    column.setWidth(1);
                } else {
                    column.setWidth(0);
                }
                column.setResizable(false);
            }
            ++i;
        }
        TableContentProvider contentProvider = new TableContentProvider(permissionOperand);
        tv.setContentProvider((IContentProvider)contentProvider);
        OperandAndCategory operandAndCategory = new OperandAndCategory(permissionOperand, category);
        this.contentProviders.put(operandAndCategory, contentProvider);
        TableLabelProvider labelProvider = new TableLabelProvider(permissionOperand, tv);
        tv.setLabelProvider((IBaseLabelProvider)labelProvider);
        TableCellModifier cellModifier = new TableCellModifier(tv, permissionOperand, category);
        tv.setCellModifier((ICellModifier)cellModifier);
        MenuManager contextMenuMgr = new MenuManager();
        Menu menu = contextMenuMgr.createContextMenu(tv.getControl());
        tv.getControl().setMenu(menu);
        contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                IStructuredSelection sel = (IStructuredSelection)tv.getSelection();
                if (sel.size() == 1) {
                    IPermissionOwner owner = (IPermissionOwner)sel.getFirstElement();
                    AddAllPermissionsAction addAction = new AddAllPermissionsAction(owner, permissionOperand, category);
                    manager.add((IAction)addAction);
                    RemoveAllPermissionsAction removeAction = new RemoveAllPermissionsAction(owner, permissionOperand, category);
                    manager.add((IAction)removeAction);
                }
            }
        });
        tv.setInput((Object)"start");
        return tv.getControl();
    }

    public void refresh() {
        for (TableViewer tv : this.map_datatype_tableViewer.values()) {
            tv.refresh();
        }
    }

    public void addPermissionOwner(IPermissionOwner owner, IPermissionOperand operand, IPermissionTemplateCategory category, boolean onlyDefault) {
        boolean isAdmin = this.modModel.isAdmin(owner);
        if (this.forEditing) {
            ArrayList<CockpitPermissionTemplate> templatesToAdd = new ArrayList<CockpitPermissionTemplate>();
            for (CockpitPermissionTemplate cockpitPermissionTemplate : this.projectPermissionsGroup.getTemplates(this.modModel.getProjectAgent())) {
                if (!cockpitPermissionTemplate.getOperandType().equals(operand.getPermissionOperandType()) || !isAdmin && onlyDefault && !cockpitPermissionTemplate.grantByDefault()) continue;
                IPermissionTemplateCategory permissionGroupCategory = this.projectPermissionsGroup.getCategory(this.modModel.getProjectAgent(), cockpitPermissionTemplate);
                if (!category.getID().equals(IPermissionTemplateCategory.CATEGORY_ALL.getID()) && (permissionGroupCategory == null || !category.getID().equals(permissionGroupCategory.getID())) || this.inheritsPermission(owner, operand, cockpitPermissionTemplate)) continue;
                templatesToAdd.add(cockpitPermissionTemplate);
            }
            this.modModel.addPermissions(owner, operand, templatesToAdd);
            this.removePermissionsCoveredBySuperordinatedPermissions(owner, operand, this.getAllApplicablePermissionTemplatesInCategoryForOperandType(operand.getPermissionOperandType(), category));
            OperandAndCategory operandAndCategory = new OperandAndCategory(operand, category);
            TableContentProvider contentProvider = (TableContentProvider)this.contentProviders.get(operandAndCategory);
            contentProvider.addAdditionalOwnerToShow(owner);
        }
    }

    private Collection<CockpitPermissionTemplate> getAllApplicablePermissionTemplatesInCategoryForOperandType(String permissionOperandType, IPermissionTemplateCategory category) {
        ArrayList<CockpitPermissionTemplate> templates = new ArrayList<CockpitPermissionTemplate>();
        for (CockpitPermissionTemplate cockpitPermissionTemplate : this.projectPermissionsGroup.getTemplates(this.modModel.getProjectAgent())) {
            if (!cockpitPermissionTemplate.getOperandType().equals(permissionOperandType)) continue;
            IPermissionTemplateCategory permissionGroupCategory = this.projectPermissionsGroup.getCategory(this.modModel.getProjectAgent(), cockpitPermissionTemplate);
            if (!category.getID().equals(IPermissionTemplateCategory.CATEGORY_ALL.getID()) && (permissionGroupCategory == null || !category.getID().equals(permissionGroupCategory.getID()))) continue;
            templates.add(cockpitPermissionTemplate);
        }
        return templates;
    }

    private void removePermissionsCoveredBySuperordinatedPermissions(IPermissionOwner owner, IPermissionOperand operand, Collection<CockpitPermissionTemplate> templatesToConsider) {
        ArrayList<CockpitPermissionTemplate> templatePermissionsDirectlyCoveredByPermissions = new ArrayList<CockpitPermissionTemplate>(templatesToConsider.size());
        for (CockpitPermissionTemplate template : templatesToConsider) {
            int ownsPermissionDirectly = this.ownsPermissionDirectly(owner, operand, template);
            if (ownsPermissionDirectly <= 0) continue;
            templatePermissionsDirectlyCoveredByPermissions.add(template);
        }
        ArrayList<CockpitPermissionTemplate> templatePermissionsCoveredByOwnedSuperordinatedPermission = new ArrayList<CockpitPermissionTemplate>(templatesToConsider.size());
        for (CockpitPermissionTemplate template : templatePermissionsDirectlyCoveredByPermissions) {
            if (template.getSuperordinatedPermissionTemplate() == null || !templatePermissionsDirectlyCoveredByPermissions.contains((Object)template.getSuperordinatedPermissionTemplate())) continue;
            templatePermissionsCoveredByOwnedSuperordinatedPermission.add(template);
        }
        for (CockpitPermissionTemplate template : templatePermissionsCoveredByOwnedSuperordinatedPermission) {
            int ownsPermissionDirectly = this.ownsPermissionDirectly(owner, operand, template);
            if (ownsPermissionDirectly != 1) continue;
            this.modModel.removePermission(owner, operand, template);
        }
    }

    private TableViewer createTable(IPermissionTemplateCategory category, Composite parent) {
        int style = 101120;
        Table table = new Table(parent, style);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        TableColumn col = new TableColumn(table, 16384);
        col.setText(Messages.getString("ProjectPermissionsEditDialog.Users_and_Groups_12"));
        col.pack();
        Collection<? extends CockpitPermissionTemplate> permissionTemplates = this.projectPermissionsGroup.getTemplates(this.modModel.getProjectAgent());
        ArrayList<String> columnProperties = new ArrayList<String>();
        columnProperties.add(USER_COLUMN_PROPERTY);
        CellEditor[] cellEditors = new CellEditor[permissionTemplates.size() + 1];
        cellEditors[0] = new CellEditor(){

            protected Control createControl(Composite parentComposite) {
                return null;
            }

            protected Object doGetValue() {
                return null;
            }

            protected void doSetFocus() {
            }

            protected void doSetValue(Object value) {
            }
        };
        int nr = 1;
        for (CockpitPermissionTemplate cockpitPermissionTemplate : permissionTemplates) {
            IPermissionTemplateCategory groupCategory = this.projectPermissionsGroup.getCategory(this.modModel.getProjectAgent(), cockpitPermissionTemplate);
            if (!category.getID().equals(IPermissionTemplateCategory.CATEGORY_ALL.getID()) && (groupCategory == null || !category.getID().equals(groupCategory.getID()))) continue;
            col = new TableColumn(table, 16384);
            String name = this.projectPermissionsGroup.getTemplatesLabelProvider(this.modModel.getProjectAgent()).getText((Object)cockpitPermissionTemplate);
            col.setText(StringUtil.appendSpace((String)name, (int)20));
            col.setImage(this.projectPermissionsGroup.getTemplatesLabelProvider(this.modModel.getProjectAgent()).getImage((Object)cockpitPermissionTemplate));
            col.setData((Object)cockpitPermissionTemplate);
            col.pack();
            cellEditors[nr] = new CheckboxCellEditor((Composite)table);
            String operation2 = cockpitPermissionTemplate.getOperation2() != null ? cockpitPermissionTemplate.getOperation2() : "";
            String columProp = String.valueOf(cockpitPermissionTemplate.getOperation()) + operation2 + cockpitPermissionTemplate.getOperandType() + cockpitPermissionTemplate.getSubSetType();
            columnProperties.add(columProp);
            table.setData(columProp, (Object)cockpitPermissionTemplate);
            ++nr;
        }
        tableViewer.setCellEditors(cellEditors);
        nr = 0;
        String[] stringArray = new String[columnProperties.size()];
        for (String prop : columnProperties) {
            stringArray[nr++] = prop;
        }
        tableViewer.setColumnProperties(stringArray);
        tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IPermissionOwner p1 = (IPermissionOwner)e1;
                IPermissionOwner p2 = (IPermissionOwner)e2;
                if (p1.getPermissionOwnerType() < p2.getPermissionOwnerType()) {
                    return -1;
                }
                if (p1.getPermissionOwnerType() > p2.getPermissionOwnerType()) {
                    return 1;
                }
                return p1.getPermissionOwnerName().compareToIgnoreCase(p2.getPermissionOwnerName());
            }
        });
        return tableViewer;
    }

    private int ownsPermissionDirectly(IPermissionOwner owner, IPermissionOperand operand, CockpitPermissionTemplate template) {
        EOPermission permission = this.modModel.getPermission(owner, operand, template);
        if (permission != null) {
            if (PSCPermissionConstants.isMandatoryPermission((EOPermission)permission)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private boolean inheritsPermission(IPermissionOwner owner, IPermissionOperand operand, CockpitPermissionTemplate template) {
        IPermissionOperand parentOperand = this.projectPermissionsGroup.getTreeContentProvider(this.modModel.getProjectAgent()).getParent(operand);
        if (parentOperand != null && (this.modModel.ownsPermission(template.getOperation(), template.getOperation2(), owner, parentOperand) || this.inheritsPermission(owner, parentOperand, template))) {
            return true;
        }
        CockpitPermissionTemplate superordinatedTemplate = template.getSuperordinatedPermissionTemplate();
        return superordinatedTemplate != null && (this.modModel.ownsPermission(superordinatedTemplate.getOperation(), superordinatedTemplate.getOperation2(), owner, operand) || this.inheritsPermission(owner, operand, superordinatedTemplate));
    }

    private Collection<? extends CockpitPermissionTemplate> getTemplates() {
        if (this.templates == null) {
            this.templates = this.projectPermissionsGroup.getTemplates(this.modModel.getProjectAgent());
        }
        return this.templates;
    }

    private class AddAllPermissionsAction
    extends Action {
        private final IPermissionOwner permissionOwner;
        private final IPermissionOperand permissionOperand;
        private final IPermissionTemplateCategory category;

        public AddAllPermissionsAction(IPermissionOwner owner, IPermissionOperand operand, IPermissionTemplateCategory category) {
            this.permissionOwner = owner;
            this.permissionOperand = operand;
            this.category = category;
            this.setText(Messages.getString("PermissionsTable.set_all_permissions"));
            this.update();
        }

        private void update() {
            if (PermissionsTable.this.forEditing) {
                for (CockpitPermissionTemplate cockpitPermissionTemplate : PermissionsTable.this.projectPermissionsGroup.getTemplates(PermissionsTable.this.modModel.getProjectAgent())) {
                    IPermissionTemplateCategory permissionGroupCategory = PermissionsTable.this.projectPermissionsGroup.getCategory(PermissionsTable.this.modModel.getProjectAgent(), cockpitPermissionTemplate);
                    if (!IPermissionTemplateCategory.CATEGORY_ALL.getID().equals(this.category.getID()) && (permissionGroupCategory == null || !this.category.getID().equals(permissionGroupCategory.getID())) || PermissionsTable.this.ownsPermissionDirectly(this.permissionOwner, this.permissionOperand, cockpitPermissionTemplate) != 0 || PermissionsTable.this.inheritsPermission(this.permissionOwner, this.permissionOperand, cockpitPermissionTemplate)) continue;
                    this.setEnabled(true);
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            PermissionsTable.this.addPermissionOwner(this.permissionOwner, this.permissionOperand, this.category, false);
            PermissionsTable.this.refresh();
        }
    }

    private static class OperandAndCategory {
        private final IPermissionOperand operand;
        private final IPermissionTemplateCategory category;

        public OperandAndCategory(IPermissionOperand operand, IPermissionTemplateCategory category) {
            this.operand = operand;
            this.category = category;
        }

        public IPermissionOperand getOperand() {
            return this.operand;
        }

        public IPermissionTemplateCategory getCategory() {
            return this.category;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj) && obj instanceof OperandAndCategory) {
                OperandAndCategory operandAndCategory = (OperandAndCategory)obj;
                return this.getCategory().equals(operandAndCategory.getCategory()) && this.getOperand().equals(operandAndCategory.getOperand());
            }
            return true;
        }

        public int hashCode() {
            return this.getOperand().hashCode() ^ this.getCategory().hashCode();
        }
    }

    private class RemoveAllPermissionsAction
    extends Action {
        private final IPermissionTemplateCategory category;
        private final IPermissionOwner permissionOwner;
        private final IPermissionOperand permissionOperand;

        public RemoveAllPermissionsAction(IPermissionOwner owner, IPermissionOperand operand, IPermissionTemplateCategory category) {
            this.permissionOwner = owner;
            this.permissionOperand = operand;
            this.category = category;
            this.setText(Messages.getString("PermissionsTable.remove_all_permissions"));
            this.update();
        }

        private void update() {
            if (PermissionsTable.this.forEditing) {
                for (CockpitPermissionTemplate cockpitPermissionTemplate : PermissionsTable.this.projectPermissionsGroup.getTemplates(PermissionsTable.this.modModel.getProjectAgent())) {
                    IPermissionTemplateCategory permissionGroupCategory = PermissionsTable.this.projectPermissionsGroup.getCategory(PermissionsTable.this.modModel.getProjectAgent(), cockpitPermissionTemplate);
                    if (!IPermissionTemplateCategory.CATEGORY_ALL.getID().equals(this.category.getID()) && (permissionGroupCategory == null || !this.category.getID().equals(permissionGroupCategory.getID())) || PermissionsTable.this.ownsPermissionDirectly(this.permissionOwner, this.permissionOperand, cockpitPermissionTemplate) != 1) continue;
                    this.setEnabled(true);
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            if (PermissionsTable.this.forEditing) {
                for (CockpitPermissionTemplate cockpitPermissionTemplate : PermissionsTable.this.projectPermissionsGroup.getTemplates(PermissionsTable.this.modModel.getProjectAgent())) {
                    IPermissionTemplateCategory permissionGroupCategory = PermissionsTable.this.projectPermissionsGroup.getCategory(PermissionsTable.this.modModel.getProjectAgent(), cockpitPermissionTemplate);
                    if (!IPermissionTemplateCategory.CATEGORY_ALL.getID().equals(this.category.getID()) && (permissionGroupCategory == null || !this.category.getID().equals(permissionGroupCategory.getID()))) continue;
                    PermissionsTable.this.modModel.removePermission(this.permissionOwner, this.permissionOperand, cockpitPermissionTemplate);
                }
                PermissionsTable.this.refresh();
            }
        }
    }

    private class TableCellModifier
    implements ICellModifier {
        private final TableViewer tableViewer;
        private final IPermissionOperand permissionOperand;
        private final IPermissionTemplateCategory category;

        public TableCellModifier(TableViewer tableViewer, IPermissionOperand permissionOperand, IPermissionTemplateCategory category) {
            this.tableViewer = tableViewer;
            this.permissionOperand = permissionOperand;
            this.category = category;
        }

        public boolean canModify(Object element, String property) {
            CockpitPermissionTemplate template;
            if (PermissionsTable.this.forEditing && (template = this.getTemplate(property)) != null) {
                IPermissionOwner owner = (IPermissionOwner)element;
                if (PermissionsTable.this.ownsPermissionDirectly(owner, this.permissionOperand, template) == 1) {
                    return true;
                }
                if (!PermissionsTable.this.inheritsPermission(owner, this.permissionOperand, template)) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            CockpitPermissionTemplate template = this.getTemplate(property);
            if (template != null) {
                IPermissionOwner owner = (IPermissionOwner)element;
                if (PermissionsTable.this.ownsPermissionDirectly(owner, this.permissionOperand, template) > 0 || PermissionsTable.this.inheritsPermission(owner, this.permissionOperand, template)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            CockpitPermissionTemplate template = this.getTemplate(property);
            if (template != null) {
                TableItem tableItem = (TableItem)element;
                IPermissionOwner owner = (IPermissionOwner)tableItem.getData();
                boolean create = (Boolean)value;
                if (create) {
                    PermissionsTable.this.modModel.addPermission(owner, this.permissionOperand, template);
                    PermissionsTable.this.removePermissionsCoveredBySuperordinatedPermissions(owner, this.permissionOperand, PermissionsTable.this.getAllApplicablePermissionTemplatesInCategoryForOperandType(this.permissionOperand.getPermissionOperandType(), this.category));
                } else {
                    PermissionsTable.this.modModel.removePermission(owner, this.permissionOperand, template);
                }
                this.tableViewer.refresh();
            }
        }

        private CockpitPermissionTemplate getTemplate(String property) {
            if (!PermissionsTable.USER_COLUMN_PROPERTY.equals(property)) {
                return (CockpitPermissionTemplate)((Object)this.tableViewer.getTable().getData(property));
            }
            return null;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private final IPermissionOperand permissionOperand;
        private final Collection<IPermissionOwner> additionalOwnersToShow = new ArrayList<IPermissionOwner>();

        public TableContentProvider(IPermissionOperand permissionOperand) {
            this.permissionOperand = permissionOperand;
        }

        public void addAdditionalOwnerToShow(IPermissionOwner owner) {
            if (!this.additionalOwnersToShow.contains(owner)) {
                this.additionalOwnersToShow.add(owner);
            }
        }

        public void removeAdditionalOwnerToShow(IPermissionOwner owner) {
            this.additionalOwnersToShow.remove(owner);
        }

        public Object[] getElements(Object inputElement) {
            HashSet<IPermissionOwner> owners = new HashSet<IPermissionOwner>();
            this.addPermissionOwners(this.permissionOperand, owners);
            owners.addAll(this.additionalOwnersToShow);
            return owners.toArray();
        }

        private void addPermissionOwners(IPermissionOperand operand, Set<IPermissionOwner> owners) {
            Collection<IPermissionOwner> newOwners = PermissionsTable.this.modModel.getAllPermissionOwners(operand, PermissionsTable.this.getTemplates());
            owners.addAll(newOwners);
            IPermissionOperand parentOperand = PermissionsTable.this.projectPermissionsGroup.getTreeContentProvider(PermissionsTable.this.modModel.getProjectAgent()).getParent(operand);
            if (parentOperand != null) {
                this.addPermissionOwners(parentOperand, owners);
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    implements ITableLabelProvider {
        private static final String MARKED = "checked.gif";
        private static final String UNMARKED = "unchecked.gif";
        private static final String FIX = "unchangeable.gif";
        private static final String USER = "user_neu.gif";
        private static final String GROUP = "group_neu.gif";
        private static final String ROLE = "stakeholder_role.gif";
        private final Map<String, Image> images = new HashMap<String, Image>();
        private final IPermissionOperand permissionOperand;
        private final TableViewer tableViewer;

        public TableLabelProvider(IPermissionOperand permissionOperand, TableViewer tableViewer) {
            this.permissionOperand = permissionOperand;
            this.tableViewer = tableViewer;
            this.images.put(MARKED, FramePlugin.getImageDescriptor(MARKED).createImage());
            this.images.put(UNMARKED, FramePlugin.getImageDescriptor(UNMARKED).createImage());
            this.images.put(FIX, FramePlugin.getImageDescriptor(FIX).createImage());
            this.images.put(USER, FramePlugin.getImageDescriptor(USER).createImage());
            this.images.put(GROUP, FramePlugin.getImageDescriptor(GROUP).createImage());
            this.images.put(ROLE, FramePlugin.getImageDescriptor(ROLE).createImage());
        }

        private Image getImage(String key) {
            return this.images.get(key);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IPermissionOwner owner = (IPermissionOwner)element;
            if (columnIndex == 0) {
                if (owner.getPermissionOwnerType() == 0) {
                    return this.getImage(USER);
                }
                if (owner.getPermissionOwnerType() == 2) {
                    return this.getImage(ROLE);
                }
                return this.getImage(GROUP);
            }
            String prop = (String)this.tableViewer.getColumnProperties()[columnIndex];
            CockpitPermissionTemplate template = (CockpitPermissionTemplate)((Object)this.tableViewer.getTable().getData(prop));
            int ownsState = PermissionsTable.this.ownsPermissionDirectly(owner, this.permissionOperand, template);
            if (ownsState == 1) {
                return this.getImage(MARKED);
            }
            if (ownsState == 2) {
                return this.getImage(FIX);
            }
            if (PermissionsTable.this.inheritsPermission(owner, this.permissionOperand, template)) {
                return this.getImage(FIX);
            }
            return this.getImage(UNMARKED);
        }

        public String getColumnText(Object element, int columnIndex) {
            IPermissionOwner owner = (IPermissionOwner)element;
            if (columnIndex == 0) {
                return owner.getPermissionOwnerName();
            }
            String prop = (String)this.tableViewer.getColumnProperties()[columnIndex];
            CockpitPermissionTemplate template = (CockpitPermissionTemplate)((Object)this.tableViewer.getTable().getData(prop));
            int ownsState = PermissionsTable.this.ownsPermissionDirectly(owner, this.permissionOperand, template);
            if (ownsState == 2) {
                return Messages.getString("ProjectPermissionTableContentProvider.mandatory_6");
            }
            if (ownsState == 0 && PermissionsTable.this.inheritsPermission(owner, this.permissionOperand, template)) {
                return Messages.getString("ProjectPermissionTableContentProvider.inherited_8");
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Iterator<Image> i = this.images.values().iterator();
            while (i.hasNext()) {
                Image image = i.next();
                image.dispose();
                i.remove();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

