/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.PermissionDialogPage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.migration.migrators.version3.UnnecessaryPermissionMigrator;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;

public class PermissionsAdminDialog
extends TitleAreaDialog {
    private static final ILogger logger = Logger.getLogger(PermissionsAdminDialog.class);
    private static final String DIALOG_TITLE = Messages.getString("ProjectPermissionsEditDialog.Manage_Permissions_1");
    private static final String DIALOG_MESSAGE = Messages.getString("ProjectPermissionsEditDialog.Manage_Permissions_of_Project__2");
    private static final String DIALOG_MESSAGE_READONLY = Messages.getString("ProjectPermissionsEditDialog.0");
    private final Collection<IProjectPermissionsGroup> templateGroups;
    private final IFrameProjectAgent projectAgent;
    private final IWorkbenchPage workbenchPage;
    private boolean mayEditPermissions;
    private ICockpitDataType dataTypeWhichsAttributePermissionsAreToShow;

    public PermissionsAdminDialog(IFrameProjectAgent projectAgent, IWorkbenchPage workbenchPage) {
        super(workbenchPage.getWorkbenchWindow().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.projectAgent = projectAgent;
        this.workbenchPage = workbenchPage;
        String userName = projectAgent.getUserData(false).getUser().getUserName();
        this.mayEditPermissions = false;
        if (userName.equals("Administrator")) {
            this.mayEditPermissions = true;
        } else if (projectAgent.getFramePermissionChecker().hasPermission("adminPermissions", (String)null, projectAgent)) {
            this.mayEditPermissions = true;
        } else {
            EOList groups = PSCServices.getServiceFacade().getUserData(projectAgent.getServerID()).getGroups();
            for (EOGroup group : groups) {
                if (!group.getGroupName().equals("Administrators")) continue;
                this.mayEditPermissions = true;
                break;
            }
        }
        this.templateGroups = projectAgent.getPermissionModificationAgent().readAllProjectPermissionsTemplateProvider();
    }

    public PermissionsAdminDialog(IFrameProjectAgent projectAgent, IWorkbenchPage workbenchPage, ICockpitDataType dataTypeWhichsAttributePermissionsAreToShow) {
        this(projectAgent, workbenchPage);
        this.dataTypeWhichsAttributePermissionsAreToShow = dataTypeWhichsAttributePermissionsAreToShow;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(DIALOG_TITLE);
        this.getShell().setText(DIALOG_TITLE);
        String message = this.mayEditPermissions ? DIALOG_MESSAGE : DIALOG_MESSAGE_READONLY;
        int messageType = this.mayEditPermissions ? 0 : 1;
        this.setMessage(String.valueOf(message) + " (" + this.projectAgent.getProjectName() + ")", messageType);
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new GridLayout(1, false));
        TabItem tabItemToTop = null;
        for (IProjectPermissionsGroup permissionGroup : this.templateGroups) {
            boolean definesAttributePermissionsToBeShown = false;
            if (this.dataTypeWhichsAttributePermissionsAreToShow != null) {
                definesAttributePermissionsToBeShown = permissionGroup.definesAttributePermissionsFor(this.dataTypeWhichsAttributePermissionsAreToShow);
            }
            TabItem tabItem = this.createTabItem(permissionGroup, tabFolder, definesAttributePermissionsToBeShown);
            if (!definesAttributePermissionsToBeShown) continue;
            tabItemToTop = tabItem;
        }
        if (tabItemToTop != null) {
            tabFolder.setSelection(new TabItem[]{tabItemToTop});
        }
        Point size = tabFolder.computeSize(-1, -1);
        GridData gridData = new GridData(1808);
        gridData.widthHint = size.x;
        tabFolder.setLayoutData((Object)gridData);
        return tabFolder;
    }

    private TabItem createTabItem(IProjectPermissionsGroup permissionGroup, TabFolder tabFolder, boolean selectRootOperand) {
        IPermissionOperand[] rootOperands;
        SashForm sashForm = new SashForm((Composite)tabFolder, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(permissionGroup.getName());
        tabItem.setControl((Control)sashForm);
        Tree tree = new Tree((Composite)sashForm, 2836);
        final TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new PermissionOperandTreeContentProviderWrapper(permissionGroup.getTreeContentProvider(this.projectAgent)));
        treeViewer.setLabelProvider((IBaseLabelProvider)permissionGroup.getTreeLabelProvider(this.projectAgent));
        treeViewer.setInput(permissionGroup.getTreeViewerInput(this.projectAgent));
        treeViewer.setSorter(permissionGroup.getTreeSorter());
        final Composite permissionTableComposite = new Composite((Composite)sashForm, 16);
        final StackLayout stackLayout = new StackLayout();
        permissionTableComposite.setLayout((Layout)stackLayout);
        final PermissionDialogPage permissionTableStack = new PermissionDialogPage(permissionTableComposite, permissionGroup, this.projectAgent, this.mayEditPermissions);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
                if (sel.size() == 1) {
                    Control control;
                    IPermissionOperand operand = (IPermissionOperand)sel.getFirstElement();
                    stackLayout.topControl = control = permissionTableStack.getPage(operand);
                    permissionTableComposite.layout();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (selectRootOperand && (rootOperands = permissionGroup.getTreeContentProvider(this.projectAgent).getElements(permissionGroup.getTreeViewerInput(this.projectAgent))).length > 0) {
            IPermissionOperand operand = rootOperands[0];
            StructuredSelection sel = new StructuredSelection((Object)operand);
            treeViewer.setSelection((ISelection)sel);
        }
        sashForm.setWeights(new int[]{20, 80});
        return tabItem;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (Display.getDefault().getDismissalAlignment() == 16384) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
        this.getButton(0).setEnabled(this.mayEditPermissions);
    }

    protected void cancelPressed() {
        this.projectAgent.getFramePermissionManager().rollback();
        super.cancelPressed();
    }

    protected void okPressed() {
        Throwable exception = null;
        try {
            this.projectAgent.getFramePermissionManager().removePermissions(UnnecessaryPermissionMigrator.findUnnecessaryAttributePermissions(this.projectAgent.getFramePermissionManager().getAllPermissions()));
            this.projectAgent.getFramePermissionManager().commit();
        }
        catch (EXServerException e) {
            exception = e;
        }
        catch (ServerNotAvailableException e) {
            exception = e;
        }
        catch (UnknownServerException e) {
            exception = e;
        }
        catch (LoginCanceledException e) {
            // empty catch block
        }
        if (exception != null) {
            logger.error("could not execute", exception);
            ExceptionDialog exceptionDialog = new ExceptionDialog(this.getShell(), exception);
            exceptionDialog.open();
        } else {
            super.okPressed();
        }
    }

    private static class PermissionOperandTreeContentProviderWrapper
    implements ITreeContentProvider {
        private final IPermissionOperandTreeContentProvider treeContentProvider;

        public PermissionOperandTreeContentProviderWrapper(IPermissionOperandTreeContentProvider treeContentProvider) {
            this.treeContentProvider = treeContentProvider;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = parentElement instanceof IPermissionOperand ? this.treeContentProvider.getChildren((IPermissionOperand)parentElement) : new Object[]{};
            return children;
        }

        public Object getParent(Object element) {
            IPermissionOperand parent = element instanceof IPermissionOperand ? this.treeContentProvider.getParent((IPermissionOperand)element) : null;
            return parent;
        }

        public boolean hasChildren(Object element) {
            boolean hasChildren = element instanceof IPermissionOperand ? this.treeContentProvider.hasChildren((IPermissionOperand)element) : false;
            return hasChildren;
        }

        public Object[] getElements(Object input) {
            return this.treeContentProvider.getElements(input);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

