/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ChoosePermissionOwnerDialog;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.PermissionsTable;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.IPermissionOwner;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PermissionDialogPage {
    private final IProjectPermissionsGroup projectPermissionsGroup;
    private final Composite parent;
    private PermissionsTable permissionsTable;
    private final IFrameProjectAgent projectAgent;
    private boolean forEdit = false;
    private IPermissionTemplateCategory currentCategory;

    public PermissionDialogPage(Composite parent, IProjectPermissionsGroup pg, IFrameProjectAgent projectAgent, boolean forEdit) {
        this.parent = parent;
        this.projectPermissionsGroup = pg;
        this.projectAgent = projectAgent;
        this.forEdit = forEdit;
    }

    public Control getPage(IPermissionOperand operand) {
        return this.createPage(operand);
    }

    private Composite createPage(final IPermissionOperand permissionOperand) {
        Control control;
        Composite base = new Composite(this.parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        final Combo categoriesCombo = new Combo(base, 2056);
        categoriesCombo.setLayoutData((Object)new GridData(768));
        for (IPermissionTemplateCategory category : this.getCategories(permissionOperand)) {
            categoriesCombo.add(category.getDisplayName());
            String strIndex = Integer.toString(categoriesCombo.getItemCount() - 1);
            categoriesCombo.setData(strIndex, (Object)category);
        }
        final Composite tableComposite = new Composite(base, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        final StackLayout stackLayout = new StackLayout();
        tableComposite.setLayout((Layout)stackLayout);
        this.permissionsTable = new PermissionsTable(this.projectPermissionsGroup, this.projectAgent.getProjectPermissionModificationModel(), true);
        categoriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = categoriesCombo.getSelectionIndex();
                if (index > -1) {
                    Control control;
                    String strIndex = Integer.toString(index);
                    PermissionDialogPage.this.currentCategory = (IPermissionTemplateCategory)categoriesCombo.getData(strIndex);
                    stackLayout.topControl = control = PermissionDialogPage.this.permissionsTable.getTable(permissionOperand, PermissionDialogPage.this.currentCategory, tableComposite);
                    tableComposite.layout();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite bar = new Composite(base, 0);
        bar.setLayoutData((Object)new GridData(768));
        bar.setLayout((Layout)new GridLayout(3, false));
        int btnWidth = 0;
        Button btnAddRole = new Button(bar, 0);
        GridData roleData = new GridData();
        btnAddRole.setLayoutData((Object)roleData);
        btnAddRole.setText(Messages.getString("ProjectPermissionsEditDialog.Add_Role_1"));
        btnAddRole.setToolTipText(Messages.getString("ProjectPermissionsEditDialog.Add_an_existing_stakeholder_role_to_the_list_of_permission_owners._2"));
        btnAddRole.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = categoriesCombo.getSelectionIndex();
                if (index > -1) {
                    String strIndex = Integer.toString(index);
                    IPermissionTemplateCategory category = (IPermissionTemplateCategory)categoriesCombo.getData(strIndex);
                    PermissionDialogPage.this.addStakeholderRoles(permissionOperand, category);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnAddRole.setEnabled(this.forEdit);
        Button btnUser = new Button(bar, 0);
        GridData userData = new GridData();
        btnUser.setLayoutData((Object)userData);
        btnUser.setText(Messages.getString("ProjectPermissionsEditDialog.Add_User_6"));
        btnUser.setToolTipText(Messages.getString("ProjectPermissionsEditDialog.adds_an_existing_user_to_the_list_of_permission_owners_7"));
        btnUser.setEnabled(this.forEdit);
        btnUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = categoriesCombo.getSelectionIndex();
                if (index > -1) {
                    String strIndex = Integer.toString(index);
                    IPermissionTemplateCategory category = (IPermissionTemplateCategory)categoriesCombo.getData(strIndex);
                    PermissionDialogPage.this.addServerUser(permissionOperand, category);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnGroup = new Button(bar, 0);
        GridData groupData = new GridData();
        btnGroup.setLayoutData((Object)groupData);
        btnGroup.setText(Messages.getString("ProjectPermissionsEditDialog.Add_Group_8"));
        btnGroup.setToolTipText(Messages.getString("ProjectPermissionsEditDialog.adds_an_existing_group_to_the_list_of_permission_owners_9"));
        btnGroup.setEnabled(this.forEdit);
        btnGroup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = categoriesCombo.getSelectionIndex();
                if (index > -1) {
                    String strIndex = Integer.toString(index);
                    IPermissionTemplateCategory category = (IPermissionTemplateCategory)categoriesCombo.getData(strIndex);
                    PermissionDialogPage.this.addServerUserGroup(permissionOperand, category);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnWidth = Math.max(btnWidth, btnAddRole.computeSize((int)-1, (int)-1).x);
        btnWidth = Math.max(btnWidth, btnUser.computeSize((int)-1, (int)-1).x);
        roleData.widthHint = btnWidth = Math.max(btnWidth, btnGroup.computeSize((int)-1, (int)-1).x);
        userData.widthHint = btnWidth;
        groupData.widthHint = btnWidth;
        if (this.currentCategory == null) {
            this.currentCategory = IPermissionTemplateCategory.CATEGORY_ALL;
        }
        int i = 0;
        while (i < categoriesCombo.getItemCount()) {
            String strIndex = Integer.toString(i);
            IPermissionTemplateCategory cat = (IPermissionTemplateCategory)categoriesCombo.getData(strIndex);
            if (cat.getID().equals(this.currentCategory.getID())) {
                categoriesCombo.select(i);
                break;
            }
            ++i;
        }
        stackLayout.topControl = control = this.permissionsTable.getTable(permissionOperand, this.currentCategory, tableComposite);
        tableComposite.layout();
        return base;
    }

    private void addStakeholderRoles(IPermissionOperand permissionOperand, IPermissionTemplateCategory category) {
        ChoosePermissionOwnerDialog chooseUserDialog = new ChoosePermissionOwnerDialog(this.parent.getShell(), this.projectAgent, Messages.getString("PermissionDialogPage.SelectStakeholderRole"), Messages.getString("PermissionDialogPage.ChooseStakeholderRole"), 2, false);
        int answer = chooseUserDialog.open();
        if (answer == 0) {
            Object[] stakeholderRoles;
            Object[] objectArray = stakeholderRoles = chooseUserDialog.getResult();
            int n = stakeholderRoles.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IStakeholderRole stakeholderRole = (IStakeholderRole)element;
                this.permissionsTable.addPermissionOwner((IPermissionOwner)stakeholderRole, permissionOperand, category, true);
                ++n2;
            }
            this.permissionsTable.refresh();
        }
    }

    private void addServerUser(IPermissionOperand permissionOperand, IPermissionTemplateCategory category) {
        ChoosePermissionOwnerDialog chooseUserDialog = new ChoosePermissionOwnerDialog(this.parent.getShell(), this.projectAgent, Messages.getString("PermissionDialogPage.select_user_account"), Messages.getString("PermissionDialogPage.choose_users"), 0, false);
        int answer = chooseUserDialog.open();
        if (answer == 0) {
            Object[] users;
            Object[] objectArray = users = chooseUserDialog.getResult();
            int n = users.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                EOUser user = (EOUser)element;
                this.permissionsTable.addPermissionOwner((IPermissionOwner)user, permissionOperand, category, true);
                ++n2;
            }
            this.permissionsTable.refresh();
        }
    }

    private void addServerUserGroup(IPermissionOperand permissionOperand, IPermissionTemplateCategory category) {
        ChoosePermissionOwnerDialog dialog = new ChoosePermissionOwnerDialog(this.parent.getShell(), this.projectAgent, Messages.getString("PermissionDialogPage.select_group_account"), Messages.getString("PermissionDialogPage.choose_groups"), 1, false);
        int answer = dialog.open();
        if (answer == 0) {
            Object[] groups;
            Object[] objectArray = groups = dialog.getResult();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                EOGroup group = (EOGroup)element;
                this.permissionsTable.addPermissionOwner((IPermissionOwner)group, permissionOperand, category, true);
                ++n2;
            }
            this.permissionsTable.refresh();
        }
    }

    private Set<IPermissionTemplateCategory> getCategories(IPermissionOperand permissionOperand) {
        TreeSet<IPermissionTemplateCategory> sortedCategories = new TreeSet<IPermissionTemplateCategory>(new Comparator<IPermissionTemplateCategory>(){

            @Override
            public int compare(IPermissionTemplateCategory c0, IPermissionTemplateCategory c1) {
                if (c0.getID().equals(IPermissionTemplateCategory.CATEGORY_ALL.getID())) {
                    return -1;
                }
                if (c1.getID().equals(IPermissionTemplateCategory.CATEGORY_ALL.getID())) {
                    return 1;
                }
                return c0.getDisplayName().compareToIgnoreCase(c1.getDisplayName());
            }
        });
        sortedCategories.add(IPermissionTemplateCategory.CATEGORY_ALL);
        for (CockpitPermissionTemplate cockpitPermissionTemplate : this.projectPermissionsGroup.getTemplates(this.projectAgent)) {
            IPermissionTemplateCategory category;
            if (!cockpitPermissionTemplate.getOperandType().equals(permissionOperand.getPermissionOperandType()) || (category = this.projectPermissionsGroup.getCategory(this.projectAgent, cockpitPermissionTemplate)) == null) continue;
            sortedCategories.add(category);
        }
        return sortedCategories;
    }
}

