/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.locking;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminProjectDictionary;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOLock;
import de.plans.psc.client.communication.ServerConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class LockingAdminTreeContentEntry {
    private static final int ROOT_ENTRY = 1;
    public static final int SERVER_ENTRY = 4;
    public static final int PROJECT_ENTRY = 3;
    public static final int CLIENT_ENTRY = 2;
    private int entryType = 0;
    private String clientName = null;
    private String projectID = null;
    private ServerConnection serverConnection = null;
    private EOLock lock = null;
    private final List<LockingAdminTreeContentEntry> children = new ArrayList<LockingAdminTreeContentEntry>();
    private LockingAdminTreeContentEntry parent = null;
    private LockingAdminProjectDictionary projectDictionary;
    private String cachedlabel = null;

    public LockingAdminTreeContentEntry() {
        this.entryType = 1;
    }

    public LockingAdminTreeContentEntry(String value, int entryType, ServerConnection sc, LockingAdminProjectDictionary projectDictionary) {
        if (entryType != 4) {
            if (entryType == 2) {
                this.clientName = value;
            } else if (entryType == 3) {
                this.projectID = value;
            } else assert (false) : "invalid entry type " + entryType;
        }
        this.serverConnection = sc;
        this.entryType = entryType;
        this.projectDictionary = projectDictionary;
    }

    public LockingAdminTreeContentEntry(EOLock lock, ServerConnection sc) {
        this.lock = lock;
        this.serverConnection = sc;
    }

    public void addChild(LockingAdminTreeContentEntry child) {
        this.children.add(child);
        child.setParent(this);
    }

    public List<LockingAdminTreeContentEntry> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean containsChild(Object child) {
        for (LockingAdminTreeContentEntry ce : this.children) {
            if (!ce.getIdentificator().equals(child)) continue;
            return true;
        }
        return false;
    }

    public LockingAdminTreeContentEntry getChild(Object identificator) {
        for (LockingAdminTreeContentEntry ce : this.children) {
            if (!ce.getIdentificator().equals(identificator)) continue;
            return ce;
        }
        return null;
    }

    private Object getIdentificator() {
        if (this.isLock()) {
            return this.lock;
        }
        if (this.isClient()) {
            return this.clientName;
        }
        if (this.isProject()) {
            return this.projectID;
        }
        if (this.isServer()) {
            return this.serverConnection.getServerID();
        }
        assert (false) : "invalid type";
        return null;
    }

    public boolean isRoot() {
        return this.entryType == 1;
    }

    public boolean isServer() {
        return this.entryType == 4;
    }

    public boolean isProject() {
        return this.entryType == 3;
    }

    public boolean isClient() {
        return this.entryType == 2;
    }

    public boolean isLock() {
        return this.lock != null;
    }

    public String getServerID() {
        return this.serverConnection.getServerID();
    }

    public EOLock getLock() {
        return this.lock;
    }

    public LockingAdminTreeContentEntry getParent() {
        return this.parent;
    }

    public String getLabel() {
        if (this.cachedlabel == null) {
            if (this.isRoot()) {
                this.cachedlabel = "root";
            }
            if (this.isServer()) {
                this.cachedlabel = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.Server"), (Object)this.serverConnection.getServerName());
            }
            if (this.isProject()) {
                String name = this.projectDictionary.getProjectName(this.projectID, this.getServerID());
                this.cachedlabel = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.Project"), (Object)name);
            }
            if (this.isClient()) {
                this.cachedlabel = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.Client"), (Object)this.clientName);
            }
            if (this.isLock()) {
                this.cachedlabel = this.getLabelForLock();
            }
        }
        assert (this.cachedlabel != null) : "invalid entry type";
        return this.cachedlabel;
    }

    private String getLabelForLock() {
        ProjectAgent[] agents;
        String lockedItemType = this.lock.getLockedItemType();
        String lockedItemUID = this.lock.getLockedItemUID();
        String lblItemName = "";
        String lblLockedItemUID = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.LockedItemUID"), (Object)lockedItemUID);
        String lblLockedItemType = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.LockedItemType"), (Object)lockedItemType);
        String lblLockType = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.LockType"), (Object)this.lock.getLockTypeID());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        String lblCreationTime = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.LockCreationTime"), (Object)dateFormat.format(this.lock.getCreationTime()));
        ProjectAgent[] projectAgentArray = agents = ProjectMgr.getProjectMgr().getConfiguredProjects();
        int n = agents.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectAgent agent = projectAgentArray[n2];
            String itemName = null;
            if (lockedItemType.equals("frame.project")) {
                if (lockedItemUID.equals(agent.getProjectUID())) {
                    itemName = agent.getProjectName();
                }
            } else if (lockedItemType.equals("com.arcway.cockpit.plan")) {
                if (agent.isOpened()) {
                    itemName = this.getPlanName(agent, lockedItemUID);
                }
            } else if (lockedItemType.equals("com.arcway.cockpit.uniqueelement")) {
                if (agent.isOpened()) {
                    itemName = this.getUniqueElementName(agent, lockedItemUID);
                }
            } else if (lockedItemType.equals("com.arcway.cockpit.section") && agent.isOpened()) {
                itemName = this.getSectionName(agent, lockedItemUID);
            }
            if (itemName != null) {
                lblItemName = NLS.bind((String)Messages.getString("LockingAdminTreeContentEntry.ElementName"), (Object)itemName);
            }
            ++n2;
        }
        String lblForLock = String.valueOf(lblLockedItemType) + lblLockedItemUID + lblItemName + lblLockType + lblCreationTime;
        return lblForLock;
    }

    private String getPlanName(ProjectAgent agent, String planID) {
        String planName = null;
        IPlan plan = agent.getFrameSectionManager().getPlan(planID);
        if (plan != null) {
            planName = plan.getPlanName();
        }
        return planName != null ? planName : "";
    }

    private String getUniqueElementName(ProjectAgent agent, String ueUID) {
        String ueName = null;
        IUniqueElement ue = agent.getUniqueElementMgr().getUniqueElement(ueUID);
        if (ue != null) {
            ueName = ue.getElementName();
        }
        return ueName != null ? ueName : "";
    }

    private String getSectionName(ProjectAgent agent, String sectionUID) {
        String sectionName = null;
        ISection section = agent.getSectionManager().getSection(sectionUID);
        if (section != null) {
            sectionName = section.getSectionName();
        }
        return sectionName != null ? sectionName : "";
    }

    private void setParent(LockingAdminTreeContentEntry parent) {
        this.parent = parent;
    }
}

