/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.locking;

import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminProjectDictionary;
import com.arcway.cockpit.frame.client.global.gui.dialogs.locking.LockingAdminTreeContentEntry;
import com.arcway.cockpit.frame.shared.message.EOLock;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.ServerConnection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LockingAdminLockTreeContentProvider
implements ITreeContentProvider {
    private final LockingAdminTreeContentEntry rootEntry = new LockingAdminTreeContentEntry();

    public LockingAdminTreeContentEntry getRootEntry() {
        return this.rootEntry;
    }

    public boolean hasChildren(Object sc) {
        LockingAdminTreeContentEntry ce = (LockingAdminTreeContentEntry)sc;
        return ce.hasChildren();
    }

    public Object getParent(Object element) {
        LockingAdminTreeContentEntry ce = (LockingAdminTreeContentEntry)element;
        return ce.getParent();
    }

    public Object[] getChildren(Object parentElement) {
        LockingAdminTreeContentEntry ce = (LockingAdminTreeContentEntry)parentElement;
        return ce.getChildren().toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addTreeContent(EOList<EOLock> locks, ServerConnection sc, LockingAdminProjectDictionary projectDictionary) {
        int i = 0;
        while (i < locks.size()) {
            EOLock lock = (EOLock)locks.get(i);
            this.addTreeContentEntry(lock.getProjectUID(), String.valueOf(lock.getUserName()) + " (" + lock.getClientName() + ")", lock, sc, projectDictionary);
            ++i;
        }
    }

    private void addTreeContentEntry(String project, String client, EOLock lock, ServerConnection sc, LockingAdminProjectDictionary projectDictionary) {
        if (projectDictionary.getProjectName(project, sc.getServerID()) != null) {
            LockingAdminTreeContentEntry clientEntry;
            LockingAdminTreeContentEntry projectEntry;
            LockingAdminTreeContentEntry serverEntry;
            if (!this.rootEntry.containsChild(sc.getServerID())) {
                serverEntry = new LockingAdminTreeContentEntry(null, 4, sc, projectDictionary);
                this.rootEntry.addChild(serverEntry);
            } else {
                serverEntry = this.rootEntry.getChild(sc.getServerID());
            }
            if (!serverEntry.containsChild(project)) {
                projectEntry = new LockingAdminTreeContentEntry(project, 3, sc, projectDictionary);
                serverEntry.addChild(projectEntry);
            } else {
                projectEntry = serverEntry.getChild(project);
            }
            if (!projectEntry.containsChild(client)) {
                clientEntry = new LockingAdminTreeContentEntry(client, 2, sc, projectDictionary);
                projectEntry.addChild(clientEntry);
            } else {
                clientEntry = projectEntry.getChild(client);
            }
            LockingAdminTreeContentEntry lockEntry = new LockingAdminTreeContentEntry(lock, sc);
            clientEntry.addChild(lockEntry);
        }
    }
}

