/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.IDVerifyListener;
import com.arcway.cockpit.frame.client.global.gui.dialogs.IconChooserDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.IObjectTypeCategoryModifier;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ObjectTypesCategorySetForDialog
implements DisposeListener {
    private static final int ICON_SIZE_X_Y_IN_PIXEL = 16;
    private static final ILogger logger = Logger.getLogger(ObjectTypesCategorySetForDialog.class);
    private final IFrameProjectAgent projectAgent;
    private ObjectTypeCategory category;
    private final IPropertiesDialog dialog;
    private boolean hasChanges = false;
    private String errorMessage;
    private Composite base;
    private Text txtID;
    private Text txtDisplayName;
    private Image icon;
    private IStreamResource iconStreamResource;
    private String humanReadableID = "";
    private String displayName = "";
    private final Collection<Control> controls = new ArrayList<Control>();
    private final IObjectTypeCategoryModifier typesModifier;
    private final String cockpitDataType;

    public ObjectTypesCategorySetForDialog(IPropertiesDialog dialog, Composite parent, IFrameProjectAgent projectAgent, String cockpitDataType, IObjectTypeCategoryModifier typesModifier) {
        this.projectAgent = projectAgent;
        this.dialog = dialog;
        this.typesModifier = typesModifier;
        this.cockpitDataType = cockpitDataType;
        this.createRowSet(parent, true);
    }

    public ObjectTypesCategorySetForDialog(IPropertiesDialog dialog, Composite parent, ObjectTypeCategory category, IFrameProjectAgent projectAgent, IObjectTypeCategoryModifier typesModifier, boolean editID) {
        this.category = category;
        this.projectAgent = projectAgent;
        this.dialog = dialog;
        this.typesModifier = typesModifier;
        this.cockpitDataType = category.getCockpitDataTypeID();
        this.createRowSet(parent, editID);
    }

    private void createRowSet(Composite parent, boolean editID) {
        this.controls.clear();
        this.base = new Composite(parent, 0);
        this.base.setLayoutData((Object)new GridData(768));
        this.base.setLayout((Layout)new GridLayout(3, false));
        this.base.addDisposeListener((DisposeListener)this);
        Label label = new Label(this.base, 0);
        label.setText(Messages.getString("ObjectTypesCategorySetForDialog.ID"));
        Composite compIDArea = new Composite(this.base, 0);
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        compIDArea.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        compIDArea.setLayout((Layout)layout);
        this.txtID = new Text(compIDArea, 2048);
        gridData = new GridData(768);
        this.txtID.setLayoutData((Object)gridData);
        if (this.category != null) {
            this.txtID.setText(this.category.getHumanReadableID());
        } else {
            this.txtID.setText(this.humanReadableID);
        }
        this.txtID.setEditable(editID);
        if (editID) {
            this.txtID.addVerifyListener((VerifyListener)IDVerifyListener.getInstance());
            this.txtID.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ObjectTypesCategorySetForDialog.this.humanReadableID = ObjectTypesCategorySetForDialog.this.txtID.getText();
                    ObjectTypesCategorySetForDialog.this.valueChanged();
                }
            });
        }
        this.controls.add((Control)this.txtID);
        this.humanReadableID = this.txtID.getText();
        label = new Label(this.base, 0);
        label.setText(Messages.getString("ObjectTypesCategorySetForDialog.DisplayName"));
        gridData = new GridData(4, 4, true, false, 2, 1);
        this.txtDisplayName = new Text(this.base, 2048);
        this.txtDisplayName.setLayoutData((Object)gridData);
        if (this.category != null) {
            this.txtDisplayName.setText(this.category.getDisplayName());
        } else {
            this.txtDisplayName.setText(this.displayName);
        }
        this.txtDisplayName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectTypesCategorySetForDialog.this.displayName = ObjectTypesCategorySetForDialog.this.txtDisplayName.getText();
                ObjectTypesCategorySetForDialog.this.valueChanged();
            }
        });
        this.controls.add((Control)this.txtDisplayName);
        this.displayName = this.txtDisplayName.getText();
        label = new Label(this.base, 0);
        label.setText(Messages.getString("ObjectTypesCategorySetForDialog.Icon"));
        final Label iconLabel = new Label(this.base, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        iconLabel.setLayoutData((Object)gridData);
        if (this.icon != null && !this.icon.isDisposed()) {
            this.icon.dispose();
        }
        if (this.category != null && this.category.getIcon() != null) {
            ImageData iconData = this.projectAgent.getFilesManager().getImageFromFile(this.category.getIcon(), "Error while retrieving icon file for category from FilesManager");
            if (iconData != null) {
                this.icon = new Image((Device)this.base.getDisplay(), iconData);
                iconLabel.setImage(this.icon);
            } else {
                logger.error("Icon file from category is missing unexpectedly (name=" + this.category.getDisplayName() + ", " + "id=" + this.category.getUID() + ", " + "dataTypId=" + this.category.getCockpitDataTypeID() + ")");
            }
        }
        Button btnChooseIconFile = new Button(this.base, 0);
        btnChooseIconFile.setText(Messages.getString("ObjectTypesCategorySetForDialog.ChooseIcon.Text"));
        btnChooseIconFile.setToolTipText(Messages.getString("ObjectTypesCategorySetForDialog.ChooseIcon.ToolTip"));
        btnChooseIconFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectTypesCategorySetForDialog.this.iconStreamResource = IconChooserDialog.selectIcon(ObjectTypesCategorySetForDialog.this.base.getShell(), 16);
                if (ObjectTypesCategorySetForDialog.this.icon != null && !ObjectTypesCategorySetForDialog.this.icon.isDisposed()) {
                    iconLabel.setImage(null);
                    ObjectTypesCategorySetForDialog.this.icon.dispose();
                    ObjectTypesCategorySetForDialog.this.icon = null;
                }
                if (ObjectTypesCategorySetForDialog.this.iconStreamResource != null) {
                    try {
                        ObjectTypesCategorySetForDialog.this.icon = new Image((Device)ObjectTypesCategorySetForDialog.this.base.getDisplay(), ObjectTypesCategorySetForDialog.this.iconStreamResource.toInputStream());
                        iconLabel.setImage(ObjectTypesCategorySetForDialog.this.icon);
                    }
                    catch (JvmExternalResourceInteractionException e1) {
                        logger.error("Error while displaying icon", (Throwable)e1);
                    }
                }
            }
        });
        this.controls.add((Control)btnChooseIconFile);
        parent.layout();
    }

    public void setEnabled(boolean enabled) {
        for (Control ctr : this.controls) {
            ctr.setEnabled(enabled);
        }
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    private void valueChanged() {
        this.hasChanges = true;
        if (this.category != null) {
            this.errorMessage = this.projectAgent.getObjectTypeCategoriesManager().isValidIdOrDisplayName(this.humanReadableID, true, this.typesModifier, this.category);
            if (this.errorMessage == null) {
                this.errorMessage = this.projectAgent.getObjectTypeCategoriesManager().isValidIdOrDisplayName(this.displayName, false, this.typesModifier, this.category);
            }
        } else {
            this.errorMessage = this.projectAgent.getObjectTypeCategoriesManager().isValidIdOrDisplayName(this.humanReadableID, true, this.typesModifier, this.cockpitDataType);
            if (this.errorMessage == null) {
                this.errorMessage = this.projectAgent.getObjectTypeCategoriesManager().isValidIdOrDisplayName(this.displayName, false, this.typesModifier, this.cockpitDataType);
            }
        }
        this.dialog.setMessage(this.errorMessage, 3, IPropertiesListEntry.DUMMY);
    }

    public String getHumanReadableID() {
        return this.humanReadableID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IStreamResource getIconFile() {
        return this.iconStreamResource;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.icon != null) {
            this.icon.dispose();
        }
    }
}

