/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LicenseHintDialog
extends Dialog {
    private final String htmlHintText;
    private int countDownCounter;
    private Timer timer;
    private Image image;

    public LicenseHintDialog(Shell parentShell, String htmlHintText, int countDownLength) {
        super(parentShell);
        this.setShellStyle(0);
        this.htmlHintText = htmlHintText;
        this.countDownCounter = countDownLength;
    }

    protected Point getInitialSize() {
        return new Point(600, 370);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(Display.getDefault().getSystemColor(1));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        base.setLayout((Layout)layout);
        base.setBackground(Display.getDefault().getSystemColor(1));
        Label lblImage = new Label(base, 0);
        lblImage.setLayoutData((Object)new GridData(768));
        this.image = FramePlugin.getImageDescriptor(Messages.getString("EvaluationHintDialog.imageFile")).createImage();
        lblImage.setImage(this.image);
        IBrowser browser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)base, (int)0);
        final Control browserControl = browser.getSWTControl();
        GridData gridData = new GridData(1808);
        browserControl.setLayoutData((Object)gridData);
        browser.setHtml(this.htmlHintText);
        if (browserControl instanceof Browser) {
            ((Browser)browserControl).addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                }

                public void changed(LocationEvent event) {
                    ((Browser)browserControl).execute("document.getElementsByTagName(\"body\")[0].style.overflow='hidden';");
                }
            });
        }
        return base;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn = this.createButton(parent, 0, "", false);
        btn.getParent().setBackground(Display.getDefault().getSystemColor(1));
        btn.setBackground(Display.getDefault().getSystemColor(1));
        btn.setEnabled(false);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new CountdownTask(), 0L, 1000L);
    }

    public boolean close() {
        if (this.countDownCounter == 0) {
            this.image.dispose();
            return super.close();
        }
        return false;
    }

    private class CountdownTask
    extends TimerTask {
        private CountdownTask() {
        }

        @Override
        public void run() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Button btn = LicenseHintDialog.this.getButton(0);
                    if (btn != null) {
                        if (LicenseHintDialog.this.countDownCounter > 0) {
                            btn.setText(String.valueOf(String.valueOf(LicenseHintDialog.this.countDownCounter)) + Messages.getString("EvaluationHintDialog.sec"));
                            LicenseHintDialog licenseHintDialog = LicenseHintDialog.this;
                            licenseHintDialog.countDownCounter = licenseHintDialog.countDownCounter - 1;
                        } else {
                            LicenseHintDialog.this.timer.cancel();
                            btn.setText(IDialogConstants.OK_LABEL);
                            btn.setEnabled(true);
                        }
                    }
                }
            };
            Display.getDefault().asyncExec(runnable);
        }
    }
}

