/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class IconChooserDialog {
    private static final String FILE_NAME = "icon.png";
    private static final ILogger LOGGER = Logger.getLogger(IconChooserDialog.class);

    private IconChooserDialog() {
    }

    public static IStreamResource selectIcon(Shell baseShell, int iconSizeXYInPixel) {
        FileDialog fileChooser = new FileDialog(baseShell);
        fileChooser.setText(Messages.getString("PropertyAdvancedProject.8"));
        fileChooser.setFilterExtensions(new String[]{"*.gif; *.jpg; *.png; *.ico; *.bmp"});
        fileChooser.setFilterNames(new String[]{String.valueOf(Messages.getString("PropertyAdvancedProject.10")) + " (gif, jpeg, png, ico, bmp)"});
        String filename = fileChooser.open();
        if (filename != null) {
            try {
                File file = new File(filename);
                FileResource fileResource = new FileResource(file);
                Image iconImage = ImageCoDec.decodeIntoImage((IStreamResource)fileResource);
                if (iconImage.getHeightInPixels() > iconSizeXYInPixel || iconImage.getWidthInPixels() > iconSizeXYInPixel) {
                    int max = iconImage.getHeightInPixels();
                    if (iconImage.getWidthInPixels() > max) {
                        max = iconImage.getWidthInPixels();
                    }
                    float scaleDownFactor = (float)iconSizeXYInPixel / (float)max;
                    Image scaledIconImage = Image.scaleImage((Image)iconImage, (int)Math.round((float)iconImage.getWidthInPixels() * scaleDownFactor), (int)Math.round((float)iconImage.getHeightInPixels() * scaleDownFactor));
                    iconImage.dispose();
                    iconImage = scaledIconImage;
                }
                if (iconImage.getHeightInPixels() < iconSizeXYInPixel || iconImage.getWidthInPixels() < iconSizeXYInPixel) {
                    Image centeredImage = Image.centerImage((Image)iconImage, (int)iconSizeXYInPixel, (int)iconSizeXYInPixel);
                    iconImage.dispose();
                    iconImage = centeredImage;
                }
                final byte[] iconByte = ImageCoDec.encodeIntoByteArray((Image)iconImage, (ImageFileType)ImageCoDec.PNG);
                iconImage.dispose();
                IStreamResource newIconStreamResource = new IStreamResource(){

                    public InputStream toInputStream() throws JvmExternalResourceInteractionException {
                        return new ByteArrayInputStream(iconByte);
                    }

                    public String getName() {
                        return IconChooserDialog.FILE_NAME;
                    }
                };
                return newIconStreamResource;
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
            catch (EXImageDataTypeNotSupported e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
            catch (EXUnsupportedColorDepth e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
            catch (EXNoMoreHandles e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
            catch (EXImageTooBig e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
            catch (EXCorruptImageFileContent e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
            catch (EXUnspecifiedImageLoadingError e) {
                LOGGER.error("Error while processing the image", (Throwable)e);
            }
        }
        return null;
    }
}

