/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.IDVerifyListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributeTypesRowSetForDialog {
    private static final ILogger logger = Logger.getLogger(AttributeTypesRowSetForDialog.class);
    private final IFrameProjectAgent projectAgent;
    private IAttributeType attributeType;
    private final IPropertiesDialog dialog;
    private boolean hasChanges = false;
    private String errorMessage;
    private Composite base;
    private Text txtID;
    private Text txtDisplayName;
    private String humanReadableID = "";
    private String displayName = "";
    private IAttributeTypeDataType selectedDataType;
    private IValueRange valueRange;
    private Control valueRangeControl;
    private final Collection<Control> controls = new ArrayList<Control>();
    private final IAttributeTypesModifier typesModifier;
    private final String cockpitDataType;

    public AttributeTypesRowSetForDialog(IPropertiesDialog dialog, Composite parent, IFrameProjectAgent projectAgent, String cockpitDataType, IAttributeTypesModifier typesModifier) {
        this.projectAgent = projectAgent;
        this.dialog = dialog;
        this.typesModifier = typesModifier;
        this.cockpitDataType = cockpitDataType;
        this.createRowSet(parent, true, true);
    }

    public AttributeTypesRowSetForDialog(IPropertiesDialog dialog, Composite parent, IAttributeType attributeType, IFrameProjectAgent projectAgent, IAttributeTypesModifier typesModifier, boolean editID, boolean showValueRange) {
        this.attributeType = attributeType;
        this.projectAgent = projectAgent;
        this.dialog = dialog;
        this.typesModifier = typesModifier;
        this.cockpitDataType = attributeType.getCockpitDataType().getCockpitDataTypeID();
        this.createRowSet(parent, editID, showValueRange);
    }

    private void createRowSet(final Composite parent, final boolean editID, final boolean showValueRange) {
        this.controls.clear();
        this.base = new Composite(parent, 0);
        this.base.setLayoutData((Object)new GridData(768));
        this.base.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.base, 0);
        label.setText(Messages.getString("AttributeTypesRowSetForDialog.ID"));
        Composite compIDArea = new Composite(this.base, 0);
        GridData gridData = new GridData(768);
        compIDArea.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        compIDArea.setLayout((Layout)layout);
        this.txtID = new Text(compIDArea, 2048);
        gridData = new GridData(768);
        this.txtID.setLayoutData((Object)gridData);
        if (this.attributeType != null) {
            this.txtID.setText(this.attributeType.getHumanReadableIDWithoutPrefix());
        } else {
            this.txtID.setText(this.humanReadableID);
        }
        this.txtID.setEditable(editID);
        if (editID) {
            this.txtID.addVerifyListener((VerifyListener)IDVerifyListener.getInstance());
            this.txtID.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AttributeTypesRowSetForDialog.this.humanReadableID = AttributeTypesRowSetForDialog.this.txtID.getText();
                    AttributeTypesRowSetForDialog.this.valueChanged();
                }
            });
        }
        this.controls.add((Control)this.txtID);
        this.humanReadableID = this.txtID.getText();
        label = new Label(this.base, 0);
        label.setText(Messages.getString("AttributeTypesRowSetForDialog.display_name_field"));
        gridData = new GridData(768);
        this.txtDisplayName = new Text(this.base, 2048);
        this.txtDisplayName.setLayoutData((Object)gridData);
        if (this.attributeType != null) {
            this.txtDisplayName.setText(this.attributeType.getDisplayName());
        } else {
            this.txtDisplayName.setText(this.displayName);
        }
        this.txtDisplayName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeTypesRowSetForDialog.this.displayName = AttributeTypesRowSetForDialog.this.txtDisplayName.getText();
                AttributeTypesRowSetForDialog.this.valueChanged();
            }
        });
        this.controls.add((Control)this.txtDisplayName);
        this.displayName = this.txtDisplayName.getText();
        label = new Label(this.base, 0);
        label.setText(Messages.getString("AttributeTypesRowSetForDialog.data_type_field"));
        gridData = new GridData(768);
        Collection<IAttributeTypeDataType> dataTypes = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAvailableDataTypes();
        Comparator<IAttributeTypeDataType> comparator = new Comparator<IAttributeTypeDataType>(){

            @Override
            public int compare(IAttributeTypeDataType arg0, IAttributeTypeDataType arg1) {
                IAttributeTypeDataType dt0 = arg0;
                IAttributeTypeDataType dt1 = arg1;
                return dt0.getDisplayName().compareTo(dt1.getDisplayName());
            }
        };
        TreeSet<IAttributeTypeDataType> sortedSet = new TreeSet<IAttributeTypeDataType>(comparator);
        sortedSet.addAll(dataTypes);
        final Combo cmbDataTypes = new Combo(this.base, 2060);
        cmbDataTypes.setLayoutData((Object)gridData);
        int nr = 0;
        for (IAttributeTypeDataType dataType : sortedSet) {
            cmbDataTypes.add(dataType.getDisplayName(), nr);
            cmbDataTypes.setData(dataType.getDisplayName(), (Object)dataType);
            if (this.attributeType != null) {
                if (this.attributeType.getDataType().equals(dataType)) {
                    cmbDataTypes.select(nr);
                    this.selectedDataType = dataType;
                }
            } else {
                if (this.selectedDataType == null && dataType.getID().equals("string")) {
                    this.selectedDataType = dataType;
                }
                if (this.selectedDataType != null && this.selectedDataType.equals(dataType)) {
                    cmbDataTypes.select(nr);
                }
            }
            ++nr;
        }
        if (this.attributeType != null) {
            cmbDataTypes.setEnabled(false);
        } else {
            cmbDataTypes.setEnabled(true);
            cmbDataTypes.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedDisplayName = cmbDataTypes.getItem(cmbDataTypes.getSelectionIndex());
                    AttributeTypesRowSetForDialog.this.selectedDataType = (IAttributeTypeDataType)cmbDataTypes.getData(selectedDisplayName);
                    AttributeTypesRowSetForDialog.this.base.dispose();
                    AttributeTypesRowSetForDialog.this.createRowSet(parent, editID, showValueRange);
                    parent.layout();
                    AttributeTypesRowSetForDialog.this.valueChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.controls.add((Control)cmbDataTypes);
        String selectedDisplayName = cmbDataTypes.getItem(cmbDataTypes.getSelectionIndex());
        this.selectedDataType = (IAttributeTypeDataType)cmbDataTypes.getData(selectedDisplayName);
        if (showValueRange) {
            label = new Label(this.base, 0);
            label.setText(Messages.getString("AttributeTypesRowSetForDialog.default_value_field"));
            gridData = new GridData(16384, 128, false, true);
            label.setLayoutData((Object)gridData);
            label.setVisible(false);
            final IValueRangeDefiner valueRangeHelper = this.selectedDataType.getValueRangeHelper();
            if (valueRangeHelper != null) {
                label.setVisible(true);
                Composite defaultArea = new Composite(this.base, 0);
                layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.horizontalSpacing = 0;
                layout.verticalSpacing = 0;
                defaultArea.setLayout((Layout)layout);
                gridData = new GridData(1808);
                gridData.heightHint = 220;
                defaultArea.setLayoutData((Object)gridData);
                IValueRangeDefiner.IValueDeletionPolicy valueDeletionPolicy = this.attributeType != null ? valueRangeHelper.getValueDeletionPolicyForOnlyIfNotInUse((IProjectAgent)this.projectAgent, this.attributeType) : IValueRangeDefiner.VALUEDELETIONPOLICY_ALWAYSALLOWED;
                this.valueRangeControl = valueRangeHelper.createSWTControl(defaultArea, -1, valueDeletionPolicy);
                if (this.attributeType != null) {
                    this.valueRange = this.attributeType.getValueRange();
                    valueRangeHelper.setContentForSWTControl(this.valueRangeControl, this.valueRange);
                } else {
                    this.valueRange = valueRangeHelper.getValueRangeFromSWTControl(this.valueRangeControl);
                }
                valueRangeHelper.addSWTControlModifiedListener(this.valueRangeControl, new ISWTControlModifiedListener(){

                    public void modified(Object newValue, Object additionalInfo) {
                        try {
                            AttributeTypesRowSetForDialog.this.valueRange = valueRangeHelper.getValueRangeFromSWTControl(AttributeTypesRowSetForDialog.this.valueRangeControl);
                            AttributeTypesRowSetForDialog.this.valueChanged();
                        }
                        catch (ExInvalidDataType e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                    }

                    public void setModificationInProgress(boolean modificationInProgress) {
                    }
                });
            } else {
                Composite composite = new Composite(this.base, 0);
                gridData = new GridData(4, 4, true, true);
                gridData.heightHint = 220;
                composite.setLayoutData((Object)gridData);
            }
        }
        parent.layout();
    }

    public void setEnabled(boolean enabled) {
        for (Control ctr : this.controls) {
            ctr.setEnabled(enabled);
        }
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    private void valueChanged() {
        IValueRange vr;
        IValueRangeDefiner valueRangeHelper;
        this.hasChanges = true;
        if (this.attributeType != null) {
            this.errorMessage = this.projectAgent.getFrameUserDefinedAttributeTypesManager().isValidIdOrDisplayName(this.humanReadableID, true, this.typesModifier, this.attributeType);
            if (this.errorMessage == null) {
                this.errorMessage = this.projectAgent.getFrameUserDefinedAttributeTypesManager().isValidIdOrDisplayName(this.displayName, false, this.typesModifier, this.attributeType);
            }
        } else {
            this.errorMessage = this.projectAgent.getFrameUserDefinedAttributeTypesManager().isValidIdOrDisplayName(this.humanReadableID, true, this.typesModifier, this.cockpitDataType);
            if (this.errorMessage == null) {
                this.errorMessage = this.projectAgent.getFrameUserDefinedAttributeTypesManager().isValidIdOrDisplayName(this.displayName, false, this.typesModifier, this.cockpitDataType);
            }
        }
        if (this.errorMessage == null && (valueRangeHelper = this.selectedDataType.getValueRangeHelper()) != null && (vr = valueRangeHelper.getValueRangeFromSWTControl(this.valueRangeControl)) == null) {
            this.errorMessage = Messages.getString("AttributeTypesRowSetForDialog.enter_default_value");
        }
        this.dialog.setMessage(this.errorMessage, 3, IPropertiesListEntry.DUMMY);
    }

    public String getHumanReadableID() {
        return this.humanReadableID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IAttributeTypeDataType getDataType() {
        return this.selectedDataType;
    }

    public IValueRange getValueRange() {
        return this.valueRange;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Control getValueRangeControl() {
        return this.valueRangeControl;
    }
}

