/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.AbstractUserDefinedObjectTypesCategoryDialog;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ObjectTypesCategorySetForDialog;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.IObjectTypeCategoryModifier;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.util.Collections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddUserDefinedObjectTypesCategoryDialog
extends AbstractUserDefinedObjectTypesCategoryDialog {
    private static final ILogger LOGGER = Logger.getLogger(AddUserDefinedObjectTypesCategoryDialog.class);
    private final ICockpitDataType cockpitDataType;
    private final IObjectTypeCategoryModifier typesModifier;
    private final int sortPosition;
    private ObjectTypesCategorySetForDialog rowSet;
    private ObjectTypeCategory objectTypeCategory;

    public AddUserDefinedObjectTypesCategoryDialog(Shell parentShell, IFrameProjectAgent projectAgent, ICockpitDataType cockpitDataType, int sortPosition, IObjectTypeCategoryModifier typesModifier) {
        super(parentShell, projectAgent);
        this.cockpitDataType = cockpitDataType;
        this.typesModifier = typesModifier;
        this.sortPosition = sortPosition;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("AddUserDefinedObjectTypesCategoryDialog.addCategory"));
        this.setTitle(Messages.getString("AddUserDefinedObjectTypesCategoryDialog.addCategory"));
        this.setMessage(Messages.getString("AddUserDefinedObjectTypesCategoryDialog.defineNewCategory"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        base.setLayout((Layout)new GridLayout());
        this.rowSet = new ObjectTypesCategorySetForDialog(this, base, this.getProjectAgent(), this.cockpitDataType.getCockpitDataTypeID(), this.typesModifier);
        return base;
    }

    protected void okPressed() {
        String humanReadableID = this.rowSet.getHumanReadableID();
        ObjectTypeCategoryID objectTypeCategoryID = ObjectTypeCategoryID.createObjectTypeCategoryID();
        String displayName = this.rowSet.getDisplayName();
        FileID icon = FileID.NO_FILE;
        IStreamResource iconStream = this.rowSet.getIconFile();
        if (iconStream != null) {
            try {
                icon = this.getProjectAgent().getFilesManager().loadFileIntoTemporaryStorage(iconStream);
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.error("Could not load file for the category icon into temporary storage", (Throwable)e);
            }
        }
        this.objectTypeCategory = new ObjectTypeCategory(objectTypeCategoryID, humanReadableID, this.getProjectUID(), this.cockpitDataType.getCockpitDataTypeID(), this.sortPosition, displayName, icon, Collections.emptySet());
        super.okPressed();
    }

    @Override
    public ObjectTypeCategory getObjectTypesCategory() {
        return this.objectTypeCategory;
    }
}

