/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayTitleAreaDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialogWithCategorySelection
extends ArcwayTitleAreaDialog {
    private static final ILogger LOGGER = Logger.getLogger(AbstractDialogWithCategorySelection.class);
    protected IFrameProjectAgent projectAgent;
    private List<ObjectTypeCategory> allCategories;
    private ObjectTypeCategoryID selectedCategoryID = null;

    public AbstractDialogWithCategorySelection(Shell shell, boolean createModificationProblemButton, IFrameProjectAgent projectAgent) {
        super(shell, createModificationProblemButton);
        this.projectAgent = projectAgent;
    }

    protected Control createDialogArea(Composite parent) {
        Control toReturn = this.createDialogArea_internal(parent);
        final Combo categoryCombo = this.getCategoryCombo();
        this.allCategories = this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.getFrameDataTypeID());
        categoryCombo.add(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY);
        for (ObjectTypeCategory category : this.allCategories) {
            categoryCombo.add(category.getDisplayName());
        }
        categoryCombo.select(0);
        categoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = categoryCombo.getSelectionIndex();
                if (selectionIndex == 0) {
                    AbstractDialogWithCategorySelection.this.selectedCategoryID = null;
                } else {
                    AbstractDialogWithCategorySelection.this.selectedCategoryID = ((ObjectTypeCategory)AbstractDialogWithCategorySelection.this.allCategories.get(selectionIndex - 1)).getObjectTypeCategoryID();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return toReturn;
    }

    protected abstract Control createDialogArea_internal(Composite var1);

    protected abstract Combo getCategoryCombo();

    protected abstract String getFrameDataTypeID();

    public ObjectTypeCategoryID getObjectTypeCategoryID() {
        return this.selectedCategoryID;
    }
}

