/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.copypaste;

import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendModuleType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ModelAccess;
import com.arcway.lib.eclipse.uiframework.dialogs.imports.ImportDialog;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.dialog.imports.TabDescription;
import com.arcway.lib.ui.dialog.imports.TreeViewInput;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.repository.cockpit.interFace.declaration.frame.plan.CMTIDsPlan;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.CMTIDsProject;
import com.arcway.repository.cockpit.interFace.declaration.frame.reporttemplate.CMTIDsReportTemplates;
import com.arcway.repository.cockpit.interFace.declaration.frame.section.CMTIDsSection;
import com.arcway.repository.cockpit.interFace.declaration.frame.stakeholder.CMTIDsStakeholder;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.importexport.imporT.IImportJobEditor;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObjectType;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MIJEImportDialog
implements IImportJobEditor {
    private final EclipseWindow eclipseWindow;
    private final boolean openDialogEvenIfJobIsExecutableWithoutWarnings;

    public MIJEImportDialog(EclipseWindow eclipseWindow) {
        this(eclipseWindow, false);
    }

    public MIJEImportDialog(EclipseWindow eclipseWindow, boolean openDialogEvenIfJobIsExecutableWithoutWarnings) {
        this.eclipseWindow = eclipseWindow;
        this.openDialogEvenIfJobIsExecutableWithoutWarnings = openDialogEvenIfJobIsExecutableWithoutWarnings;
    }

    public IImportJobEditor.ResultCode editImportJob(IImportJob importJob, IRepositorySnapshotRO snapshot, boolean executionMessagesOccurred) throws EXNotReproducibleSnapshot {
        IImportedObject singleObjectImportObject = MIJEImportDialog.containsSingleObject(importJob);
        List<TabDescription> tabDescriptions = this.getTabDescriptions(importJob, snapshot);
        ModelAccess modelAccess = new ModelAccess(importJob, snapshot);
        try {
            IMessageLevel highestLevel = modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().getMessageSetForAllMessages().getHighestLevel();
            if (executionMessagesOccurred || highestLevel != null && highestLevel.isHigherThanInformation() || this.openDialogEvenIfJobIsExecutableWithoutWarnings) {
                if (ImportDialog.openImportDialog((EclipseWindow)this.eclipseWindow, (Object)singleObjectImportObject, tabDescriptions, (IImportModelAccess)modelAccess) == 0) {
                    IImportJobEditor.ResultCode resultCode = IImportJobEditor.ResultCode.COMPLETED_CALLAGAIN;
                    return resultCode;
                }
                IImportJobEditor.ResultCode resultCode = IImportJobEditor.ResultCode.ABORTIMPORT;
                return resultCode;
            }
            IImportJobEditor.ResultCode resultCode = IImportJobEditor.ResultCode.COMPLETED_CALLAGAIN;
            return resultCode;
        }
        catch (EEXNotReproducibleSnapshot e) {
            throw (EXNotReproducibleSnapshot)e.getCause();
        }
        catch (EEXSnapshotClosed e) {
            IImportJobEditor.ResultCode resultCode = IImportJobEditor.ResultCode.ABORTIMPORT;
            return resultCode;
        }
        finally {
            modelAccess.dispose();
        }
    }

    private List<TabDescription> getTabDescriptions(IImportJob importJob, IRepositorySnapshotRO repositorySnapshotRO) {
        TabDescription tabDescription;
        ArrayList<TabDescription> tabDescriptions = new ArrayList<TabDescription>();
        IRepositoryTypeManagerRO repositoryTypeManager = repositorySnapshotRO.getTypeManager();
        ArrayList<IRepositoryModuleTypeID> projectNavigatorTabModuleTypeIds = new ArrayList<IRepositoryModuleTypeID>();
        projectNavigatorTabModuleTypeIds.add((IRepositoryModuleTypeID)CMTIDsSection.MODULE_TYPE_ID);
        projectNavigatorTabModuleTypeIds.add((IRepositoryModuleTypeID)CMTIDsPlan.MODULE_TYPE_ID);
        projectNavigatorTabModuleTypeIds.add((IRepositoryModuleTypeID)CMTIDsStakeholder.MODULE_TYPE_ID);
        projectNavigatorTabModuleTypeIds.add((IRepositoryModuleTypeID)CMTIDsReportTemplates.MODULE_TYPE_ID);
        MIJEImportDialog.addTabDescription(tabDescriptions, this.createTabDescription(importJob, repositoryTypeManager, (IRepositoryModuleTypeID)CMTIDsProject.MODULE_TYPE_ID, projectNavigatorTabModuleTypeIds));
        IList_ allModuleTypes = repositorySnapshotRO.getTypeManager().getAllModuleTypes();
        for (IRepositoryModuleType moduletype : allModuleTypes) {
            IRepositoryModuleTypeID moduleTypeID = moduletype.getRepositoryModuleTypeID();
            if (projectNavigatorTabModuleTypeIds.contains(moduleTypeID) || CMTIDsProject.MODULE_TYPE_ID.equals(moduleTypeID)) continue;
            ArrayList<IRepositoryModuleTypeID> otherTabModuleTypeIds = new ArrayList<IRepositoryModuleTypeID>();
            otherTabModuleTypeIds.add(moduleTypeID);
            MIJEImportDialog.addTabDescription(tabDescriptions, this.createTabDescription(importJob, repositoryTypeManager, moduleTypeID, otherTabModuleTypeIds));
        }
        if (tabDescriptions.size() > 1 && !(tabDescription = MIJEImportDialog.createMessageTabDescription(importJob)).getInput().getRootObjects().isEmpty()) {
            tabDescriptions.add(0, tabDescription);
        }
        return tabDescriptions;
    }

    private static void addTabDescription(List<TabDescription> tabDescriptions, TabDescription tabDescription) {
        if (!tabDescription.getInput().getRootObjects().isEmpty()) {
            tabDescriptions.add(tabDescription);
        }
    }

    private TabDescription createTabDescription(IImportJob importJob, IRepositoryTypeManagerRO repositoryTypeManager, IRepositoryModuleTypeID tabDescribingModuleTypeID, List<IRepositoryModuleTypeID> contentModuleTypeIDs) {
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)repositoryTypeManager);
        StringBuilder tabToolTop = new StringBuilder();
        for (IRepositoryModuleTypeID contentModuleTypeID : contentModuleTypeIDs) {
            IRepositoryModuleType repositoryModuleType = repositoryTypeManager.getModuleType(contentModuleTypeID);
            IFrontendModuleType frontendModuleType = frontendTypeManager.getFrontendModuleType(repositoryModuleType);
            if (tabToolTop.length() > 0) {
                tabToolTop.append(", ");
            }
            tabToolTop.append(frontendModuleType.getLabel().getText());
        }
        IRepositoryModuleType repositoryModuleType = repositoryTypeManager.getModuleType(tabDescribingModuleTypeID);
        IFrontendModuleType frontendModuleType = frontendTypeManager.getFrontendModuleType(repositoryModuleType);
        IStreamResource tabIcon16x16 = frontendModuleType.getLabel().getIcon16x16();
        TreeViewInput<IImportedObject> treeViewInput = this.getTreeViewInput(importJob, contentModuleTypeIDs);
        TabDescription tabDescription = new TabDescription(tabToolTop.toString(), tabIcon16x16, treeViewInput, false);
        return tabDescription;
    }

    private static TabDescription createMessageTabDescription(IImportJob importJob) {
        String tabToolTop = Messages.getString("MIJEImportDialog.ToolTipText");
        IStreamResource tabIcon16x16 = Icons16x16.INFO;
        ArrayList allObjects = new ArrayList();
        HashMap parent2Children = new HashMap();
        Collection importedObjectTypes = importJob.getImportedObjectTypes();
        for (IImportedObjectType importedObjectType : importedObjectTypes) {
            Collection allObjectsOfCurrentType = importedObjectType.getObjects();
            allObjects.addAll(allObjectsOfCurrentType);
            for (IImportedObject importedObject : allObjectsOfCurrentType) {
                parent2Children.put(importedObject, Collections.emptyList());
            }
        }
        TreeViewInput input = new TreeViewInput(allObjects, parent2Children);
        TabDescription tabDescription = new TabDescription(tabToolTop, tabIcon16x16, input, true);
        return tabDescription;
    }

    private TreeViewInput<IImportedObject> getTreeViewInput(IImportJob importJob, List<IRepositoryModuleTypeID> tabModuleTypeIds) {
        List<IRepositoryModuleTypeID> repositoryModuleTypeIDs = tabModuleTypeIds;
        HashMap<IImportedObject, List<? extends IImportedObject>> parent2Children = new HashMap<IImportedObject, List<? extends IImportedObject>>();
        ArrayList rootObjects = new ArrayList();
        for (IRepositoryModuleTypeID moduleTypeID : repositoryModuleTypeIDs) {
            Collection importedObjectTypes = importJob.getImportedObjectTypes();
            for (IImportedObjectType importedObjectType : importedObjectTypes) {
                IRepositoryObjectType repositoryObjectType = importedObjectType.getObjectType();
                IRepositoryModuleTypeID importedObjectTypeModuleTypeID = repositoryObjectType.getModuleType().getRepositoryModuleTypeID();
                if (!IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER.isEqual((Object)moduleTypeID, (Object)importedObjectTypeModuleTypeID)) continue;
                rootObjects.addAll(importedObjectType.getRootObjects());
            }
            this.collectChildrenRecursively(rootObjects, parent2Children);
        }
        TreeViewInput input = new TreeViewInput(rootObjects, parent2Children);
        return input;
    }

    private static IImportedObject containsSingleObject(IImportJob importJob) {
        IImportedObject multiObjectImport = null;
        for (IImportedObjectType importedObjectType : importJob.getImportedObjectTypes()) {
            int objectsOfThisType = importedObjectType.getObjects().size();
            if (objectsOfThisType > 0 && multiObjectImport != null || objectsOfThisType > 1) {
                multiObjectImport = null;
                break;
            }
            if (objectsOfThisType != 1) continue;
            multiObjectImport = (IImportedObject)importedObjectType.getObjects().iterator().next();
        }
        return multiObjectImport;
    }

    private void collectChildrenRecursively(List<? extends IImportedObject> parentsToAdd_in, Map<IImportedObject, List<? extends IImportedObject>> parent2Children_mod) {
        for (IImportedObject iImportedObject : parentsToAdd_in) {
            List children = iImportedObject.getChildren();
            parent2Children_mod.put(iImportedObject, children);
            this.collectChildrenRecursively(children, parent2Children_mod);
        }
    }
}

