/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.copypaste;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.copypaste.ClipboardManager;
import com.arcway.cockpit.frame.client.global.gui.copypaste.CopyManager;
import com.arcway.cockpit.frame.client.global.gui.copypaste.ICopyConfiguration;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IParentRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractPTCopyPaste_NonPlatformUI
extends PropertyTester {
    public final boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)receiver).toList();
            if (property.equals("pasteenabled")) {
                if (selectedObjects.size() != 1) {
                    return false;
                }
                if (!(selectedObjects.get(0) instanceof ICockpitProjectData)) {
                    return false;
                }
                ICockpitProjectData targetItem = (ICockpitProjectData)selectedObjects.get(0);
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(targetItem.getProjectUID());
                if (projectAgent == null || !projectAgent.isOpened()) {
                    return false;
                }
                if (!this.checkLicense(projectAgent)) {
                    return false;
                }
                IRepositoryObjectTypeID objectTypeID = this.mapCockpitTypeIDToRepositoryTypeID(targetItem.getTypeID());
                if (objectTypeID == null) {
                    return false;
                }
                IRepositoryPropertySetSample targetItemOjectID = projectAgent.getRepositoryObjectID(targetItem.getUID());
                RepositoryObjectReference targetItemObjectReference = new RepositoryObjectReference(objectTypeID, targetItemOjectID);
                return CopyManager.isPastePossible((IRepositoryObjectReference)targetItemObjectReference, ClipboardManager.retrieveExplicitRootObjectTypeIDsContentInClipboard(), projectAgent.getRepositoryInterface());
            }
            if (property.equals("copyenabled")) {
                String projectUID = null;
                IRepositoryTypeManagerRO typeManager = null;
                HashSet_ containedObjectTypes = new HashSet_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
                HashSet_ objectTypesToBeSelectedForCopy = new HashSet_(this.getCopyConfiguration().getObjectTypesToBeSelectedForCopy(), IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
                for (Object selectedObject : selectedObjects) {
                    if (!(selectedObject instanceof ICockpitProjectData)) {
                        return false;
                    }
                    ICockpitProjectData selectedCockpitProjectData = (ICockpitProjectData)selectedObject;
                    if (projectUID == null) {
                        projectUID = selectedCockpitProjectData.getProjectUID();
                        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                        if (projectAgent == null || !projectAgent.isOpened()) {
                            return false;
                        }
                        if (!this.checkLicense(projectAgent)) {
                            return false;
                        }
                        typeManager = projectAgent.getRepositoryInterface().getTypeManager();
                    } else if (!projectUID.equals(selectedCockpitProjectData.getProjectUID())) {
                        return false;
                    }
                    String selectedObjectCockpitTypeID = selectedCockpitProjectData.getTypeID();
                    IRepositoryObjectTypeID selectedObjectRepositoryTypeID = this.mapCockpitTypeIDToRepositoryTypeID(selectedObjectCockpitTypeID);
                    if (selectedObjectRepositoryTypeID == null) {
                        return false;
                    }
                    IRepositoryObjectType selectedObjectObjectType = typeManager.getObjectType(selectedObjectRepositoryTypeID);
                    if (RepositoryObjectTypes.findMostSpecificSuperObjectType((IRepositoryObjectType)selectedObjectObjectType, (ISet_)objectTypesToBeSelectedForCopy) == null) {
                        return false;
                    }
                    containedObjectTypes.add((Object)selectedObjectRepositoryTypeID);
                }
                return AbstractPTCopyPaste_NonPlatformUI.commonParentTypeExists((ICollection_<IRepositoryObjectTypeID>)containedObjectTypes, typeManager);
            }
            return false;
        }
        return false;
    }

    protected abstract ICopyConfiguration getCopyConfiguration();

    protected abstract IClientFunctionLicenseType2 getRequiredLicenseType();

    protected abstract IRepositoryObjectTypeID mapCockpitTypeIDToRepositoryTypeID(String var1);

    private static boolean commonParentTypeExists(ICollection_<IRepositoryObjectTypeID> containedObjectTypes, IRepositoryTypeManagerRO typeManager) {
        HashSet_ possibleParentTypes = null;
        for (IRepositoryObjectTypeID containedObjectTypeID : containedObjectTypes) {
            IRepositoryObjectType containedObjectType = typeManager.getObjectType(containedObjectTypeID);
            HashSet_ possibleParentTypesForContainedType = new HashSet_(IRepositoryDeclarationItem.EQUAL_ID_HASHER);
            for (IParentRepositoryRelationContributionType parentType : containedObjectType.getParentRelationContributionTypesToParentObjectTypes()) {
                possibleParentTypesForContainedType.addAll(parentType.getRelatedObjectType().getAllInstanciableObjectTypesOfThisType());
            }
            if (possibleParentTypes == null) {
                possibleParentTypes = possibleParentTypesForContainedType;
                continue;
            }
            possibleParentTypes.retainAll((ISet_)possibleParentTypesForContainedType);
        }
        return possibleParentTypes != null && !possibleParentTypes.isEmpty();
    }

    private boolean checkLicense(ProjectAgent projectAgent) {
        return projectAgent.getServerLicenseManager().isLicenseOperationAllowed(this.getRequiredLicenseType());
    }
}

