/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.copypaste;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.copypaste.ClipboardManager;
import com.arcway.cockpit.frame.client.global.gui.copypaste.CopyManager;
import com.arcway.cockpit.frame.client.global.gui.copypaste.IPasteConfiguration;
import com.arcway.cockpit.frame.client.global.gui.copypaste.RepositorySnippetClipboardContent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.importexport.ImportExportException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractCHPaste_NonPlatformUI
extends AbstractHandler {
    private static final ILogger LOGGER = Logger.getLogger(AbstractCHPaste_NonPlatformUI.class);

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            if (selection == null) {
                selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            }
            if (selection instanceof IStructuredSelection) {
                assert (((IStructuredSelection)selection).size() == 1);
                Object selectedObject = ((IStructuredSelection)selection).toList().get(0);
                assert (selectedObject instanceof ICockpitProjectData);
                ICockpitProjectData selectedCockpitObject = (ICockpitProjectData)selectedObject;
                final ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(selectedCockpitObject.getProjectUID());
                final IRepositoryObjectReference targetObjectReference = projectAgent.getRepositoryPlattformController().getRepositoryObjectReference(selectedCockpitObject);
                final EclipseWindow window = new EclipseWindow(event);
                try {
                    IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
                    if (CopyManager.isPastePossible(targetObjectReference, ClipboardManager.retrieveExplicitRootObjectTypeIDsContentInClipboard(), repositoryInterface)) {
                        final Tuple<RepositorySnippetClipboardContent, IMessageSet> clipboardContentAndInterpretationMessages = ClipboardManager.retrieveFromClipboard(repositoryInterface.getTypeManager());
                        if (clipboardContentAndInterpretationMessages != null) {
                            final ObjectWrapper exception = new ObjectWrapper(null);
                            projectAgent.doWithSuspendedAsynchronousUpdate(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        CopyManager.paste(targetObjectReference, (RepositorySnippetClipboardContent)clipboardContentAndInterpretationMessages.getT1(), (IMessageSet)clipboardContentAndInterpretationMessages.getT2(), projectAgent, AbstractCHPaste_NonPlatformUI.this.getPasteConfiguration(), window);
                                    }
                                    catch (ImportExportException ieE) {
                                        exception.setWrappedObject((Object)ieE);
                                    }
                                }
                            });
                            if (exception.getWrappedObject() != null) {
                                throw (ImportExportException)((Object)exception.getWrappedObject());
                            }
                        } else {
                            LOGGER.warn("Skipped pasting <null> clipboard content.");
                        }
                        break block10;
                    }
                    throw new ImportExportException(Messages.getString("PasteAction.Error.InvalidTarget"));
                }
                catch (ImportExportException ieE) {
                    LOGGER.warn("Pasting failed", (Throwable)ieE);
                    String message = ieE.getLocalizedMessage() != null && ieE.getLocalizedMessage().trim().length() > 0 ? NLS.bind((String)Messages.getString("PasteAction.Error.PasteFailed.MessageWithDetails"), (Object)ieE.getLocalizedMessage()) : Messages.getString("PasteAction.Error.PasteFailed.MessageWithoutDetails");
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.getString("PasteAction.Error.PasteFailed.Title"), (String)message);
                }
            }
        }
        return null;
    }

    protected abstract IPasteConfiguration getPasteConfiguration();

    protected abstract IRepositoryObjectTypeID getRepositoryObjectTypeIDForCockpitTypeID(String var1);
}

