/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions.test;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ReloadProjectAction
extends Action {
    private static final ILogger logger = Logger.getLogger(ReloadProjectAction.class);
    private final IWorkbenchWindow window;
    private final ISelection selection;

    public ReloadProjectAction(ISelection selection, IWorkbenchWindow window) {
        this.selection = selection;
        this.window = window;
        String serverID = this.getSelectedProjectAgent().getServerID();
        IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
        this.setText(projectMgrServerProxy.getVersionDependendDescription("reload"));
        this.setToolTipText(projectMgrServerProxy.getVersionDependendDescription("reloadtooltip"));
        this.setDescription(projectMgrServerProxy.getVersionDependendDescription("reloaddesc"));
    }

    private IFrameProjectAgent getSelectedProjectAgent() {
        Object o;
        IStructuredSelection sel;
        IFrameProjectAgent projectAgent = null;
        if (this.selection instanceof IStructuredSelection && (sel = (IStructuredSelection)this.selection).size() == 1 && (o = sel.getFirstElement()) instanceof IFrameProjectAgent) {
            projectAgent = (IFrameProjectAgent)o;
        }
        if (projectAgent == null) {
            logger.error("Commit project action called on an unsupported element. Only IFrameProjectAgent is allowed");
            throw new UnsupportedOperationException("Reload project action called on an unsupported element.");
        }
        return projectAgent;
    }

    public void run() {
        try {
            ReloadProjectAction.run(this.getSelectedProjectAgent(), true, EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)this.window));
        }
        catch (Exception e) {
            String serverID = this.getSelectedProjectAgent().getServerID();
            IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            String humanReadableDescriptionOfConsequence = projectMgrServerProxy.getVersionDependendDescription("reloadfailed");
            ModificationProblem mProblem = new ModificationProblem(e, humanReadableDescriptionOfConsequence);
            ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
            mProblems.add(mProblem);
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, this.window.getShell());
            mpDialog.open();
        }
    }

    public static void run(IFrameProjectAgent projectAgent, boolean askUser, IWorkbenchPage currentPage) throws Exception {
        IProjectManagerServerProxy projectManagerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(projectAgent.getServerID());
        projectManagerServerProxy.reloadProject(projectAgent, askUser, currentPage, true);
    }
}

