/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions.test;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class CommitAction
extends Action {
    private static final ILogger logger = Logger.getLogger(CommitAction.class);
    private final IWorkbenchWindow workbenchWindow;
    private final ISelection selection;

    public CommitAction(ISelection selection, IWorkbenchWindow window) {
        this.workbenchWindow = window;
        this.selection = selection;
        String serverID = this.getSelectedProjectAgent().getServerID();
        IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
        this.setText(projectMgrServerProxy.getVersionDependendDescription("commitlabel"));
        this.setToolTipText(projectMgrServerProxy.getVersionDependendDescription("committooltip"));
        this.setDescription(projectMgrServerProxy.getVersionDependendDescription("commitdesc"));
    }

    private IFrameProjectAgent getSelectedProjectAgent() {
        Object o;
        IStructuredSelection sel;
        IFrameProjectAgent projectAgent = null;
        if (this.selection instanceof IStructuredSelection && (sel = (IStructuredSelection)this.selection).size() == 1 && (o = sel.getFirstElement()) instanceof IFrameProjectAgent) {
            projectAgent = (IFrameProjectAgent)o;
        }
        if (projectAgent == null) {
            logger.error("Commit project action called on an unsupported element. Only IFrameProjectAgent is allowed");
            throw new UnsupportedOperationException("Commit project action called on an unsupported element.");
        }
        return projectAgent;
    }

    public void run() {
        Throwable th = null;
        try {
            CommitAction.run(null, false, this.workbenchWindow, this.getSelectedProjectAgent());
        }
        catch (ServerNotAvailableException e) {
            th = e;
        }
        catch (EXServerException e) {
            th = e;
        }
        catch (LoginCanceledException e) {
        }
        catch (UnknownServerException e) {
            th = e;
        }
        catch (ExPrematureEndOfTransfer e) {
            th = e;
        }
        if (th != null) {
            IFrameProjectAgent selectedProjectAgent = this.getSelectedProjectAgent();
            String serverID = selectedProjectAgent.getServerID();
            IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            String descriptionOfConsequence = projectMgrServerProxy.getVersionDependendDescription("commitfailed");
            String genericMessage = Messages.getString("CommitAction.CommitFailed.genericMessage");
            String dialogTitle = projectMgrServerProxy.getVersionDependendDescription("commitlabel");
            this.handleCommitProjectThrowable(th, this.workbenchWindow.getShell(), descriptionOfConsequence, genericMessage, dialogTitle);
        }
    }

    private void handleCommitProjectThrowable(Throwable th, Shell parentShell, String humanReadableDescriptionOfConsequence, String exGenericMessage, String dialogTitle) {
        Exception userShownEx;
        Throwable thToHandle = th instanceof ExPrematureEndOfTransfer && th.getCause() != null ? th.getCause() : th;
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(exGenericMessage);
            userShownEx.initCause(thToHandle);
        }
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, humanReadableDescriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, parentShell);
        mpDialog.open();
    }

    public static void run(String modificationComment, boolean serverProxyIsPrepared, IWorkbenchWindow workbenchWindow, IFrameProjectAgent projectAgent) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        if (projectAgent != null && projectAgent.isOpened()) {
            projectAgent.commitProject(modificationComment, serverProxyIsPrepared, false, workbenchWindow.getShell());
        }
    }
}

