/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.AbstractOpenPlanAction;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenProjectorAction
extends AbstractOpenPlanAction {
    public OpenProjectorAction(ISelectionProvider selectionProvider, IWorkbenchPage page) {
        super(selectionProvider, page, page.getWorkbenchWindow().getShell(), 3);
        this.setText(Messages.getString("OpenProjectorAction.Open_1"));
        this.setDescription(Messages.getString("OpenProjectorAction.Open_with_FMC_Viewer_3"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("open_plan.gif"));
    }

    public boolean update() {
        boolean mayPutIntoProjectionMode = false;
        List<IPlan> plans = this.getSelectedPlans(true);
        if (plans.size() == 1) {
            IPlan plan = plans.get(0);
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
            this.setDescriptionForOpen();
            String errorMsg = projectAgent.getPlanEditorManager().checkPlanAgentAvailability(plan.getPlantypeUID());
            if (errorMsg == null) {
                IExternalPlanEditorControllerExtension ctrl = this.getPlanEditorControllerExtensions(plan);
                if (ctrl == null) {
                    mayPutIntoProjectionMode = true;
                } else if (ctrl.getWorkingMode() == 3) {
                    this.setDescriptionForOpen();
                    mayPutIntoProjectionMode = false;
                } else {
                    this.setDescriptionForStopEdit();
                    mayPutIntoProjectionMode = true;
                }
            } else {
                mayPutIntoProjectionMode = false;
                this.setToolTipText(errorMsg);
            }
        }
        this.setEnabled(mayPutIntoProjectionMode);
        return mayPutIntoProjectionMode;
    }

    private void setDescriptionForOpen() {
        this.setText(Messages.getString("OpenProjectorAction.Open_1"));
        this.setToolTipText(Messages.getString("OpenEditorAction.Open_with_FMC_Viewer_2"));
        this.setDescription(Messages.getString("OpenEditorAction.Open_with_FMC_Viewer_3"));
    }

    private void setDescriptionForStopEdit() {
        this.setText(Messages.getString("SwitchModeAction.Finish_editing_1"));
        this.setToolTipText(Messages.getString("SwitchModeAction.Switches_to_projection_mode_2"));
        this.setDescription(Messages.getString("SwitchModeAction.Switches_to_projection_mode_2"));
    }

    public void run() {
        IExternalPlanEditorControllerExtension ctrl;
        List<IPlan> plans = this.getSelectedPlans(true);
        IPlan plan = null;
        if (plans.size() > 0) {
            plan = plans.get(0);
        }
        if (this.update()) {
            assert (plans.size() == 1);
            IExternalPlanEditorControllerExtension ctrl2 = this.getPlanEditorControllerExtensions(plan);
            if (ctrl2 != null) {
                boolean doSwitchIntoProjectionMode = false;
                boolean doSave = false;
                if (ctrl2.isDirty()) {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("SwitchModeAction.Save_changes_10"), null, Messages.getString("SwitchModeAction.There_are_changes_associated_with_this_plan._nShould_the_plan_be_saved_before_switching_the_mode__11"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int save = dialog.open();
                    doSave = save == 0;
                    doSwitchIntoProjectionMode = save == 0 || save == 1;
                } else {
                    doSwitchIntoProjectionMode = true;
                }
                if (doSwitchIntoProjectionMode &= this.updatePerspective() != 1) {
                    if (doSave) {
                        OpenProjectorAction.saveChanges(ctrl2);
                    }
                    this.launchPlan(plan);
                    this.setEmptySelection(ctrl2);
                }
            } else if (this.updatePerspective() != 1) {
                this.launchPlan(plan);
            }
        } else if (plan != null && (ctrl = this.getPlanEditorControllerExtensions(plan)).getWorkingMode() == 3) {
            this.launchPlan(plan);
        }
    }

    private static void saveChanges(final IExternalPlanEditorControllerExtension ctrl) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ctrl.doSave(monitor);
                }
            });
        }
        catch (InterruptedException e) {
            return;
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Override
    protected String getPreferredPerspectiveID() {
        return "com.arcway.cockpit.frame.mainperspective";
    }

    @Override
    protected String getSwitchPreferenceKey() {
        return "SwitchToMainPerspective";
    }
}

