/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.AbstractOpenPlanAction;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPage;

public class OpenEditorAction
extends AbstractOpenPlanAction {
    public OpenEditorAction(ISelectionProvider selectionProvider, IWorkbenchPage page) {
        super(selectionProvider, page, page.getWorkbenchWindow().getShell(), 1);
        this.setText(Messages.getString("OpenEditorAction.Edit_1"));
        this.setDescription(Messages.getString("OpenEditorAction.Edit_with_FMC_Editor_3"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("editor_plan.gif"));
    }

    public boolean update() {
        boolean mayBePutInEditMode;
        List<IPlan> plans = this.getSelectedPlans(true);
        if (plans.size() == 1) {
            IPlan plan = plans.get(0);
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
            boolean hasLicense = projectAgent.getServerLicenseManager().isLicenseOperationAllowed(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
            if (hasLicense) {
                String errorMsg = projectAgent.getPlanEditorManager().checkPlanAgentAvailability(plan.getPlantypeUID());
                if (errorMsg == null) {
                    mayBePutInEditMode = !projectAgent.getPlanAgentManager().isPlanWriteAccessed(plan);
                    this.setToolTipText(Messages.getString("OpenEditorAction.Edit_with_FMC_Editor_2"));
                } else {
                    mayBePutInEditMode = false;
                    this.setToolTipText(errorMsg);
                }
            } else {
                mayBePutInEditMode = false;
            }
        } else {
            mayBePutInEditMode = false;
        }
        this.setEnabled(mayBePutInEditMode);
        return mayBePutInEditMode;
    }

    public void run() {
        if (this.update()) {
            List<IPlan> plans = this.getSelectedPlans(true);
            assert (plans.size() == 1);
            IPlan plan = plans.get(0);
            if (this.updatePerspective() != 1) {
                IExternalPlanEditorControllerExtension ctrl = this.getPlanEditorControllerExtensions(plan);
                if (ctrl != null && ctrl.getWorkingMode() != 1) {
                    this.setEmptySelection(ctrl);
                }
                this.launchPlan(plan);
            }
        }
    }

    @Override
    protected String getPreferredPerspectiveID() {
        return "com.arcway.cockpit.frame.editperspective";
    }

    @Override
    protected String getSwitchPreferenceKey() {
        return "SwitchToEditPerspective";
    }
}

