/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.CreatePlanElementDialog;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElement;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MakeUniqueAction
extends Action {
    private final List<IPlanElement> selectedPlanElements;
    private final IExternalPlanEditorControllerExtension controller;
    private final Shell parentShell;

    public MakeUniqueAction(IExternalPlanEditorControllerExtension controller, List<IPlanElement> selectedPlanElements, boolean someElementsAreNotUnique, Shell parentShell) {
        assert (selectedPlanElements != null) : "selectedPlanElements can't be null!";
        assert (controller != null);
        assert (parentShell != null);
        this.selectedPlanElements = selectedPlanElements;
        this.controller = controller;
        this.parentShell = parentShell;
        this.setText(Messages.getString("MakeUniqueAction.Make_Unique_2"));
        this.setToolTipText(Messages.getString("MakeUniqueAction.Make_the_selected_Element_Unique_3"));
        this.setDescription(Messages.getString("MakeUniqueAction.Make_the_selected_Element_Unique_4"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("Unique-Element.gif"));
        boolean enabled = false;
        if (selectedPlanElements.size() == 1) {
            IPlanElement obj = selectedPlanElements.get(0);
            if (obj instanceof PlanElement) {
                if (someElementsAreNotUnique) {
                    IPlanElement selectedElement = selectedPlanElements.get(0);
                    String planElementType = selectedElement.getPlanElementTypeID();
                    IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElementType);
                    enabled = !typeDescription.isOfCategoryNeverUnique();
                } else {
                    enabled = false;
                }
            } else {
                enabled = false;
            }
        } else {
            enabled = false;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (!this.selectedPlanElements.isEmpty()) {
            IPlanAgentUniqueElementManager uniqueElementMgr = this.controller.getProjectAgent().getPlanAgentUniqueElementManager();
            IPlanElement planElement = this.selectedPlanElements.get(0);
            String planElementType = planElement.getPlanElementTypeID();
            IConstructionElementTypeDescription constructionElementType = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElementType);
            String constructionElementTypeID = constructionElementType.getConstructionElementTypeID();
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.controller.getProjectAgent().getProjectUID());
            CreatePlanElementDialog createDialog = new CreatePlanElementDialog(this.parentShell, null, uniqueElementMgr.getUniqueElements(constructionElementTypeID), constructionElementType, planElement.getPlanElementName(), projectAgent, 2);
            int button = createDialog.open();
            if (button != 1) {
                IUniqueElement existingUniqueElement;
                String uniqueElementName = createDialog.getElementName();
                ObjectTypeCategoryID categoryID = null;
                if (createDialog.getObjectTypeCategory() != null) {
                    categoryID = createDialog.getObjectTypeCategory().getObjectTypeCategoryID();
                }
                if ((existingUniqueElement = uniqueElementMgr.getUniqueElement(uniqueElementName, constructionElementTypeID)) == null) {
                    try {
                        uniqueElementMgr.requestUniqueElementCreationPermission(uniqueElementName, constructionElementTypeID);
                        uniqueElementMgr.createUniqueElement(uniqueElementName, constructionElementTypeID, categoryID);
                        existingUniqueElement = uniqueElementMgr.getUniqueElement(uniqueElementName, constructionElementTypeID);
                    }
                    catch (EXModificationProblem e) {
                        ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(e.getModificationProblems(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        problemsDialog.open();
                    }
                }
                if (existingUniqueElement != null) {
                    this.controller.makeUnique(planElement, existingUniqueElement);
                }
            }
        }
    }
}

