/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class MakeLocalAction
extends Action {
    private final List<IPlanElement> selectedPlanElements;
    private final IExternalPlanEditorControllerExtension controller;

    public MakeLocalAction(IExternalPlanEditorControllerExtension ctrl, List<IPlanElement> selectedPlanElements, List<IUniqueElement> selectedUniqueElements) {
        assert (selectedPlanElements != null) : "selectedPlanElements can't be null!";
        assert (selectedUniqueElements != null) : "selectedUniqueElements can't be null!";
        assert (ctrl != null);
        this.selectedPlanElements = selectedPlanElements;
        this.controller = ctrl;
        this.setText(Messages.getString("MakeLocalAction.Make_Local_3"));
        this.setToolTipText(Messages.getString("MakeLocalAction.Make_the_selected_element_local_4"));
        this.setDescription(Messages.getString("MakeLocalAction.Make_the_selected_element_local_5"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("Local-Element.gif"));
        if (selectedUniqueElements.size() > 0) {
            boolean enabled = false;
            int i = 0;
            while (i < selectedUniqueElements.size()) {
                IPlanElement selectedElement = selectedPlanElements.get(i);
                String planElementType = selectedElement.getPlanElementTypeID();
                IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElementType);
                if (!typeDescription.isOfCategoryAlwaysUnique()) {
                    enabled = true;
                }
                ++i;
            }
            this.setEnabled(enabled);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        ArrayList<IUniqueElementOccurrence> occurrences = new ArrayList<IUniqueElementOccurrence>();
        IPlanAgentUniqueElementManager uniqueElementMgr = this.controller.getProjectAgent().getPlanAgentUniqueElementManager();
        for (IPlanElement planElement : this.selectedPlanElements) {
            IUniqueElementOccurrence occurrence = uniqueElementMgr.getUniqueElementOccurence(planElement);
            if (occurrence == null) continue;
            occurrences.add(occurrence);
        }
        IUniqueElementOccurrence[] os = new IUniqueElementOccurrence[occurrences.size()];
        int i = 0;
        while (i < occurrences.size()) {
            os[i] = (IUniqueElementOccurrence)occurrences.get(i);
            ++i;
        }
        this.controller.makeLocal(os);
    }
}

