/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.shared.message.EOServer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class DeleteServerAction
extends Action {
    private final ISelectionProvider selectionProvider;

    public DeleteServerAction(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.setText(Messages.getString("DeleteServerAction.Delete_Server_1"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("server_delete.gif"));
    }

    public void run() {
        EOServer server = this.getSelectedServer();
        if (server != null) {
            String msg = NLS.bind((String)Messages.getString("DeleteServerAction.Do_you_really_want_to_delete_the_server__3"), (Object)server.getServerName());
            msg = String.valueOf(msg) + Messages.getString("DeleteServerAction._nNote__The_local_configuration_and_cached_data_of_the_projects_of_this_server_will_be_deleted_too._5");
            MessageDialog removeProjectDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("DeleteServerAction.Delete_Server_6"), null, msg, 3, new String[]{Messages.getString("DeleteServerAction.Delete_7"), Messages.getString("DeleteServerAction.Cancel_8")}, 1);
            int success = removeProjectDialog.open();
            if (success == 0) {
                ProjectMgr.getProjectMgr().getGeneralServerProxy().deleteServer(server);
            }
        }
    }

    private EOServer getSelectedServer() {
        IStructuredSelection sel = (IStructuredSelection)this.selectionProvider.getSelection();
        if (sel.size() != 1) {
            return null;
        }
        if (sel.getFirstElement() instanceof ServerConnection) {
            ServerConnection sc = (ServerConnection)sel.getFirstElement();
            return sc.getServerData();
        }
        return null;
    }
}

