/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ProjectParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Arrays;

public class OpenProjectAction
implements ICockpitConsoleAction {
    private static final String COMMAND_NAME = "open";
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(ServerParameterSpecification.getSingleton(), ProjectParameterSpecification.getSingleton()));

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    @Override
    public void execute(ConsoleActionParameterBindings parameters, IParameterLog parameterLog, ScriptCommandContext uiContext) throws ScriptExecutionException {
        String serverName = parameters.getValue(ServerParameterSpecification.getSingleton());
        String projectName = parameters.getValue(ProjectParameterSpecification.getSingleton());
        if (serverName != null && projectName != null) {
            parameterLog.logParameters(String.valueOf(serverName) + " / " + projectName);
            IFrameProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(serverName, projectName);
            if (projectAgent == null) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Project is not configured in this workspace.");
            }
            if (projectAgent.isOpened()) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Project is already open.");
            }
            try {
                boolean triggerUserOnOpenActions = false;
                projectAgent.open(false, triggerUserOnOpenActions, EclipseSWTHelper.getWorkbenchPage(null));
            }
            catch (LoginCanceledException e) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Cause: " + e.getLocalizedMessage(), e);
            }
            catch (ServerNotAvailableException e) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Cause: " + e.getLocalizedMessage(), e);
            }
            catch (UnknownServerException e) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Cause: " + e.getLocalizedMessage(), e);
            }
            catch (EXServerException e) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Cause: " + e.getLocalizedMessage(), e);
            }
            catch (ExProjectOpenAbortWithMessage e) {
                throw new ScriptExecutionException("Could not open project " + projectName + ". Cause: " + e.getLocalizedMessage(), e);
            }
        } else {
            throw new ScriptExecutionException("Could not open project " + projectName + ". None of the configured servers was labeled with the name: " + serverName);
        }
    }
}

