/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.FileParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class DumpServerAction
implements ICockpitConsoleAction {
    private static final String COMMAND_NAME = "dumpServer";
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(ServerParameterSpecification.getSingleton(), FileParameterSpecification.getSingleton()));

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    @Override
    public void execute(ConsoleActionParameterBindings parameters, IParameterLog parameterLog, ScriptCommandContext uiContext) throws ScriptExecutionException {
        String serverName = parameters.getValue(ServerParameterSpecification.getSingleton());
        String fileName = parameters.getValue(FileParameterSpecification.getSingleton());
        ServerConnection sc = ProjectMgr.getProjectMgr().getServerConnection(serverName);
        if (sc != null) {
            IProjectManagerServerProxy proxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(sc.getServerID());
            parameterLog.logParameters(String.valueOf(serverName) + " to " + fileName);
            File dumpFile = new File(fileName);
            try {
                Set projectUIDBlackList = Collections.emptySet();
                proxy.dumpServer(dumpFile, projectUIDBlackList, null);
            }
            catch (ServerNotAvailableException e) {
                throw new ScriptExecutionException(e);
            }
            catch (LoginCanceledException e) {
                throw new ScriptExecutionException(e);
            }
            catch (EXServerException e) {
                throw new ScriptExecutionException(e);
            }
            catch (UnknownServerException e) {
                throw new ScriptExecutionException(e);
            }
        } else {
            throw new ScriptExecutionException("server " + serverName + " not found");
        }
    }
}

