/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.List;

public class ScriptAuthenticator {
    private static final ILogger logger = Logger.getLogger(ScriptAuthenticator.class);
    private static ScriptAuthenticatorImpl scriptAuthenticator;

    public static synchronized void installAsSystemAuthenticator() {
        assert (scriptAuthenticator == null);
        scriptAuthenticator = new ScriptAuthenticatorImpl();
        Authenticator.setDefault(scriptAuthenticator);
    }

    public static synchronized void memorizePasswordAuthentication(PasswordAuthentication passwordAuthentication) {
        if (scriptAuthenticator != null) {
            scriptAuthenticator.memorizePasswordAuthentication(passwordAuthentication);
        }
    }

    private static class ScriptAuthenticatorImpl
    extends Authenticator {
        private PasswordAuthentication passwordAuthentication = null;
        private List<Object> lastRequestorInfo = null;

        private ScriptAuthenticatorImpl() {
        }

        public void memorizePasswordAuthentication(PasswordAuthentication p_passwordAuthentication) {
            this.passwordAuthentication = p_passwordAuthentication;
        }

        @Override
        protected synchronized PasswordAuthentication getPasswordAuthentication() {
            List<Object> requestorInfo = Arrays.asList(new Object[]{this.getRequestingHost(), this.getRequestingPort(), this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingScheme(), this.getRequestingSite(), this.getRequestorType()});
            PasswordAuthentication authentication = this.passwordAuthentication;
            if (requestorInfo.equals(this.lastRequestorInfo)) {
                logger.info("A second request for PasswordAuthentication data for URL: " + this.getRequestingURL() + ", RequestorType: " + this.getRequestorType().toString() + " was not answered with the presumably wrong PasswordAuthentication data returned in the course of the previous PasswordAuthentication data request for the same URL.");
                return null;
            }
            if (authentication == null) {
                logger.info("PasswordAuthentication data have been requested for URL: " + this.getRequestingURL() + ", RequestorType: " + this.getRequestorType().toString() + " but no such data was deposited at the ScriptAuthenticator that could be used to answer this request. Returning no PasswordAuthentication data.");
                return null;
            }
            this.lastRequestorInfo = requestorInfo;
            return authentication;
        }
    }
}

