/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui;

import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import java.util.List;

public class ParameterizedAction
implements IParameterLog {
    private final ICockpitConsoleAction action;
    private final ConsoleActionParameterBindings parameterBindings;
    private String executionNotice = null;
    private String errorMessage = null;
    private final List<String> errorEntries;

    public ParameterizedAction(ICockpitConsoleAction action, ConsoleActionParameterBindings parameterBindings, List<String> errorEntries) {
        this.action = action;
        this.parameterBindings = parameterBindings;
        this.errorEntries = errorEntries;
    }

    public ICockpitConsoleAction getAction() {
        return this.action;
    }

    public ConsoleActionParameterBindings getParameterBindings() {
        return this.parameterBindings;
    }

    public void execute(ScriptCommandContext uiContext) throws ScriptExecutionException {
        this.action.execute(this.parameterBindings, this, uiContext);
    }

    @Override
    public void logParameters(String parameters) {
        this.executionNotice = parameters;
    }

    @Override
    public void logErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getExecutionNotice() {
        return this.executionNotice;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public List<String> getErrorEntries() {
        return this.errorEntries;
    }
}

