/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui;

import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionsManager;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.ParameterizedAction;
import com.arcway.cockpit.frame.client.global.consoleui.VarargsParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.exceptions.ExDuplicateConsoleParameter;
import com.arcway.cockpit.frame.client.global.consoleui.exceptions.ExInvalidCommand;
import com.arcway.cockpit.frame.client.global.consoleui.exceptions.ExInvalidConsoleParameter;
import com.arcway.cockpit.frame.client.global.consoleui.exceptions.ExInvalidFileFormat;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsoleFromFileReader {
    public static final String VARARGS_KEY_NAME = "name";
    public static final String VARARGS_KEY_ATTRIBUTES = "attributes";
    public static final String VARARGS_KEY_CHILDREN = "children";
    private final ConsoleActionsManager actionsManager = new ConsoleActionsManager();
    private final File file;

    public ConsoleFromFileReader(File file) {
        this.file = file;
    }

    public List<ParameterizedAction> parseScriptFile(List<String> errorEntries) throws FileNotFoundException, ExInvalidFileFormat, ExInvalidCommand, ExInvalidConsoleParameter, ExDuplicateConsoleParameter {
        EOGenericMessage rootElement;
        FileInputStream fis = new FileInputStream(this.file);
        XMLDecoder xmlDecoder = new XMLDecoder();
        try {
            rootElement = xmlDecoder.decodeXML((InputStream)fis, false);
        }
        catch (EXDecoderException e) {
            throw new ExInvalidFileFormat((Exception)((Object)e));
        }
        ArrayList<ParameterizedAction> commandList = new ArrayList<ParameterizedAction>();
        for (EncodableObjectBase encodableObjectBase : rootElement.getChilds()) {
            EOGenericMessage childElement = (EOGenericMessage)encodableObjectBase;
            String commandName = childElement.getTag().trim();
            ICockpitConsoleAction action = this.actionsManager.getActionSingleton(commandName);
            if (action != null) {
                ConsoleActionParameterBindings parameterBindings = ConsoleFromFileReader.getParameterBindings(action, childElement);
                commandList.add(new ParameterizedAction(action, parameterBindings, errorEntries));
                continue;
            }
            throw new ExInvalidCommand(commandName);
        }
        return commandList;
    }

    private static ConsoleActionParameterBindings getParameterBindings(ICockpitConsoleAction action, EOGenericMessage element) throws ExInvalidConsoleParameter, ExDuplicateConsoleParameter {
        ConsoleActionParameterBindings parameterBindings = new ConsoleActionParameterBindings(action);
        Map attributes = element.getAttributes();
        for (Map.Entry attribute : attributes.entrySet()) {
            String parameterName = (String)attribute.getKey();
            String parameterValue = (String)attribute.getValue();
            parameterBindings.addParameterBinding(parameterName, parameterValue);
        }
        if (action.getParametersSpecifications().get(VarargsParameterSpecification.getSingleton().getParameterName()) == VarargsParameterSpecification.getSingleton()) {
            parameterBindings.addParameterBinding(VarargsParameterSpecification.getSingleton(), ConsoleFromFileReader.convertVarargs(element));
        }
        return parameterBindings;
    }

    private static Map<String, Object> convertVarargs(EOGenericMessage element) {
        HashMap attributes = new HashMap(element.getAttributes());
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        List childs = element.getChilds();
        for (EncodableObjectBase child : childs) {
            children.add(ConsoleFromFileReader.convertVarargs((EOGenericMessage)child));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(VARARGS_KEY_NAME, element.getTag());
        result.put(VARARGS_KEY_ATTRIBUTES, attributes);
        result.put(VARARGS_KEY_CHILDREN, children);
        return result;
    }
}

