/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui;

import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterBinding;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.exceptions.ExDuplicateConsoleParameter;
import com.arcway.cockpit.frame.client.global.consoleui.exceptions.ExInvalidConsoleParameter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConsoleActionParameterBindings
implements Iterable<ICockpitConsoleActionParameterBinding> {
    private final HashMap<String, Object> bindings;
    private final ICockpitConsoleAction action;

    public ConsoleActionParameterBindings(ICockpitConsoleAction action) {
        this.bindings = new HashMap(action.getParametersSpecifications().size() * 2);
        this.action = action;
    }

    public <PVT2> void addParameterBinding(ICockpitConsoleActionParameterSpecification<PVT2> parameterSpecification, PVT2 value) throws ExDuplicateConsoleParameter, ExInvalidConsoleParameter {
        this.addParameterBinding(parameterSpecification.getParameterName(), value);
    }

    public void addParameterBinding(String parameterName, Object value) throws ExDuplicateConsoleParameter, ExInvalidConsoleParameter {
        ICockpitConsoleActionParameterSpecification parameterSpecification = this.action.getParametersSpecifications().get(parameterName);
        if (parameterSpecification != null) {
            Object previousValue = this.bindings.put(parameterSpecification.getParameterName(), value);
            if (previousValue != null) {
                throw new ExDuplicateConsoleParameter(this.action, parameterName);
            }
        } else {
            throw new ExInvalidConsoleParameter(this.action, parameterName);
        }
    }

    public boolean isParameterBound(ICockpitConsoleActionParameterSpecification<?> parameterSpecification) {
        return this.bindings.containsKey(parameterSpecification.getParameterName());
    }

    public <PVT> PVT getValue(ICockpitConsoleActionParameterSpecification<PVT> parameterSpecification) {
        String parameterName = parameterSpecification.getParameterName();
        if (this.bindings.containsKey(parameterName)) {
            return (PVT)this.bindings.get(parameterName);
        }
        return parameterSpecification.getDefaultValue();
    }

    @Override
    public Iterator<ICockpitConsoleActionParameterBinding> iterator() {
        final Iterator<Map.Entry<String, Object>> bindingsEntriesIterator = this.bindings.entrySet().iterator();
        return new Iterator<ICockpitConsoleActionParameterBinding>(){

            @Override
            public boolean hasNext() {
                return bindingsEntriesIterator.hasNext();
            }

            @Override
            public ICockpitConsoleActionParameterBinding next() {
                final Map.Entry bindingsEntry = (Map.Entry)bindingsEntriesIterator.next();
                return new ICockpitConsoleActionParameterBinding(){

                    @Override
                    public ICockpitConsoleActionParameterSpecification<?> getSpecification() {
                        return ConsoleActionParameterBindings.this.action.getParametersSpecifications().get((String)bindingsEntry.getKey());
                    }

                    @Override
                    public Object getValue() {
                        return bindingsEntry.getValue();
                    }

                    @Override
                    public <PVT> PVT getValue(ICockpitConsoleActionParameterSpecification<PVT> parameterSpecification) {
                        if (!$assertionsDisabled && this.getSpecification() != parameterSpecification) {
                            throw new AssertionError();
                        }
                        return (PVT)bindingsEntry.getValue();
                    }
                };
            }

            @Override
            public void remove() {
                bindingsEntriesIterator.remove();
            }
        };
    }
}

