/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionTemplateProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;

public class ServerPermissionChecker {
    private static final ILogger logger = Logger.getLogger(ServerPermissionChecker.class);

    public static boolean mayCreateProjects(String serverID, boolean forceLogin) {
        boolean isAdmin = false;
        Collection<EOPermission> permissions = null;
        try {
            permissions = ServerPermissionChecker.getPermissions(serverID, forceLogin);
            isAdmin = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID).isAdminUser(forceLogin);
        }
        catch (ServerNotAvailableException e) {
            logger.debug("MayCreateProjects Permission check aborted.", (Throwable)e);
        }
        catch (EXServerException e) {
            logger.debug("MayCreateProjects Permission check aborted.", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.debug("MayCreateProjects Permission check aborted.", (Throwable)e);
        }
        return isAdmin || permissions != null && ServerPermissionTemplateProvider.hasCreateProjectPermission(permissions);
    }

    private static Collection<EOPermission> getPermissions(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        Collection ups;
        ArrayList<EOPermission> list = new ArrayList<EOPermission>();
        IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
        EOUserAndGroupAndPermissions user = serverProxy.getUserData(forceLogin);
        if (user != null && (ups = user.getAllPermissions()) != null) {
            list.addAll(user.getAllPermissions());
        }
        return list;
    }
}

