/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class Icons {
    private static final String FILE_NAME_BIG_ARCWAY_LOGO = "ArcWayLogo_236x236.png";
    private static Image arcWayLogo;
    private static Image section;
    private static Image plan;
    private static Image treeT;
    private static Image treeH;
    private static Image calendar;
    private static Image delete;
    private static Image userDefinedAttributeTypeImage;
    private static Image editUserDefinedAttributeTypeImage;
    private static Image openProjectImage;
    private static Image closedProjectImage;
    private static Image openOfflineProjectImage;
    private static Image closeOfflineProjectImage;
    private static Image connectedServer;
    private static Image disconnectedServer;
    private static Image reportTemplate;
    private static Image reportTemplates;
    private static Image reportOutputtemplate;
    private static Image refinementDecorator;
    private static Image refinement;
    private static Image unknown;
    private static Image filter;
    private static Image link;
    private static Image sequence;
    public static final String PROJECT_MODE_OPEN = "open";
    public static final String PROJECT_MODE_CLOSE = "close";
    public static final String PROJECT_MODE_OPEN_OFFLINE = "openoffline";
    public static final String PROJECT_MODE_CLOSE_OFFLINE = "closeoffline";
    private static final Map<String, Image> fileImages;
    private static Image imageForStakeholder;
    private static Image imageForStakeholderRole;
    private static Image uniqueElementImage;

    static {
        fileImages = new HashMap<String, Image>();
    }

    public static Image getCalendarImage() {
        if (calendar == null || calendar.isDisposed()) {
            calendar = FramePlugin.getImageDescriptor("calendar.gif").createImage();
        }
        return calendar;
    }

    public static Image getFileImage(String fileName) {
        String extension = de.plans.lib.util.FileHelper.getFileType((String)fileName);
        Image image = fileImages.get(extension);
        if (image == null || image.isDisposed()) {
            image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName).createImage();
            fileImages.put(extension, image);
        }
        return image;
    }

    public static Image getImageForFilter() {
        if (filter == null || filter.isDisposed()) {
            filter = FramePlugin.getImageDescriptor("filter_ps.gif").createImage();
        }
        return filter;
    }

    public static Image getImageForLink() {
        if (link == null || link.isDisposed()) {
            link = FramePlugin.getImageDescriptor("Link.gif").createImage();
        }
        return link;
    }

    public static Image getImageForSequence() {
        if (sequence == null || sequence.isDisposed()) {
            sequence = FramePlugin.getImageDescriptor("naturalorder.gif").createImage();
        }
        return sequence;
    }

    public static ImageDescriptor getImageDescriptorForFilter() {
        return FramePlugin.getImageDescriptor("filter_ps.gif");
    }

    public static Image getUnknownImage() {
        if (unknown == null || unknown.isDisposed()) {
            unknown = FramePlugin.getImageDescriptor("unknown.gif").createImage();
        }
        return unknown;
    }

    public static ImageDescriptor getImageDescriptorForDelete() {
        return FramePlugin.getImageDescriptor("Delete.gif");
    }

    public static Image getImageForDelete() {
        if (delete == null || delete.isDisposed()) {
            delete = Icons.getImageDescriptorForDelete().createImage();
        }
        return delete;
    }

    public static Image getImageForReportTemplate() {
        if (reportTemplate == null || reportTemplate.isDisposed()) {
            reportTemplate = FramePlugin.getImageDescriptor("reporttemplate.gif").createImage();
        }
        return reportTemplate;
    }

    public static Image getImageForReportTemplates() {
        if (reportTemplates == null || reportTemplates.isDisposed()) {
            reportTemplates = FramePlugin.getImageDescriptor("reporttemplates.gif").createImage();
        }
        return reportTemplates;
    }

    public static ImageDescriptor getImageDescriptorForSection() {
        return FramePlugin.getImageDescriptor("Section.gif");
    }

    public static Image getImageForSection() {
        if (section == null || section.isDisposed()) {
            section = Icons.getImageDescriptorForSection().createImage();
        }
        return section;
    }

    public static Image getImageForFileFolder() {
        return Icons.getImageForSection();
    }

    public static Image getImageForReportTemplateFolder() {
        return Icons.getImageForSection();
    }

    public static Image getImageForPlan() {
        if (plan == null || plan.isDisposed()) {
            plan = Icons.getImageDescriptorForPlan().createImage();
        }
        return plan;
    }

    public static Image getImageForObjectsWithChildren() {
        if (treeT == null || treeT.isDisposed()) {
            treeT = Icons.getImageDescriptorForObjectsWithChildren().createImage();
        }
        return treeT;
    }

    public static Image getImageForObjectsWithoutChildren() {
        if (treeH == null || treeH.isDisposed()) {
            treeH = Icons.getImageDescriptorForObjectsWithoutChildren().createImage();
        }
        return treeH;
    }

    public static ImageDescriptor getImageDescriptorForPlanType(String planTypeID) {
        List planTypes = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptions();
        for (PlanTypeDescription planTypeDescription : planTypes) {
            if (!planTypeDescription.getPlanTypeID().equals(planTypeID)) continue;
            return ImageDescriptor.createFromURL((URL)planTypeDescription.getIconURL());
        }
        return Icons.getUnknownImageDescriptor();
    }

    public static ImageDescriptor getLargeImageDescriptorForPlanType(String planTypeID) {
        List planTypes = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptions();
        for (PlanTypeDescription planTypeDescription : planTypes) {
            if (!planTypeDescription.getPlanTypeID().equals(planTypeID)) continue;
            return ImageDescriptor.createFromURL((URL)planTypeDescription.getIconLargeURL());
        }
        return Icons.getUnknownImageDescriptor();
    }

    public static ImageDescriptor getUnknownImageDescriptor() {
        return FramePlugin.getImageDescriptor("unknown.gif");
    }

    public static ImageDescriptor getDefaultFileImageDescriptor() {
        return FramePlugin.getImageDescriptor("else.png");
    }

    public static ImageDescriptor getImageDescriptorForObjectsWithoutChildren() {
        return FramePlugin.getImageDescriptor("tree_-.gif");
    }

    public static ImageDescriptor getImageDescriptorForObjectsWithChildren() {
        return FramePlugin.getImageDescriptor("tree_t.gif");
    }

    public static ImageDescriptor getImageDescriptorForPlan() {
        return FramePlugin.getImageDescriptor("editor_plan.gif");
    }

    public static ImageDescriptor getImageDescriptorForProject(String projectMode) {
        if (projectMode.equals(PROJECT_MODE_OPEN)) {
            return FramePlugin.getImageDescriptor("prj_obj.gif");
        }
        if (projectMode.equals(PROJECT_MODE_CLOSE)) {
            return FramePlugin.getImageDescriptor("cprj_obj.gif");
        }
        if (projectMode.equals(PROJECT_MODE_OPEN_OFFLINE)) {
            return FramePlugin.getImageDescriptor("offprj_obj.gif");
        }
        if (projectMode.equals(PROJECT_MODE_CLOSE_OFFLINE)) {
            return FramePlugin.getImageDescriptor("coffprj_obj.gif");
        }
        throw new RuntimeException();
    }

    public static Image getImageForOpenProject() {
        if (openProjectImage == null || openProjectImage.isDisposed()) {
            openProjectImage = Icons.getImageDescriptorForProject(PROJECT_MODE_OPEN).createImage();
        }
        return openProjectImage;
    }

    public static Image getImageForClosedProject() {
        if (closedProjectImage == null || closedProjectImage.isDisposed()) {
            closedProjectImage = Icons.getImageDescriptorForProject(PROJECT_MODE_CLOSE).createImage();
        }
        return closedProjectImage;
    }

    public static Image getImageForOpenOfflineProject() {
        if (openOfflineProjectImage == null || openOfflineProjectImage.isDisposed()) {
            openOfflineProjectImage = Icons.getImageDescriptorForProject(PROJECT_MODE_OPEN_OFFLINE).createImage();
        }
        return openOfflineProjectImage;
    }

    public static Image getImageForCloseOfflineProject() {
        if (closeOfflineProjectImage == null || closeOfflineProjectImage.isDisposed()) {
            closeOfflineProjectImage = Icons.getImageDescriptorForProject(PROJECT_MODE_CLOSE_OFFLINE).createImage();
        }
        return closeOfflineProjectImage;
    }

    public static Image getArcWayLogo() {
        if (arcWayLogo == null || arcWayLogo.isDisposed()) {
            arcWayLogo = FramePlugin.getImageDescriptor("ArcWayLogo_16x16.gif").createImage();
        }
        return arcWayLogo;
    }

    public static Image getImageForReportOutputtemplate() {
        if (reportOutputtemplate == null || reportOutputtemplate.isDisposed()) {
            reportOutputtemplate = FramePlugin.getImageDescriptor("docgeneration.gif").createImage();
        }
        return reportOutputtemplate;
    }

    public static ImageDescriptor getImageDescriptorForBigArcWayLogo() {
        return FramePlugin.getImageDescriptor(FILE_NAME_BIG_ARCWAY_LOGO);
    }

    public static IStreamResource getImageFileResourceForBigArcwayLogo() {
        IStreamResource imageFileResource = new IStreamResource(){

            public String getName() {
                return Icons.FILE_NAME_BIG_ARCWAY_LOGO;
            }

            public InputStream toInputStream() throws JvmExternalResourceInteractionException {
                URL url = FramePlugin.getIconURL(Icons.FILE_NAME_BIG_ARCWAY_LOGO);
                return FileHelper.urlToInputStream((URL)url);
            }
        };
        return imageFileResource;
    }

    public static ImageDescriptor getImageDescriptorForSmallExportLogo() {
        return FramePlugin.getImageDescriptor("export_wiz.gif");
    }

    public static ImageDescriptor getImageDescriptorForBigExportLogo() {
        return FramePlugin.getImageDescriptor("export_wiz_big.gif");
    }

    public static ImageDescriptor getImageDescriptorForBigImportLogo() {
        return FramePlugin.getImageDescriptor("import_wiz_big.gif");
    }

    public static ImageDescriptor getImageDescriptorForNavBackButton() {
        return FramePlugin.getImageDescriptor("e_back.gif");
    }

    public static ImageDescriptor getImageDescriptorForNavForwardButton() {
        return FramePlugin.getImageDescriptor("e_forward.gif");
    }

    public static ImageDescriptor getImageDescriptorForStakeholder() {
        return FramePlugin.getImageDescriptor("stakeholder.gif");
    }

    public static Image getImageForStakeholder() {
        if (imageForStakeholder == null || imageForStakeholder.isDisposed()) {
            imageForStakeholder = Icons.getImageDescriptorForStakeholder().createImage();
        }
        return imageForStakeholder;
    }

    public static ImageDescriptor getImageDescriptorForStakeholderRole() {
        return FramePlugin.getImageDescriptor("stakeholder_role.gif");
    }

    public static Image getImageForStakeholderRole() {
        if (imageForStakeholderRole == null || imageForStakeholderRole.isDisposed()) {
            imageForStakeholderRole = Icons.getImageDescriptorForStakeholderRole().createImage();
        }
        return imageForStakeholderRole;
    }

    public static ImageDescriptor getImageDescriptorForServerUser() {
        return FramePlugin.getImageDescriptor("user_neu.gif");
    }

    public static ImageDescriptor getImageDescriptorRefinementDecorator() {
        return FramePlugin.getImageDescriptor("refinementdecorator.png");
    }

    public static ImageDescriptor getImageDescriptorRefinement() {
        return FramePlugin.getImageDescriptor("refinement.png");
    }

    public static Image getImageForRefinementDecorator() {
        if (refinementDecorator == null || refinementDecorator.isDisposed()) {
            refinementDecorator = Icons.getImageDescriptorRefinementDecorator().createImage();
        }
        return refinementDecorator;
    }

    public static Image getImageForRefinement() {
        if (refinement == null || refinement.isDisposed()) {
            refinement = Icons.getImageDescriptorRefinement().createImage();
        }
        return refinement;
    }

    public static Image getImageForUserDefinedAttributeTypes() {
        if (userDefinedAttributeTypeImage == null || userDefinedAttributeTypeImage.isDisposed()) {
            userDefinedAttributeTypeImage = FramePlugin.getImageDescriptor("custom_properties.gif").createImage();
        }
        return userDefinedAttributeTypeImage;
    }

    public static Image getImageForEditUserDefinedAttributeTypes() {
        if (editUserDefinedAttributeTypeImage == null || editUserDefinedAttributeTypeImage.isDisposed()) {
            editUserDefinedAttributeTypeImage = FramePlugin.getImageDescriptor("edit_custom_properties.gif").createImage();
        }
        return editUserDefinedAttributeTypeImage;
    }

    public static Image getUniqueElementImage() {
        if (uniqueElementImage == null || uniqueElementImage.isDisposed()) {
            uniqueElementImage = FramePlugin.getImageDescriptor("Unique-Element.gif").createImage();
        }
        return uniqueElementImage;
    }

    public static Image getImageForServer(boolean isConnected) {
        if (isConnected) {
            if (connectedServer == null || connectedServer.isDisposed()) {
                connectedServer = FramePlugin.getImageDescriptor("server_connected.gif").createImage();
            }
            return connectedServer;
        }
        if (disconnectedServer == null || disconnectedServer.isDisposed()) {
            disconnectedServer = FramePlugin.getImageDescriptor("server_disconnected.gif").createImage();
        }
        return disconnectedServer;
    }

    public static ImageDescriptor getImageDescriptorForProblemInfo() {
        return FramePlugin.getImageDescriptor("probleminfo.gif");
    }

    public static ImageDescriptor getImageDescriptorForCycleDecorator() {
        return FramePlugin.getImageDescriptor("decorator_ueCycle.gif");
    }
}

