/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global;

import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.ProjectAssociationManager;
import com.arcway.lib.extensioning.IPlugin;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class FramePlugin
extends AbstractUIPlugin
implements IPlugin {
    private static final ILogger logger = Logger.getLogger(FramePlugin.class);
    private static FramePlugin plugin;
    public static final String FRAME_PLUGIN_ID = "com.arcway.cockpit.frame.client";
    public static final int MAX_UNIQUE_STRING_LENGTH = 250;
    public static final int LOG_CATEGORY_GROUP_FRAME_COMMIT_CLIENT = 20;
    public static final int LOG_CATEGORY_FRAME_COMMIT_CLIENT_GENERAL = 20;
    public static final int LOG_CATEGORY_FRAME_COMMIT_STATE_FLAGS = 21;
    public static final int LOG_CATEGORY_FRAME_COMMIT_LOCKS = 22;
    public static final int LOG_CATEGORY_GROUP_FRAME_UI = 24;
    public static final String MODULE_EXTENSION_POINT_ID = "modules";
    public static final String GENERAL_MODULE_FACADE_EXTENSION_POINT_ID = "generalmodulefacade";
    public static final String VIEWS_EXTENSION_POINT_ID = "views";
    public static final String PERSPECTIVES_EXTENSION_POINT_ID = "perspectives";
    public static final String IMPORT_WIZARDS_EXTENSION_POINT_ID = "importwizards";
    public static final String EXPORT_WIZARDS_EXTENSION_POINT_ID = "exportwizards";
    public static final String SYNCHRONIZE_WIZARDS_EXTENSION_POINT_ID = "synchronizewizards";
    @Deprecated
    public static final String PROJECT_PERMISSIONS_ADMIN_EXTENSION_POINT_ID = "projectpermissionsadmin";
    public static final String PROPERTY_PROVIDER_EXTENSION_POINT_ID = "propertyprovider";
    public static final String PROPERTIES_SUPPORT_EXTENSION_POINT_ID = "propertiessupports";
    public static final String LINK_VIEW_EXTENSION_POINT_ID = "linkviewextension";
    public static final String PROJECTION_EXTENSION_POINT_ID = "projectionPreferencePages";
    public static final String CONTEXT_MENU_EXTENSION_POINT_ID = "contextmenuactionproviders";
    public static final String LINK_FACADE_EXTENSION_POINT_ID = "linktypes";
    public static final String LO_PROVIDERS_EXTENSION_POINT_ID = "linkableobjectproviders";
    public static final String PROJECT_VIEW_CONTEXT_MENU_EXTENSION_POINT_ID = "ProjectViewContextMenu";
    public static final String DETAIL_PROVIDERS_EXTENSION_POINT_ID = "detailproviders";
    public static final String ANALYSE_VIEW_PROVIDERS_EXTENSION_POINT_ID = "analyseviewproviders";
    public static final String PREF_SWITCH_PERSPECTIVE_ON_EDIT = "SwitchToEditPerspective";
    public static final String PREF_SWITCH_PERSPECTIVE_ON_PROJECT = "SwitchToMainPerspective";
    public static final String PREF_ASK_ON_EXIT = "Behaviour.AskOnExit";
    public static final String PREF_LICENSE_EXPIRATION_WARNING_DURATION = "License.WarningBeforeExpiration";
    public static final String PREF_DETAILS_VIEW_TITLE_FONT_SIZE = "DetailsView.TitleFontSize";
    public static final String PREF_DETAILS_VIEW_LABEL_VALUE_FONT_SIZE = "DetailsView.LabelValueFontSize";
    private final ProjectAssociationManager projectAssociationManager;

    public FramePlugin() {
        plugin = this;
        this.projectAssociationManager = new ProjectAssociationManager();
    }

    public String getPluginID() {
        return this.getBundle().getSymbolicName();
    }

    public static FramePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = FramePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return Platform.getResourceBundle((Bundle)this.getBundle());
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        return FramePlugin.getImageDescriptor(null, fileName);
    }

    public static ImageDescriptor getImageDescriptor(String path, String fileName) {
        URL url = FramePlugin.getIconURL(path, fileName);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static URL getIconURL(String iconFileName) {
        return FramePlugin.getIconURL(null, iconFileName);
    }

    public static URL getIconURL(String path, String iconFileName) {
        String iconPath = "icons/" + (path != null ? String.valueOf(path) + "/" : "");
        String iconpath = "/" + iconPath + iconFileName;
        Bundle bundle = FramePlugin.getDefault().getBundle();
        URL url = bundle.getEntry(iconpath);
        if (url == null) {
            logger.error("Cannot find icon \"" + iconpath + "\" in plugin \"" + bundle.getBundleId() + "\"");
        }
        return url;
    }

    public static String getFileExtensionForProjectData() {
        return "acp";
    }

    public static String getFileExtensionForTemplate() {
        return "act";
    }

    public static String getWorkspacePath(String relativePath) {
        IPath path = FramePlugin.getDefault().getStateLocation();
        File metaDataRootDirectory = path.toFile();
        String directoryPath = metaDataRootDirectory.getAbsolutePath();
        File directory = new File(directoryPath, relativePath);
        try {
            FileHelper.ensureDirectoryExistance((File)directory);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
        return directory.getPath();
    }

    public ProjectAssociationManager getFrameProjectAssociationManager() {
        return this.projectAssociationManager;
    }
}

