/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.shared.message.EOCurrentCommitVersions;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.PSCClientNotificationBus;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.List;
import java.util.Map;

public class FetchedNotificationExhausetdListener
implements PSCClientNotificationBus.IFetchedNotificationsExhaustedListener {
    private static final ILogger logger = Logger.getLogger(FetchedNotificationExhausetdListener.class);

    public void fetchedNotificationsExhausted(String serverID) {
        Map<String, List<String>> projectUID2CommitUIDs = ProjectMgr.getProjectMgr().getCurrentCommitVersions(serverID);
        if (!projectUID2CommitUIDs.isEmpty()) {
            EOCurrentCommitVersions currentCommitVersions = new EOCurrentCommitVersions(projectUID2CommitUIDs);
            EOClientRequest ackknowledgeRequest = new EOClientRequest("frame.lock", "frame.updateClientCommitVersions", (EncodableObjectBase)currentCommitVersions);
            try {
                PSCClientServiceFacade.getFacade().sendRequest(serverID, ackknowledgeRequest);
                ProjectMgr.getProjectMgr().refreshCommitVersions(serverID, projectUID2CommitUIDs);
            }
            catch (ServerNotAvailableException e) {
                logger.error("Not able to inform server about applied asynchronous updates due to ServerNotAvailableException.", (Throwable)e);
                ExceptionDialog exd = new ExceptionDialog(EclipseSWTHelper.getShell(), (Throwable)e);
                exd.open();
            }
            catch (EXServerException e) {
                logger.error("Not able to inform server about applied asynchronous updates due to EXServerException.", (Throwable)e);
                ExceptionDialog exd = new ExceptionDialog(EclipseSWTHelper.getShell(), e);
                exd.open();
            }
            catch (LoginCanceledException e) {
                logger.error("Not able to inform server about applied asynchronous updates due to LoginCanceledException.", (Throwable)e);
                ExceptionDialog exd = new ExceptionDialog(EclipseSWTHelper.getShell(), (Throwable)e);
                exd.open();
            }
            catch (UnknownServerException e) {
                logger.error("Not able to inform server about applied asynchronous updates due to UnknownServerException.", (Throwable)e);
                ExceptionDialog exd = new ExceptionDialog(EclipseSWTHelper.getShell(), (Throwable)e);
                exd.open();
            }
        }
    }
}

