/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global;

import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.itemeditors.IPropertiesSupport;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.IDetailsProvider;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.constructionelements.PlanElementConstructionElementAssignment;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModuleFactory;
import com.arcway.cockpit.frame.client.project.modules.IGeneralModuleFacade;
import com.arcway.cockpit.frame.client.project.modules.ModuleFactoryInformation;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanElementTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanElementTypeDescription;
import com.arcway.planagent.controllinginterface.planeditor.plugin.PlanEditorExtensionMgr;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.osgi.framework.Bundle;

public class ExtensionMgr {
    private static final ILogger logger = Logger.getLogger(ExtensionMgr.class);
    private static final String ANALYSE_VIEW_ELEMENT_NAME = "AnalyzeView";
    private static final String ANALYSE_VIEW_ID_ATTRIBUTE = "viewID";
    private static final String VIEW_SET_ELEMENT_NAME = "ViewSet";
    private static final String MODULE_VIEW_ID_ATTRIBUTE = "ModuleViewId";
    private static final String MODULE_VIEW_PRIORITY_ATTRIBUTE = "priority";
    private static final String PERSPECTIVE_ELEMENT_NAME = "Perspective";
    private static final String PERSPECTIVE_ID_ATTRIBUTE = "perspectiveID";
    private static final String PERSPECTIVE_PRIORITY_ATTRIBUTE = "priority";
    private static final String FASTVIEW_ID_ATTRIBUTE = "fastviewID";
    private static final String MODULE_FACTORY_ELEMENT_NAME = "ModuleFactory";
    private static final String MODULE_FACTORY_CLASS_ATTRIBUTE = "class";
    private static final String MODULE_NAME_ATTRIBUTE = "moduleName";
    private static final String MODULE_DATA_NAME_ATTRIBUTE = "moduleDataName";
    private static final String MODULE_DATA_IMAGE_ATTRIBUTE = "moduleDataImage";
    private static final String GENERAL_MODULE_FACADE_ELEMENT_NAME = "GeneralModuleFacade";
    private static final String GENERAL_MODULE_FACADE_CLASS_ATTRIBUTE = "Facade";
    private static final String PROJECTION_PREFERENCE_NODE_ELEMENT_NAME = "node";
    private static final String PROJECTION_PREFERENCE_NODE_CLASS_ATTRIBUTE = "class";
    private static final String DETAILS_PROVIDER_ELEMENT_NAME = "DetailsProvider";
    private static final String DETAILS_PROVIDER_TYPE_ID_ATTRIBUTE_NAME = "TypeID";
    private static final String DETAILS_PROVIDER_CLASS_ATTRIBUTE_NAME = "class";
    private static final String EXTENSION_POINT_ID_CONSTRUCTION_ELEMENT_TYPES = "constructionelementtypes";
    private static final String CONFIG_ELEMENT_NAME_CONSTRUCTION_ELEMENT_TYPE = "ConstructionElementTypeDescription";
    private static final String ATTR_CONSTRUCTION_ELEMENT_TYPE = "typeDescription";
    private static final String EXTENSION_POINT_ID_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENTS = "planelementconstructionelementassignments";
    private static final String CONFIG_ELEMENT_NAME_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT = "PlanElementConstructionElementAssignment";
    private static final String ATTR_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT_PLAN_ELEMENT_TYPE_ID = "planElementTypeID";
    private static final String ATTR_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT_CONSTRUCTION_ELEMENT_TYPE_ID = "constructionElementTypeID";
    private static final String ATTR_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT_CATEGORY = "category";
    private List<PlanElementConstructionElementAssignment> planElementConstructionElementAssignments;
    private static IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
    private static List<String> analyseViewIDs;
    private static List<String> moduleViewIDs;
    private static List<String> paletteViewIDs;
    private static List<String> overViewIDs;
    private static List<IPerspectiveInformation> perspectiveInformation;
    private static List<ModuleFactoryInformation> modules;
    private static boolean moduleDataExists;
    private static List<PreferenceNode> preferenceNodes;
    private static Map<String, IConfigurationElement> detailProviderConfigElements;
    private static ExtensionMgr singelton;
    private static boolean hasReadGeneralModuleFacadeExtensionPoint;
    private static int generalModuleFacadeExtensionCount;
    private static IGeneralModuleFacade generalModuleFacade;
    private static final String EXTENSION_ELEMENT_NAME = "PropertyProvider";
    private static final String EXTENSION_ATTRIBUTE_NAME = "PropertyProvider";
    private static final String EXTENSION_ELEMENT_NAME_PROPERTIESSUPPORT = "PropertiesSupport";
    private static final String EXTENSION_ATTRIBUTE_NAME_PROPERTIESSUPPORT = "PropertiesSupport";

    static {
        moduleDataExists = false;
        singelton = new ExtensionMgr();
    }

    private String getPlugInID() {
        return FramePlugin.getDefault().getPluginID();
    }

    private ExtensionMgr() {
    }

    public static ExtensionMgr getDefault() {
        return singelton;
    }

    public List<?> getExtension(String extensionPointID, String elementName, String attributeName) {
        return com.arcway.lib.eclipse.extensions.ExtensionMgr.getDefault().getExtension("com.arcway.cockpit.frame.client", extensionPointID, elementName, attributeName);
    }

    public <T> List<T> getExtension(String extensionPointID, String elementName, String attributeName, Class<T> type) {
        return com.arcway.lib.eclipse.extensions.ExtensionMgr.getDefault().getExtension("com.arcway.cockpit.frame.client", extensionPointID, elementName, attributeName, type);
    }

    public List<?> getNewInstanceOfExtension(String extensionPointID, String elementName, String attributeName) {
        return com.arcway.lib.eclipse.extensions.ExtensionMgr.getDefault().getNewInstanceOfExtension("com.arcway.cockpit.frame.client", extensionPointID, elementName, attributeName);
    }

    public <T> List<T> getNewInstanceOfExtension(String extensionPointID, String elementName, String attributeName, Class<T> type) {
        return com.arcway.lib.eclipse.extensions.ExtensionMgr.getDefault().getNewInstanceOfExtension("com.arcway.cockpit.frame.client", extensionPointID, elementName, attributeName, type);
    }

    public static List<String> getAnalyseViews() {
        if (analyseViewIDs == null) {
            ExtensionMgr.readViewsExtensionPoint();
        }
        return analyseViewIDs;
    }

    public static List<String> getModuleViews() {
        if (moduleViewIDs == null) {
            ExtensionMgr.readViewsExtensionPoint();
        }
        return moduleViewIDs;
    }

    public static List<String> getPaletteViews() {
        if (paletteViewIDs == null) {
            ExtensionMgr.readViewsExtensionPoint();
        }
        return paletteViewIDs;
    }

    public static List<String> getOverViews() {
        if (overViewIDs == null) {
            ExtensionMgr.readViewsExtensionPoint();
        }
        return overViewIDs;
    }

    private static void readViewsExtensionPoint() {
        analyseViewIDs = new ArrayList<String>();
        moduleViewIDs = new ArrayList<String>();
        paletteViewIDs = PlanEditorExtensionMgr.getDefault().getRegisteredPaletteViews();
        overViewIDs = PlanEditorExtensionMgr.getDefault().getRegisteredOverViews();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", "views");
        IExtension[] extensions = extensionPoint.getExtensions();
        OrderedStrings orderedModuleViewIDs = new OrderedStrings();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                String analyszeViewId;
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (VIEW_SET_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    String moduleViewId = currentConfigElement.getAttribute(MODULE_VIEW_ID_ATTRIBUTE);
                    int priority = Integer.parseInt(currentConfigElement.getAttribute("priority"));
                    if (moduleViewId != null) {
                        orderedModuleViewIDs.add(moduleViewId, priority);
                    }
                } else if (ANALYSE_VIEW_ELEMENT_NAME.equals(currentConfigElement.getName()) && (analyszeViewId = currentConfigElement.getAttribute(ANALYSE_VIEW_ID_ATTRIBUTE)) != null) {
                    analyseViewIDs.add(analyszeViewId);
                }
                ++n4;
            }
            ++n2;
        }
        moduleViewIDs.addAll(orderedModuleViewIDs.toStrings());
    }

    public static List<IPerspectiveInformation> getPerspectives() {
        if (perspectiveInformation == null) {
            ExtensionMgr.readPerspectivesExtensionPoint();
        }
        return perspectiveInformation;
    }

    private static void readPerspectivesExtensionPoint() {
        perspectiveInformation = new ArrayList<IPerspectiveInformation>();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", "perspectives");
        IExtension[] extensions = extensionPoint.getExtensions();
        OrderedStrings orderedIDs = new OrderedStrings();
        HashMap perspectiveFastViews = new HashMap();
        HashMap<String, Boolean> perspectiveCreateButton = new HashMap<String, Boolean>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (PERSPECTIVE_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    String moduleViewId = currentConfigElement.getAttribute(PERSPECTIVE_ID_ATTRIBUTE);
                    int priority = Integer.parseInt(currentConfigElement.getAttribute("priority"));
                    boolean createButton = priority != 999999;
                    LinkedList<String> fastViewIDs = new LinkedList<String>();
                    IConfigurationElement[] iConfigurationElementArray2 = currentConfigElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement child = iConfigurationElementArray2[n6];
                        fastViewIDs.add(child.getAttribute(FASTVIEW_ID_ATTRIBUTE));
                        ++n6;
                    }
                    perspectiveFastViews.put(moduleViewId, fastViewIDs);
                    perspectiveCreateButton.put(moduleViewId, createButton);
                    if (moduleViewId != null) {
                        orderedIDs.add(moduleViewId, priority);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ListIterator listIterator = orderedIDs.toStrings().listIterator();
        while (listIterator.hasNext()) {
            final String perspectiveID = (String)listIterator.next();
            final List fastViewIDs = (List)perspectiveFastViews.get(perspectiveID);
            final boolean createButton = (Boolean)perspectiveCreateButton.get(perspectiveID);
            IPerspectiveInformation perspective = new IPerspectiveInformation(){

                @Override
                public String getPerspectiveID() {
                    return perspectiveID;
                }

                @Override
                public List<String> getFastViewIDs() {
                    return fastViewIDs;
                }

                @Override
                public boolean createButton() {
                    return createButton;
                }
            };
            perspectiveInformation.add(perspective);
        }
    }

    public static List<PreferenceNode> getProjectionPreferenceNodes() {
        if (preferenceNodes == null) {
            ExtensionMgr.readProjectionsExtensionPoint();
        }
        assert (preferenceNodes != null) : "preferenceNodes list is null!";
        return preferenceNodes;
    }

    public static int getModuleFactoriesCount() {
        return ExtensionMgr.getModuleInformations().size();
    }

    public static List<IFMCAModuleFactory> getModuleFactories() {
        ArrayList<IFMCAModuleFactory> moduleFactories = new ArrayList<IFMCAModuleFactory>();
        for (ModuleFactoryInformation moduleInfo : ExtensionMgr.getModuleInformations()) {
            moduleFactories.add(moduleInfo.getModuleFactory());
        }
        return moduleFactories;
    }

    public static IFMCAModuleFactory getModuleFactory(int index) {
        ModuleFactoryInformation moduleInfo = ExtensionMgr.getModuleInformations().get(index);
        return moduleInfo.getModuleFactory();
    }

    public static List<String> getModuleDataNames() {
        ArrayList<String> moduleDataNames = new ArrayList<String>();
        for (ModuleFactoryInformation moduleInfo : ExtensionMgr.getModuleInformations()) {
            String dataName = moduleInfo.getModuleDataName();
            if (dataName.equals("")) continue;
            moduleDataNames.add(dataName);
        }
        return moduleDataNames;
    }

    public static String getModuleName(int index) {
        ModuleFactoryInformation moduleInfo = ExtensionMgr.getModuleInformations().get(index);
        return moduleInfo.getModuleName();
    }

    public static String getModuleDataName(int index) {
        ModuleFactoryInformation moduleInfo = ExtensionMgr.getModuleInformations().get(index);
        return moduleInfo.getModuleDataName();
    }

    public static Image getModuleDataImage(String dataName) {
        for (ModuleFactoryInformation moduleInfo : ExtensionMgr.getModuleInformations()) {
            String storedDataName = moduleInfo.getModuleDataName();
            if (!storedDataName.equals(dataName)) continue;
            return moduleInfo.getModuleDataImage();
        }
        return null;
    }

    public static int getModuleIndexByModuleName(String moduleName) {
        int index = 0;
        for (ModuleFactoryInformation moduleInformation : ExtensionMgr.getModuleInformations()) {
            String name = moduleInformation.getModuleName();
            if (name.equals(moduleName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int getModuleIndexByDataName(String dataName) {
        int index = 0;
        for (ModuleFactoryInformation moduleInformation : ExtensionMgr.getModuleInformations()) {
            String name = moduleInformation.getModuleDataName();
            if (name.equals(dataName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean isModuleDataRegistered() {
        if (modules == null) {
            ExtensionMgr.readModulesExtensionPoint();
        }
        return moduleDataExists;
    }

    public static List<ModuleFactoryInformation> getModuleInformations() {
        if (modules == null) {
            ExtensionMgr.readModulesExtensionPoint();
        }
        return modules;
    }

    public static Map<String, IDetailsProvider> getDetailProviders() {
        if (detailProviderConfigElements == null) {
            ExtensionMgr.readDetailProvidersExtensionPoint();
        }
        HashMap<String, IDetailsProvider> detailsProviders = new HashMap<String, IDetailsProvider>(detailProviderConfigElements.size());
        for (Map.Entry<String, IConfigurationElement> entry : detailProviderConfigElements.entrySet()) {
            try {
                detailsProviders.put(entry.getKey(), (IDetailsProvider)entry.getValue().createExecutableExtension("class"));
            }
            catch (CoreException e) {
                logger.warn("Error while craeting registered detail providers " + e.getStatus(), (Throwable)e);
            }
        }
        return detailsProviders;
    }

    public static IDetailsProvider getDetailProvider(String dataTypeID) {
        IConfigurationElement configElement;
        if (detailProviderConfigElements == null) {
            ExtensionMgr.readDetailProvidersExtensionPoint();
        }
        if ((configElement = detailProviderConfigElements.get(dataTypeID)) != null) {
            try {
                return (IDetailsProvider)configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                logger.warn("Error while craeting registered detail providers " + e.getStatus(), (Throwable)e);
            }
        }
        return null;
    }

    private static void readModulesExtensionPoint() {
        IExtension[] extensions;
        modules = new ArrayList<ModuleFactoryInformation>();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", "modules");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (MODULE_FACTORY_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    try {
                        IFMCAModuleFactory moduleFactory = (IFMCAModuleFactory)currentConfigElement.createExecutableExtension("class");
                        String moduleName = currentConfigElement.getAttribute(MODULE_NAME_ATTRIBUTE);
                        String dataName = currentConfigElement.getAttribute(MODULE_DATA_NAME_ATTRIBUTE);
                        if (dataName == null) {
                            dataName = "";
                        } else {
                            moduleDataExists = true;
                        }
                        String dataIcon = currentConfigElement.getAttribute(MODULE_DATA_IMAGE_ATTRIBUTE);
                        Image image = ExtensionMgr.getImageFromExtension(dataIcon, currentExtension);
                        ResourceDisposer.markResourceAsSingleton((Resource)image);
                        modules.add(new ModuleFactoryInformation(moduleFactory, moduleName, dataName, image));
                    }
                    catch (CoreException e) {
                        FramePlugin.getDefault().getLog().log(e.getStatus());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static int getGeneralModuleFacadeExtensionCount() {
        ExtensionMgr.readGeneralModuleFacadeExtensionPoint();
        return generalModuleFacadeExtensionCount;
    }

    public static IGeneralModuleFacade getGeneralModuleFacade() {
        ExtensionMgr.readGeneralModuleFacadeExtensionPoint();
        return generalModuleFacade;
    }

    private static void readGeneralModuleFacadeExtensionPoint() {
        if (!hasReadGeneralModuleFacadeExtensionPoint) {
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", "generalmodulefacade");
            IExtension[] extensions = extensionPoint.getExtensions();
            generalModuleFacadeExtensionCount = extensions.length;
            generalModuleFacade = null;
            if (extensions.length > 0) {
                IExtension firstExtension = extensions[0];
                IConfigurationElement[] configElements = firstExtension.getConfigurationElements();
                assert (configElements.length == 1 && configElements[0].getName().equals(GENERAL_MODULE_FACADE_ELEMENT_NAME));
                try {
                    generalModuleFacade = (IGeneralModuleFacade)configElements[0].createExecutableExtension(GENERAL_MODULE_FACADE_CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    FramePlugin.getDefault().getLog().log(e.getStatus());
                }
            }
            hasReadGeneralModuleFacadeExtensionPoint = true;
        }
    }

    private static void readProjectionsExtensionPoint() {
        IExtension[] extensions;
        preferenceNodes = new ArrayList<PreferenceNode>();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", "projectionPreferencePages");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (PROJECTION_PREFERENCE_NODE_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    try {
                        PreferenceNode preferenceNode = (PreferenceNode)currentConfigElement.createExecutableExtension("class");
                        preferenceNodes.add(preferenceNode);
                    }
                    catch (CoreException e) {
                        FramePlugin.getDefault().getLog().log(e.getStatus());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void readDetailProvidersExtensionPoint() {
        IExtension[] extensions;
        detailProviderConfigElements = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", "detailproviders");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (DETAILS_PROVIDER_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    String typeID = currentConfigElement.getAttribute(DETAILS_PROVIDER_TYPE_ID_ATTRIBUTE_NAME);
                    detailProviderConfigElements.put(typeID, currentConfigElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public List<IConstructionElementTypeDescription> getCurrentConstructionElementTypes() {
        ArrayList<IConstructionElementTypeDescription> types = new ArrayList<IConstructionElementTypeDescription>(this.getCurrentAndDeprecatedConstructionElementTypes());
        return types;
    }

    public List<IConstructionElementTypeDescription> getCurrentAndDeprecatedConstructionElementTypes() {
        return this.getExtension(EXTENSION_POINT_ID_CONSTRUCTION_ELEMENT_TYPES, CONFIG_ELEMENT_NAME_CONSTRUCTION_ELEMENT_TYPE, ATTR_CONSTRUCTION_ELEMENT_TYPE, IConstructionElementTypeDescription.class);
    }

    public URL getConstructionElementIconForType(String constructionElementTypeID) throws EXConstructionElementTypeUnknown {
        assert (constructionElementTypeID != null) : "constructionElementTypeID can't be null";
        IConstructionElementTypeDescription description = this.getConstructionElementTypeDescriptionForType(constructionElementTypeID);
        if (description != null) {
            return description.getIconURL();
        }
        return null;
    }

    public String getConstructionElementNameForType(String constructionElementTypeID) throws EXConstructionElementTypeUnknown {
        return this.getConstructionElementNameForType(constructionElementTypeID, Locale.getDefault());
    }

    public String getConstructionElementNameForType(String constructionElementTypeID, Locale locale) throws EXConstructionElementTypeUnknown {
        assert (constructionElementTypeID != null) : "constructionElementTypeID can't be null";
        IConstructionElementTypeDescription description = this.getConstructionElementTypeDescriptionForType(constructionElementTypeID);
        if (description != null) {
            return description.getConstructionElementTypeName(locale);
        }
        return "";
    }

    public String getConstructionElementNameInPluralForType(String constructionElementTypeID, Locale locale) throws EXConstructionElementTypeUnknown {
        assert (constructionElementTypeID != null) : "constructionElementTypeID can't be null";
        IConstructionElementTypeDescription description = this.getConstructionElementTypeDescriptionForType(constructionElementTypeID);
        if (description != null) {
            return description.getConstructionElementTypeNameInPlural(locale);
        }
        return "";
    }

    public String getConstructionElementNameInPluralForType(String constructionElementTypeID) throws EXConstructionElementTypeUnknown {
        return this.getConstructionElementNameInPluralForType(constructionElementTypeID, Locale.getDefault());
    }

    public IConstructionElementTypeDescription getConstructionElementTypeDescriptionForType(String constructionElementTypeID) throws EXConstructionElementTypeUnknown {
        assert (constructionElementTypeID != null) : "constructionElementTypeID can't be null";
        IConstructionElementTypeDescription description = null;
        for (IConstructionElementTypeDescription currentDescription : this.getCurrentAndDeprecatedConstructionElementTypes()) {
            if (!currentDescription.getConstructionElementTypeID().equals(constructionElementTypeID)) continue;
            description = currentDescription;
            break;
        }
        if (description == null) {
            throw new EXConstructionElementTypeUnknown(constructionElementTypeID);
        }
        return description;
    }

    public IConstructionElementTypeDescription getDefaultConstructionElementTypeDescription(String planElementTypeID) {
        Collection<IConstructionElementTypeDescription> descriptions;
        IConstructionElementTypeDescription description = null;
        try {
            descriptions = this.getConstructionElementTypeDescriptionForPlanElementType(planElementTypeID);
        }
        catch (EXPlanElementTypeUnknown e) {
            descriptions = Collections.emptyList();
        }
        description = !descriptions.isEmpty() ? descriptions.iterator().next() : IConstructionElementTypeDescription.UNKNOWN;
        return description;
    }

    public Collection<IConstructionElementTypeDescription> getConstructionElementTypeDescriptionForPlanElementType(String planElementType) throws EXPlanElementTypeUnknown {
        PlanAgentExtensionMgr.getDefault().getPlanElementTypeDescriptionForType(planElementType);
        ArrayList<String> constructionElementTypeIds = new ArrayList<String>();
        for (PlanElementConstructionElementAssignment assignment : this.getPlanElementConstructionElementAssignments()) {
            if (!planElementType.equals(assignment.getPlanElementTypeID())) continue;
            constructionElementTypeIds.add(assignment.getConstructionElementTypeID());
        }
        ArrayList<IConstructionElementTypeDescription> constructionElementTypeDescriptions = new ArrayList<IConstructionElementTypeDescription>();
        for (IConstructionElementTypeDescription constuctionElementTypeDescription : this.getCurrentAndDeprecatedConstructionElementTypes()) {
            boolean toAdd = false;
            for (String constructionElementTypeID : constructionElementTypeIds) {
                toAdd |= constructionElementTypeID.equals(constuctionElementTypeDescription.getConstructionElementTypeID());
            }
            if (!toAdd) continue;
            constructionElementTypeDescriptions.add(constuctionElementTypeDescription);
        }
        return constructionElementTypeDescriptions;
    }

    public Collection<PlanElementTypeDescription> getPlanElementTypeDescriptionForConstructionElementType(String constructionElementType) {
        ArrayList<String> planElementTypeIds = new ArrayList<String>();
        for (PlanElementConstructionElementAssignment assignment : this.getPlanElementConstructionElementAssignments()) {
            if (!constructionElementType.equals(assignment.getConstructionElementTypeID())) continue;
            planElementTypeIds.add(assignment.getPlanElementTypeID());
        }
        ArrayList<PlanElementTypeDescription> planElementTypeDescriptions = new ArrayList<PlanElementTypeDescription>();
        for (PlanElementTypeDescription planElementTypeDescription : PlanAgentExtensionMgr.getDefault().getPlanElementTypeDescriptions()) {
            boolean toAdd = false;
            Iterator j = planElementTypeIds.iterator();
            while (!toAdd && j.hasNext()) {
                String planElementTypeID = (String)j.next();
                toAdd |= planElementTypeID.equals(planElementTypeDescription.getPlanElementTypeID());
            }
            if (!toAdd) continue;
            planElementTypeDescriptions.add(planElementTypeDescription);
        }
        return planElementTypeDescriptions;
    }

    public List<PlanElementConstructionElementAssignment> getPlanElementConstructionElementAssignments() {
        if (this.planElementConstructionElementAssignments == null) {
            IExtension[] extensions;
            this.planElementConstructionElementAssignments = new ArrayList<PlanElementConstructionElementAssignment>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENTS);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT.equals(currentConfigElement.getName())) {
                        String planElementTypeID = currentConfigElement.getAttribute(ATTR_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT_PLAN_ELEMENT_TYPE_ID);
                        String constructionElementTypeID = currentConfigElement.getAttribute(ATTR_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT_CONSTRUCTION_ELEMENT_TYPE_ID);
                        String category = currentConfigElement.getAttribute(ATTR_PLAN_ELEMENT_CONSTRUCTION_ELEMENT_ASSIGNMENT_CATEGORY);
                        if (planElementTypeID != null && constructionElementTypeID != null) {
                            PlanElementConstructionElementAssignment planElementConstructionElementAssignment = new PlanElementConstructionElementAssignment(planElementTypeID, constructionElementTypeID, category);
                            this.planElementConstructionElementAssignments.add(planElementConstructionElementAssignment);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.planElementConstructionElementAssignments;
    }

    public PlanElementConstructionElementAssignment getDefaultPlanElementConstructionElementAssignmentsForPlanElement(String planElementTypID) {
        for (PlanElementConstructionElementAssignment singleAssignments : this.getPlanElementConstructionElementAssignments()) {
            if (!planElementTypID.equals(singleAssignments.getPlanElementTypeID())) continue;
            return singleAssignments;
        }
        return null;
    }

    public List<IPropertiesListEntry> getAllPropertiesProvider() {
        return ExtensionMgr.getDefault().getExtension("propertyprovider", "PropertyProvider", "PropertyProvider", IPropertiesListEntry.class);
    }

    public List<IPropertiesSupport> getAllPropertiesSupports() {
        return ExtensionMgr.getDefault().getExtension("propertiessupports", "PropertiesSupport", "PropertiesSupport", IPropertiesSupport.class);
    }

    private static Image getImageFromExtension(String imageLocation, IExtension extension) {
        if (imageLocation == null || extension == null) {
            return null;
        }
        String namespace = extension.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        URL plugInURL = bundle.getEntry("/");
        try {
            URL url = new URL(plugInURL, imageLocation);
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (MalformedURLException e) {
            logger.error("Invalid image URL: " + plugInURL.toExternalForm() + " -> " + imageLocation, (Throwable)e);
            return null;
        }
    }

    class ExtensionPointContent {
        private final HashMap<String, ListMap<String, Object>> extensions = new HashMap();

        public ExtensionPointContent(String extensionPointID) {
            this("com.arcway.cockpit.frame.client", extensionPointID);
        }

        public ExtensionPointContent(String pluginID, String extensionPointID) {
            IExtension[] allExtensions;
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(pluginID, extensionPointID);
            IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
            int n = allExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    try {
                        String[] attributeNames;
                        String[] stringArray = attributeNames = currentConfigElement.getAttributeNames();
                        int n5 = attributeNames.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String element = stringArray[n6];
                            Object extension = currentConfigElement.createExecutableExtension(element);
                            this.addExtension(currentConfigElement.getName(), element, extension);
                            ++n6;
                        }
                    }
                    catch (CoreException e) {
                        FramePlugin.getDefault().getLog().log(e.getStatus());
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public List<?> getExtensions(String elementName, String attributeName) {
            ListMap<String, Object> elements = this.extensions.get(elementName);
            if (elements == null) {
                return new ArrayList();
            }
            return elements.get((Object)attributeName);
        }

        private void addExtension(String elementName, String attributeName, Object provider) {
            if (!this.extensions.containsKey(elementName)) {
                this.extensions.put(elementName, (ListMap<String, Object>)new ListMap());
            }
            ListMap<String, Object> elements = this.extensions.get(elementName);
            elements.add((Object)attributeName, provider);
        }
    }

    public static interface IPerspectiveInformation {
        public String getPerspectiveID();

        public List<String> getFastViewIDs();

        public boolean createButton();
    }

    private static class OrderedString {
        private final String string;
        private final int order;

        private OrderedString(String string, int order) {
            this.string = string;
            this.order = order;
        }
    }

    private static class OrderedStrings {
        private final List<OrderedString> orderedStrings = new LinkedList<OrderedString>();

        private OrderedStrings() {
        }

        private void add(String string, int order) {
            int index = 0;
            while (index < this.orderedStrings.size()) {
                OrderedString orderedString = this.orderedStrings.get(index);
                if (orderedString.order > order) {
                    this.orderedStrings.add(index, new OrderedString(string, order));
                    return;
                }
                ++index;
            }
            this.orderedStrings.add(new OrderedString(string, order));
        }

        private List<String> toStrings() {
            ArrayList<String> stringList = new ArrayList<String>(this.orderedStrings.size());
            for (OrderedString currentOrderedString : this.orderedStrings) {
                stringList.add(currentOrderedString.string);
            }
            return stringList;
        }
    }
}

