/*
 * Decompiled with CFR 0.152.
 */
package de.plans.fmca.client;

import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.Messages;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.parameter.EOParameterSetList;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.shared.message.EOServer;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class FMCAServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ILabelProvider,
IStructuredContentProvider,
ISelectionChangedListener {
    private static final ILogger logger = Logger.getLogger(FMCAServerPreferencePage.class);
    private static final int VIEW = 0;
    private static final int MODIFY = 1;
    private static final int ADD = 2;
    private static final int TIMER_RESOLUTION = 1000;
    public static final int MIN_TIMER_INTERVAL_SEC = 10;
    public static final int DEFAULT_TIMER_INTERVAL_SEC = 180;
    private static UUIDGenerator uidGenerator = new UUIDGenerator();
    private boolean userHasDoneSomething = false;
    private ListViewer viewer;
    private Button btnAdd;
    private Button btnModify;
    private Button btnDelete;
    private Button btnTest;
    private Composite preferencePageParent;
    private Text fldServerName;
    private Text fldServerURL;
    private Text fldTimerInterval;
    private XMLConfigParameterMgr parameterMgr;
    private EOParameterSetList parameterServerList;
    private List<EOServer> localServerList;
    private final List<EOServer> addedServerList = new ArrayList<EOServer>();
    private final List<EOServer> deletedServerList = new ArrayList<EOServer>();
    private final List<EOServer> modifiedServerList = new ArrayList<EOServer>();
    private int state = 0;
    boolean modified = false;
    EOServer currentServer;

    public void init(IWorkbench workbench) {
        this.parameterMgr = PSCServices.getServiceFacade().getParameterManager();
        this.parameterServerList = (EOParameterSetList)this.parameterMgr.getSubtree("serverList");
        this.localServerList = new ArrayList<EOServer>();
        this.localServerList.addAll(this.parameterServerList.getArrayList());
    }

    public void initForModify(Composite parentPage, EOServer server) {
        this.userHasDoneSomething = true;
        this.init(PlatformUI.getWorkbench());
        this.state = 1;
        this.createContent(parentPage);
        this.selectServer(server);
        this.displayServerDetails(this.getFirstSelectedServer());
        this.state = 1;
        this.setWidgetState();
        this.fldServerName.setFocus();
        this.checkValidState();
    }

    public void initForAdd(Composite parentPage) {
        this.init(PlatformUI.getWorkbench());
        this.state = 2;
        this.createContent(parentPage);
        this.displayServerDetails(this.getFirstSelectedServer());
        this.setWidgetState();
        this.setValid(false);
    }

    private void selectServer(EOServer server) {
        StructuredSelection selection = new StructuredSelection(Collections.singletonList(server));
        this.viewer.setSelection((ISelection)selection, true);
    }

    public Control createContents(Composite parent) {
        this.preferencePageParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.preferencePageParent.setLayout((Layout)layout);
        this.preferencePageParent.setFont(parent.getFont());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.preferencePageParent.setLayoutData((Object)gridData);
        this.createContent(this.preferencePageParent);
        this.setWidgetState();
        this.modified = false;
        return this.preferencePageParent;
    }

    public void createContent(Composite parentPage) {
        this.viewer = new ListViewer(parentPage, 2560);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setInput((Object)this);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 50;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getList().setLayoutData((Object)gridData);
        Composite btnBar = new Composite(parentPage, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        btnBar.setLayout((Layout)layout);
        this.btnAdd = new Button(btnBar, 8);
        this.btnAdd.setText(Messages.getString("FMCAServerPreferencePage.Add_1"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FMCAServerPreferencePage.this.addServer();
            }
        });
        this.btnModify = new Button(btnBar, 8);
        this.btnModify.setText(Messages.getString("FMCAServerPreferencePage.Modify_2"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnModify.setLayoutData((Object)gridData);
        this.btnModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FMCAServerPreferencePage.this.modifyServer();
            }
        });
        this.btnDelete = new Button(btnBar, 8);
        this.btnDelete.setText(Messages.getString("FMCAServerPreferencePage.Delete_3"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnDelete.setLayoutData((Object)gridData);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FMCAServerPreferencePage.this.deleteServer();
            }
        });
        this.btnTest = new Button(btnBar, 8);
        this.btnTest.setText(Messages.getString("FMCAServerPreferencePage.Test_14"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnTest.setLayoutData((Object)gridData);
        this.btnTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FMCAServerPreferencePage.this.testSelectedServer();
            }
        });
        this.btnTest.setVisible(false);
        Group grpDetails = new Group(parentPage, 32);
        grpDetails.setText(Messages.getString("FMCAServerPreferencePage.Details_4"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        grpDetails.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        grpDetails.setLayoutData((Object)gridData);
        Label lblServerName = new Label((Composite)grpDetails, 0);
        lblServerName.setText(Messages.getString("FMCAServerPreferencePage.Name_5"));
        lblServerName.setLayoutData((Object)new GridData(128));
        this.fldServerName = new Text((Composite)grpDetails, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldServerName.setLayoutData((Object)gridData);
        this.fldServerName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FMCAServerPreferencePage.this.checkValidState();
            }
        });
        Label lblServerURL = new Label((Composite)grpDetails, 0);
        lblServerURL.setText(Messages.getString("FMCAServerPreferencePage.URL_6"));
        lblServerURL.setLayoutData((Object)new GridData(128));
        this.fldServerURL = new Text((Composite)grpDetails, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldServerURL.setLayoutData((Object)gridData);
        this.fldServerURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FMCAServerPreferencePage.this.checkValidState();
            }
        });
        Label lblTimer = new Label((Composite)grpDetails, 0);
        lblTimer.setText(Messages.getString("FMCAServerPreferencePage.Keep_Alive_Timer_(ms)_7"));
        lblTimer.setLayoutData((Object)new GridData(128));
        this.fldTimerInterval = new Text((Composite)grpDetails, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldTimerInterval.setLayoutData((Object)gridData);
        this.fldTimerInterval.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FMCAServerPreferencePage.this.checkValidState();
            }
        });
        if (this.state == 2 || this.state == 1) {
            this.viewer.getControl().setVisible(false);
            btnBar.setVisible(false);
        }
    }

    private void addServer() {
        this.state = 2;
        this.setWidgetState();
        this.displayServerDetails(null);
    }

    private void deleteServer() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            for (EOServer deletedServer : selection) {
                String msg = String.valueOf(Messages.getString("FMCAServerPreferencePage.Do_you_really_want_to_delete_the_server__2")) + deletedServer.getServerName() + "?";
                msg = String.valueOf(msg) + Messages.getString("FMCAServerPreferencePage._nNote__The_local_configuration_and_cached_data_of_the_projects_of_this_server_will_be_deleted_too._4");
                MessageDialog removeProjectDialog = new MessageDialog(this.getShell(), Messages.getString("FMCAServerPreferencePage.Delete_Server_5"), null, msg, 3, new String[]{Messages.getString("FMCAServerPreferencePage.Yes_6"), Messages.getString("FMCAServerPreferencePage.No_7")}, 0);
                int success = removeProjectDialog.open();
                if (success != 0) continue;
                this.localServerList.remove(deletedServer);
                if (!this.addedServerList.contains(deletedServer)) {
                    this.deletedServerList.add(deletedServer);
                } else {
                    this.addedServerList.remove(deletedServer);
                }
                if (!this.modifiedServerList.contains(deletedServer)) continue;
                this.modifiedServerList.remove(deletedServer);
            }
            this.viewer.refresh();
            this.modified = true;
            this.state = 0;
            this.setWidgetState();
        }
    }

    private void testSelectedServer() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        for (EOServer server : selection) {
            String error = this.testServerConnection(server);
            if (error == null) {
                MessageDialog mDialog = new MessageDialog(this.getShell(), Messages.getString("FMCAServerPreferencePage.Testing_server..._8"), null, String.valueOf(Messages.getString("FMCAServerPreferencePage.Server__9")) + server.getServerURL() + Messages.getString("FMCAServerPreferencePage._found._10"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                continue;
            }
            String msg = String.valueOf(Messages.getString("FMCAServerPreferencePage.Unable_to_connect_to_server__12")) + server.getServerURL() + ".";
            msg = String.valueOf(msg) + Messages.getString("FMCAServerPreferencePage._nReason___14") + error;
            MessageDialog mDialog = new MessageDialog(this.getShell(), Messages.getString("FMCAServerPreferencePage.Testing_server..._11"), null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
        }
    }

    public String testServerConnection(EOServer server) {
        try {
            URL url = new URL(server.getServerURL());
            String host = url.getHost();
            int port = url.getPort();
            if (port < 0) {
                port = url.getDefaultPort();
            }
            Socket s = new Socket(host, port);
            s.close();
            return null;
        }
        catch (Throwable ta) {
            logger.error(ta);
            return ta.getLocalizedMessage();
        }
    }

    private void modifyServer() {
        this.state = 1;
        this.setWidgetState();
        this.displayServerDetails(this.getFirstSelectedServer());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.localServerList = this.parameterServerList.getArrayList();
        this.viewer.refresh();
        this.displayServerDetails(this.getFirstSelectedServer());
        this.state = 0;
        this.setWidgetState();
    }

    public void performApply() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 2: {
                EOServer newServer = new EOServer();
                newServer.setServerID(uidGenerator.getUUID());
                newServer.setServerName(this.fldServerName.getText().trim());
                newServer.setServerURL(this.fldServerURL.getText().trim());
                this.localServerList.add(newServer);
                if (!this.deletedServerList.contains(newServer)) {
                    this.addedServerList.add(newServer);
                } else {
                    this.deletedServerList.remove(newServer);
                }
                this.setTimerInterval(newServer);
                this.viewer.add((Object)newServer);
                this.viewer.getList().select(this.viewer.getList().getItemCount());
                this.modified = true;
                this.state = 0;
                this.setWidgetState();
                break;
            }
            case 1: {
                this.currentServer.setServerName(this.fldServerName.getText().trim());
                this.currentServer.setServerURL(this.fldServerURL.getText().trim());
                this.setTimerInterval(this.currentServer);
                if (!this.addedServerList.contains(this.currentServer) && !this.modifiedServerList.contains(this.currentServer)) {
                    this.modifiedServerList.add(this.currentServer);
                }
                this.viewer.update((Object)this.currentServer, null);
                this.modified = true;
                this.state = 0;
                this.setWidgetState();
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    private void setTimerInterval(EOServer server) {
        String timeIntervalString = this.fldTimerInterval.getText();
        try {
            int interval_ms = Integer.parseInt(timeIntervalString) * 1000;
            if (interval_ms > 0) {
                server.setTimerInterval(interval_ms);
            }
        }
        catch (NumberFormatException e) {
            logger.error(String.valueOf(Messages.getString("FMCAServerPreferencePage.setTimerInterval()_-_Invalid_Timer_Interval__8")) + timeIntervalString, (Throwable)e);
        }
    }

    public boolean performOk() {
        this.performApply();
        if (this.modified) {
            try {
                this.parameterServerList.setNewElements(this.localServerList);
                this.parameterMgr.commitParameters();
                for (EOServer server : this.addedServerList) {
                    PSCServices.getServiceFacade().getRequestForwarder().addServerConnection(server);
                }
                for (EOServer server : this.modifiedServerList) {
                    PSCServices.getServiceFacade().getRequestForwarder().modifyServerConnection(server);
                }
                for (EOServer server : this.deletedServerList) {
                    PSCServices.getServiceFacade().getRequestForwarder().removeServerConnection(server);
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private void setWidgetState() {
        boolean serverSelected = !this.viewer.getSelection().isEmpty();
        switch (this.state) {
            case 0: {
                this.fldServerName.setEnabled(false);
                this.fldServerURL.setEnabled(false);
                this.fldTimerInterval.setEnabled(false);
                if (serverSelected) {
                    this.btnDelete.setEnabled(true);
                    this.btnTest.setEnabled(true);
                    this.btnModify.setEnabled(true);
                    this.btnAdd.setEnabled(true);
                    break;
                }
                this.btnDelete.setEnabled(false);
                this.btnTest.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnAdd.setEnabled(true);
                break;
            }
            case 2: {
                this.fldServerName.setEnabled(true);
                this.fldServerURL.setEnabled(true);
                this.fldTimerInterval.setEnabled(false);
                this.btnDelete.setEnabled(false);
                this.btnTest.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnAdd.setEnabled(false);
                break;
            }
            case 1: {
                this.fldServerName.setEnabled(true);
                this.fldServerURL.setEnabled(true);
                this.fldTimerInterval.setEnabled(false);
                this.btnDelete.setEnabled(false);
                this.btnTest.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnAdd.setEnabled(true);
                break;
            }
        }
    }

    private void checkValidState() {
        this.setMessage(null);
        this.setErrorMessage(null);
        switch (this.state) {
            case 0: {
                this.setValid(true);
                break;
            }
            case 1: 
            case 2: {
                if (this.fldServerName.getText().length() == 0) {
                    if (this.userHasDoneSomething) {
                        this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Server_Name_is_missing._9"));
                    } else {
                        this.setMessage(Messages.getString("FMCAServerPreferencePage.Server_Name_is_missing._9"));
                    }
                    this.setValid(false);
                    return;
                }
                this.userHasDoneSomething = true;
                for (EOServer serverInList : this.localServerList) {
                    if (this.currentServer != null) {
                        if (!serverInList.getServerName().equals(this.fldServerName.getText()) || serverInList.getServerID().equals(this.currentServer.getServerID())) continue;
                        this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Server_name_already_in_use._1"));
                        this.setValid(false);
                        return;
                    }
                    if (!serverInList.getServerName().equals(this.fldServerName.getText())) continue;
                    this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Server_name_already_in_use._1"));
                    this.setValid(false);
                    return;
                }
                if (this.fldServerURL.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Server_URL_is_missing._10"));
                    this.setValid(false);
                    return;
                }
                if (!this.fldServerURL.getText().startsWith("http://") && !this.fldServerURL.getText().startsWith("https://")) {
                    this.setMessage(Messages.getString("FMCAServerPreferencePage.Server_URL_StartsNotWithHttp"), 2);
                    this.userHasDoneSomething = true;
                } else if (!this.fldServerURL.getText().endsWith("/")) {
                    this.setMessage(Messages.getString("FMCAServerPreferencePage.Server_URL_EndsNotWithSlash"), 2);
                    this.userHasDoneSomething = true;
                } else {
                    this.userHasDoneSomething = true;
                }
                if (this.fldTimerInterval.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Keep_Alive_Timer_not_set._11"));
                    this.setValid(false);
                    return;
                }
                String timeString = this.fldTimerInterval.getText();
                try {
                    int interval_sec = Integer.parseInt(timeString);
                    if (interval_sec < 10) {
                        this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Keep_Alive_Timer_must_be_positive._12"));
                        this.setValid(false);
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    this.fldTimerInterval.setText(timeString.substring(0, timeString.length() - 1));
                    this.setErrorMessage(Messages.getString("FMCAServerPreferencePage.Only_numbers_allowed._13"));
                    this.setValid(false);
                    return;
                }
                this.setValid(true);
                break;
            }
        }
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        EOServer server = (EOServer)element;
        return String.valueOf(server.getServerName()) + " (" + server.getServerURL() + ")";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        return this.localServerList.toArray();
    }

    public void inputChanged(Viewer viewerObj, Object oldInput, Object newInput) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.state = 0;
        this.displayServerDetails(this.getFirstSelectedServer());
        this.setWidgetState();
    }

    private EOServer getFirstSelectedServer() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        return (EOServer)selection.getFirstElement();
    }

    private void displayServerDetails(EOServer data) {
        this.currentServer = data;
        if (data == null) {
            this.fldServerName.setText("");
            this.fldServerURL.setText("");
            this.fldTimerInterval.setText(String.valueOf(180));
        } else {
            this.fldServerName.setText(data.getServerName());
            this.fldServerURL.setText(data.getServerURL());
            this.fldTimerInterval.setText(String.valueOf(data.getTimerInterval() / 1000));
        }
        this.fldServerName.setSelection(0, this.fldServerName.getText().length());
        this.fldServerURL.setSelection(0, this.fldServerURL.getText().length());
        this.fldTimerInterval.setSelection(0, this.fldTimerInterval.getText().length());
    }
}

